﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using FuzzTalk;
using FuzzTalk.Actions;
using FuzzTalkUI.Views;
using FuzzTalkUI.Models;

namespace FuzzTalkUI.ViewModels
{
    public class ActionPickerViewModel : BaseViewModel
    {
        private ObservableCollection<Type> _actionTypes = new ObservableCollection<Type>()
        {
            typeof(AttachDebugger), typeof(DetachDebugger), typeof(TcpConnect),
            typeof(Disconnect), typeof(Send), typeof(SendFuzz), typeof(Receive),
            typeof(FuzzTalkSleep), 
        };

        public ObservableCollection<Type> ActionTypes
        {
            get { return _actionTypes; }
        }

        private Type _SelectedActionType;

        public Type SelectedActionType
        {
            get { return _SelectedActionType; }
            set
            {
                _SelectedActionType = value;

                InvokePropertyChanged("SelectedActionType");
            }
        }

        private bool _InitAction;

        public bool InitAction
        {
            get { return _InitAction; }
            set
            {
                _InitAction = value;

                _StandardAction = false;
                _CleanupAction = false;

                InvokePropertyChanged("InitAction", "StandardAction", "CleanupAction");
            }
        }

        private bool _StandardAction = true;

        public bool StandardAction
        {
            get { return _StandardAction; }
            set
            {
                _StandardAction = value;

                _InitAction = false;
                _CleanupAction = false;

                InvokePropertyChanged("InitAction", "StandardAction", "CleanupAction");
            }
        }

        private bool _CleanupAction;

        public bool CleanupAction
        {
            get { return _CleanupAction; }
            set
            {
                _CleanupAction = value;

                _StandardAction = false;
                _InitAction = false;

                InvokePropertyChanged("CleanupAction");
            }
        }


        public ActionPickerViewModel()
        {
            SelectedActionType = _actionTypes.First();
        }
    }
}
