---
title: "SMB Exploiter"
draft: false
description: "Exploits SMB"
tags: ["exploiter", "smb", "brute force"]
pre: "<i class='fa fa-folder-open'></i> "
---

## SMB

[SMB (Server Message Block)](https://en.wikipedia.org/wiki/Server_Message_Block)
is a network protocol primarily used in Windows for sharing and communication
between computers on a network. Besides resource sharing, SMB supports remote
procedure calls (RPC), which allows executing arbitrary commands on remote
systems using command line utilities such as `psexec` and `smbexec`. This is
generally used for administrative tasks and remote management.

## Exploitation

Attackers that can successfully authenticate to a machine via the SMB service
can run arbitrary commands on the victim machine. This allows the attacker to
perform actions such as installing malware, exfiltrating data, or pivoting and
moving laterally through the network. Infection Monkey's SMB exploiter uses
brute-force to attempt to propagate to a victim via SMB.

![SMB Configuration](
/images/island/configuration-page/smb-exploiter-configuration.png
"SMB Configuration")

### Credentials used

The SMB exploiter uses [user-configured credentials](
/usage/configuration/credentials) as well as credentials collected from other
victims for brute-forcing. All possible combinations of usernames, passwords,
LM hashes, and NT hashes are used, prioritizing pairs provided by the user in
the configuration.

## Mitigation

1. Change user passwords to complex passwords that are not shared with other
   computers on the network.

## See also
- [SMB exploiter reference documentation](/reference/exploiters/smb)
