---
title: "Hadoop"
draft: false
description: "Reference material for the Hadoop exploiter"
pre: "<i class='fas fa-feather-pointed'></i> "
---
{{< table_of_contents >}}

## Supported operating systems

| Operating system | Attack from                 | Target                      |
| :--------------- | :-------------------------- | :-------------------------- |
| Linux            | {{< os-icon-supported >}}   | {{< os-icon-supported >}}   |
| Windows          | {{< os-icon-supported >}}   | {{< os-icon-supported >}}   |

## Configuration

<!--
This documentation was autogenerated by passing the plugin's config-schema.json
through https://github.com/adobe/jsonschema2md. It was then modified by hand to
remove extraneous information.
-->

| Property                                                            | Type      | Required | Nullable       |
| :------------------------------------------------------------------ | :-------- | :------- | :------------- |
| [target\_ports](#target_ports)                                      | `array`   | Optional | cannot be null |
| [try\_all\_discovered\_http\_ports](#try_all_discovered_http_ports) | `boolean` | Optional | cannot be null |
| [request\_timeout](#request_timeout)                                | `number`  | Optional | cannot be null |
| [agent\_binary\_download\_timeout](#agent_binary_download_timeout)  | `number`  | Optional | cannot be null |
| [yarn\_application\_suffix](#yarn_application_suffix)               | `string`  | Optional | cannot be null |

### target\_ports

A list of HTTP ports that the Hadoop exploiter will try to exploit.

`target_ports`

* is optional

* Type: `integer[]`

* cannot be null

#### target\_ports Default Value

The default value is:

```json
[
  8088
]
```

### try\_all\_discovered\_http\_ports

Attempt to exploit Hadoop on all HTTP ports discovered from network scanning.

`try_all_discovered_http_ports`

* is optional

* Type: `boolean`

* cannot be null

### request\_timeout

The maximum time (in seconds) to wait for a response from a Hadoop server.

`request_timeout`

* is optional

* Type: `number`

* cannot be null

#### request\_timeout Constraints

**minimum (exclusive)**: the value of this number must be greater than: `0`

#### request\_timeout Default Value

The default value is:

```json
15
```

### agent\_binary\_download\_timeout

The maximum time (in seconds) to wait for a successfully exploited Hadoop server to download the agent binary.

`agent_binary_download_timeout`

* is optional

* Type: `number`

* cannot be null

#### agent\_binary\_download\_timeout Constraints

**minimum (exclusive)**: the value of this number must be greater than: `0`

#### agent\_binary\_download\_timeout Default Value

The default value is:

```json
60
```

### yarn\_application\_suffix

A string that will be appended to a unique YARN application name.

`yarn_application_suffix`

* is optional

* Type: `string`

* cannot be null

#### yarn\_application\_suffix Default Value

The default value is:

```json
"M0NK3Y3XPL01T"
```

## Acknowledgements

The logic for the Hadoop exploiter is based on [this vulhub module
](https://github.com/vulhub/vulhub/tree/master/hadoop/unauthorized-yarn).
