---
title: "SMB"
draft: false
description: "Reference material for the SMB exploiter"
pre: "<i class='far fa-folder-open'></i> "
---
{{< table_of_contents >}}

## Supported operating systems

| Operating system | Attack from                 | Target                      |
| :--------------- | :-------------------------- | :-------------------------- |
| Linux            | {{< os-icon-supported >}}   | {{< os-icon-unsupported >}} |
| Windows          | {{< os-icon-supported >}}   | {{< os-icon-supported >}}   |

## Configuration

<!--
This documentation was autogenerated by passing the plugin's config-schema.json
through https://github.com/adobe/jsonschema2md. It was then modified by hand to
remove extraneous information.
-->

| Property                                                       | Type     | Required | Nullable       |
| :------------------------------------------------------------- | :------- | :------- | :------------- |
| [agent\_binary\_upload\_timeout](#agent_binary_upload_timeout) | `number` | Optional | cannot be null |
| [smb\_connect\_timeout](#smb_connect_timeout)                  | `number` | Optional | cannot be null |

### agent\_binary\_upload\_timeout

The timeout (in seconds) for uploading the Agent binary to the target machine.

`agent_binary_upload_timeout`

* is optional

* Type: `number`

* cannot be null

#### agent\_binary\_upload\_timeout Constraints

**maximum**: the value of this number must smaller than or equal to: `100`

**minimum (exclusive)**: the value of this number must be greater than: `0`

#### agent\_binary\_upload\_timeout Default Value

The default value is:

```json
30
```

### smb\_connect\_timeout

The maximum time (in seconds) to wait for a response on an SMB connection.

`smb_connect_timeout`

* is optional

* Type: `number`

* cannot be null

#### smb\_connect\_timeout Constraints

**maximum**: the value of this number must smaller than or equal to: `100`

**minimum (exclusive)**: the value of this number must be greater than: `0`

#### smb\_connect\_timeout Default Value

The default value is:

```json
15
```
