---
title: "Ransomware"
draft: false
description: "Reference material for the Ransomware payload"
pre: "<i class='fa fa-lock'></i> "
---
{{< table_of_contents >}}

## Configuration

<!--
This documentation was autogenerated by passing the plugin's config-schema.json
through https://github.com/adobe/jsonschema2md. It was then modified by hand to
remove extraneous information.
-->

| Property                                    | Type      | Required | Nullable       |
| :------------------------------------------ | :-------- | :------- | :------------- |
| [file\_extension](#file_extension)          | `string`  | Optional | cannot be null |
| [linux\_target\_dir](#linux_target_dir)     | `string`  | Optional | can be null    |
| [windows\_target\_dir](#windows_target_dir) | `string`  | Optional | can be null    |
| [leave\_readme](#leave_readme)              | `boolean` | Optional | cannot be null |
| [change\_wallpaper](#change_wallpaper)      | `boolean` | Optional | cannot be null |

### file\_extension

The file extension that Infection Monkey will use for the encrypted file.

`file_extension`

* is optional

* Type: `string`

* cannot be null

#### file\_extension Constraints

**pattern**: the string must match the following regular expression:&#x20;

```regexp
^(\.[A-Za-z0-9_]+)?$
```

#### file\_extension Default Value

The default value is:

```json
".m0nk3y"
```

### linux\_target\_dir

A path to a directory on Linux systems that contains files you will allow
Infection Monkey to encrypt. If no directory is specified, no files will be
encrypted.

`linux_target_dir`

* is optional

* Type: `string`

* can be null

#### linux\_target\_dir Constraints

**pattern**: the string must match the following regular expression:&#x20;

```regexp
^$|^/|^\$|^~
```

### windows\_target\_dir

A path to a directory on Windows systems that contains files you will allow
Infection Monkey to encrypt. If no directory is specified, no files will be
encrypted.

`windows_target_dir`

* is optional

* Type: `string`

* can be null

#### windows\_target\_dir Constraints

**pattern**: the string must match the following regular expression:&#x20;

```regexp
^$|^([A-Za-z]:(\\|/))|^%([A-Za-z#$'()*+,\-\.?@[\]_`\{\}~ ]+([A-Za-z#$'()*+,\-\.?@[\]_`\{\}~ ]|\d)*)%|^\\{2}
```

### leave\_readme

If enabled, Infection Monkey will leave a ransom note in the target directory.

`leave_readme`

* is optional

* Type: `boolean`

* cannot be null

#### leave\_readme Default Value

The default value is:

```json
true
```

### change\_wallpaper

If enabled, Infection Monkey will change the desktop wallpaper on Windows
systems.

`change_wallpaper`

* is optional

* Type: `boolean`

* cannot be null

## Files targeted for encryption

Only regular files with certain extensions are encrypted by the ransomware
payload. This list is based on the [analysis of the Goldeneye ransomware by
BitDefender](https://labs.bitdefender.com/2017/07/a-technical-look-into-the-goldeneye-ransomware-attack/).

- .3ds
- .7z
- .accdb
- .ai
- .asp
- .aspx
- .avhd
- .avi
- .back
- .bak
- .c
- .cfg
- .conf
- .cpp
- .cs
- .ctl
- .dbf
- .disk
- .djvu
- .doc
- .docx
- .dwg
- .eml
- .fdb
- .giff
- .gz
- .h
- .hdd
- .jpg
- .jpeg
- .kdbx
- .mail
- .mdb
- .mpg
- .mpeg
- .msg
- .nrg
- .ora
- .ost
- .ova
- .ovf
- .pdf
- .php
- .pmf
- .png
- .ppt
- .pptx
- .pst
- .pvi
- .py
- .pyc
- .rar
- .rtf
- .sln
- .sql
- .tar
- .tiff
- .txt
- .vbox
- .vbs
- .vcb
- .vdi
- .vfd
- .vmc
- .vmdk
- .vmsd
- .vmx
- .vsdx
- .vsv
- .work
- .xls
- .xlsx
- .xvd
- .zip
