/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.list;

import com.formdev.flatlaf.util.SystemFileChooser;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.list.DnDList;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MenuActionExport
implements ActionListener {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final DnDList myList;

    public MenuActionExport(DnDList myList) {
        this.myList = myList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SystemFileChooser importFileDialog = new SystemFileChooser(MediatorHelper.model().getMediatorUtils().getPreferencesUtil().getPathFile());
        importFileDialog.setDialogTitle(I18nUtil.valueByKey("LIST_EXPORT_TITLE"));
        int choice = importFileDialog.showSaveDialog(this.myList.getTopLevelAncestor());
        if (choice != 0) {
            return;
        }
        try (FileOutputStream file = new FileOutputStream(importFileDialog.getSelectedFile());
             PrintStream out = new PrintStream((OutputStream)file, false, StandardCharsets.UTF_8);){
            int len = this.myList.getModel().getSize();
            for (int i = 0; i < len; ++i) {
                out.println(((ItemList)this.myList.getModel().getElementAt(i)).toString());
            }
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "List saved: {}", (Object)importFileDialog.getSelectedFile());
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }
}

