import urllib2
import datetime
import md5

from Malcom.model.datatypes import Url
from Malcom.feeds.core import Feed

from bs4 import BeautifulSoup


class MalwaredRu(Feed):

    def __init__(self):
        super(MalwaredRu, self).__init__(run_every="1h")

        self.source = "http://malwared.malwaremustdie.org/rss.php"
        self.description = "Collects results from http://malwared.malwaremustdie.org/, last C&C domains seen"

    def update(self):
        request = urllib2.Request(self.source, headers={"User-agent": "Mozilla/5.0 (X11; U; Linux i686) Gecko/20071127 Firefox/2.0.0.11"})
        feed = urllib2.urlopen(request).read()
        feed = feed[:feed.find('<script>')]

        soup = BeautifulSoup(feed, 'xml')

        for item in soup.find_all('item'):
            strings = list(item.strings)
            dict = {'title': strings[0], 'description': strings[1], 'link': strings[2]}
            self.analyze(dict)

        return True

    def analyze(self, dict):
        evil = {}
        evil['description'] = dict['title']
        try:
            evil['date_added'] = datetime.datetime.strptime(dict['description'], "%d/%b/%Y")
        except ValueError:
            evil['date_added'] = datetime.datetime.strptime(dict['description'], "%b/%Y")

        evil['source'] = self.name
        # nasty hack because of utf-8 encoded strings
        evil['id'] = md5.new(dict['title'].encode('utf-8').encode('hex') + dict['link'] + dict['description']).hexdigest()

        url = Url(url=dict['link'], tags=[dict['title'].lower()])

        url.seen(first=evil['date_added'])
        url.add_evil(evil)
        self.commit_to_db(url)
