/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.modules.flamingo;

import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import com.pinkmatter.modules.flamingo.ActionAdapters;
import com.pinkmatter.modules.flamingo.ActionItem;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import org.openide.util.Exceptions;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryFooter;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryPrimary;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntrySecondary;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizeSequencingPolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizeSequencingPolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonBandUI;

public class RibbonComponentFactory {
    public RibbonApplicationMenuEntryPrimary createAppMenuPresenter(ActionItem item) {
        Action action = item.getAction();
        if (action != null && RibbonPresenter.AppMenu.class.isAssignableFrom(action.getClass())) {
            return ((RibbonPresenter.AppMenu)((Object)action)).getPrimaryMenuEntry();
        }
        ActionAdapters.PrimaryMenuItem menuItem = new ActionAdapters.PrimaryMenuItem(item.getMenuIcon(), item.getMenuText(), action, RibbonComponentFactory.getButtonKind(item));
        ArrayList<RibbonApplicationMenuEntrySecondary> secondaries = new ArrayList<RibbonApplicationMenuEntrySecondary>();
        for (ActionItem child : item.getChildren()) {
            if (child.getAction() == null) {
                menuItem.addSecondaryMenuGroup(child.getMenuText(), this.createSecondaryItems(child.getChildren()));
                continue;
            }
            if (child.isSeparator()) continue;
            secondaries.add(this.createAppMenuSecondaryPresenter(child));
        }
        RibbonApplicationMenuEntrySecondary[] secondary = secondaries.toArray(new RibbonApplicationMenuEntrySecondary[secondaries.size()]);
        if (secondary != null && secondary.length > 0) {
            menuItem.addSecondaryMenuGroup(item.getMenuText(), secondary);
        }
        return menuItem;
    }

    private RibbonApplicationMenuEntrySecondary createAppMenuSecondaryPresenter(ActionItem item) {
        Action action = item.getAction();
        if (action != null && RibbonPresenter.AppMenuSecondary.class.isAssignableFrom(action.getClass())) {
            return ((RibbonPresenter.AppMenuSecondary)((Object)action)).getSecondaryMenuEntry();
        }
        ActionAdapters.SecondaryMenuItem menuItem = new ActionAdapters.SecondaryMenuItem(item.getMenuIcon(), item.getMenuText(), action, RibbonComponentFactory.getButtonKind(item));
        menuItem.setDescriptionText(item.getDescription());
        return menuItem;
    }

    private RibbonApplicationMenuEntrySecondary[] createSecondaryItems(List<ActionItem> children) {
        ArrayList<RibbonApplicationMenuEntrySecondary> secondaries = new ArrayList<RibbonApplicationMenuEntrySecondary>();
        for (ActionItem child : children) {
            if (child.isSeparator()) continue;
            secondaries.add(this.createAppMenuSecondaryPresenter(child));
        }
        return secondaries.toArray(new RibbonApplicationMenuEntrySecondary[secondaries.size()]);
    }

    public RibbonApplicationMenuEntryFooter createAppMenuFooterPresenter(ActionItem item) {
        RibbonApplicationMenuEntryFooter footer = new RibbonApplicationMenuEntryFooter(item.getMenuIcon(), item.getMenuText(), (ActionListener)item.getAction());
        return footer;
    }

    public Component createTaskBarPresenter(ActionItem item) {
        return this.createButtonPresenter(item);
    }

    public AbstractCommandButton createButtonPresenter(ActionItem item) {
        Action action = item.getAction();
        if (action != null && RibbonPresenter.Button.class.isAssignableFrom(action.getClass())) {
            return ((RibbonPresenter.Button)((Object)action)).getRibbonButtonPresenter();
        }
        return this.createCommandButton(item);
    }

    private AbstractCommandButton createCommandButton(ActionItem item) {
        ActionAdapters.CommandButton button = new ActionAdapters.CommandButton(item.getActionDelegate().getIcon(), item.getActionDelegate().getText(), item.getActionDelegate().getAction(), RibbonComponentFactory.getButtonKind(item));
        RichTooltip toolTip = item.getActionDelegate().createTooltip();
        button.setActionRichTooltip(toolTip);
        if (item.hasChildren()) {
            final JCommandPopupMenu menu = this.createPopupMenu(item.getChildren());
            button.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                    return menu;
                }
            });
        }
        return button;
    }

    public JCommandPopupMenu createPopupMenu(List<ActionItem> items) {
        JCommandPopupMenu menu = new JCommandPopupMenu();
        for (ActionItem item : items) {
            if (item.isSeparator()) {
                menu.addMenuSeparator();
                continue;
            }
            menu.addMenuButton(this.createPopupMenuPresenter(item));
        }
        return menu;
    }

    public JCommandMenuButton createPopupMenuPresenter(ActionItem item) {
        ActionAdapters.MenuButton button = new ActionAdapters.MenuButton(item.getIcon(), item.getText(), item.getAction(), RibbonComponentFactory.getButtonKind(item));
        RichTooltip toolTip = item.createTooltip();
        button.setActionRichTooltip(toolTip);
        if (item.hasChildren()) {
            final JCommandPopupMenu menu = this.createPopupMenu(item.getChildren());
            button.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                    return menu;
                }
            });
        }
        return button;
    }

    public RibbonTask createRibbonTask(ActionItem item) {
        AbstractRibbonBand[] bands = this.createRibbonBands(item.getChildren());
        try {
            RibbonTask task = new RibbonTask(item.getText(), bands);
            task.setResizeSequencingPolicy((RibbonBandResizeSequencingPolicy)new CoreRibbonResizeSequencingPolicies.RoundRobin(task));
            return task;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private AbstractRibbonBand[] createRibbonBands(List<? extends ActionItem> items) {
        ArrayList<AbstractRibbonBand> bands = new ArrayList<AbstractRibbonBand>();
        for (ActionItem actionItem : items) {
            JComponent component = actionItem.getComponent();
            if (component instanceof AbstractRibbonBand) {
                bands.add((AbstractRibbonBand)component);
                continue;
            }
            bands.add(this.createRibbonBand(actionItem));
        }
        return bands.toArray(new AbstractRibbonBand[bands.size()]);
    }

    public AbstractRibbonBand createRibbonBand(ActionItem item) {
        JRibbonBand band = new JRibbonBand(item.getText(), ResizableIcons.getEmpty(), RibbonComponentFactory.getDefaultAction(item)){

            public void setUI(RibbonBandUI ui) {
                if (ui == null || !ui.getClass().getName().contains("Office")) {
                    System.out.println(">>Debugging code for NPE");
                    System.out.println(">>>ui=" + ui);
                }
                super.setUI(ui);
            }
        };
        for (ActionItem child : item.getChildren()) {
            if (child.isSeparator()) {
                band.startGroup();
                continue;
            }
            if (child.getValue("defaultAction") == Boolean.TRUE) continue;
            this.addRibbonBandAction(band, child);
        }
        ArrayList<Object> policyList = new ArrayList<Object>();
        policyList.add(new CoreRibbonResizePolicies.Mirror((JBandControlPanel)band.getControlPanel()));
        policyList.add(new CoreRibbonResizePolicies.Mid2Low((JBandControlPanel)band.getControlPanel()));
        policyList.add(new CoreRibbonResizePolicies.High2Low((JBandControlPanel)band.getControlPanel()));
        band.setResizePolicies(policyList);
        return band;
    }

    private static ActionListener getDefaultAction(ActionItem item) {
        for (ActionItem child : item.getChildren()) {
            if (child.getValue("defaultAction") != Boolean.TRUE || child.getAction() == null) continue;
            return child.getAction();
        }
        return null;
    }

    private void addRibbonBandAction(JRibbonBand band, ActionItem item) {
        Action action = item.getAction();
        if (action != null && RibbonPresenter.Component.class.isAssignableFrom(action.getClass())) {
            band.addRibbonComponent(((RibbonPresenter.Component)((Object)action)).getRibbonBarComponentPresenter(), 3);
        } else {
            band.addCommandButton(this.createButtonPresenter(item), RibbonComponentFactory.getPriority(item));
        }
    }

    private static RibbonElementPriority getPriority(ActionItem item) {
        RibbonElementPriority p = RibbonElementPriority.TOP;
        String priority = (String)item.getValue("priority");
        if (priority != null) {
            p = RibbonElementPriority.valueOf((String)priority.toUpperCase());
        }
        return p;
    }

    private static JCommandButton.CommandButtonKind getButtonKind(ActionItem item) {
        Action delegate = item.getActionDelegate().getAction();
        if (delegate == null && item.hasChildren()) {
            return JCommandButton.CommandButtonKind.POPUP_ONLY;
        }
        if (delegate != null && item.hasChildren()) {
            return JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION;
        }
        if (delegate != null && !item.hasChildren()) {
            return JCommandButton.CommandButtonKind.ACTION_ONLY;
        }
        return JCommandButton.CommandButtonKind.POPUP_ONLY;
    }
}

