/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.wizard;

import com.paterva.maltego.discovery.DiscoveryItems;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class UpdateInstallText {
    public String get(TransformServerListing[] listings) {
        if (listings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(listings.length).append(" Application Server");
        if (listings.length > 1) {
            sb.append("s");
        }
        sb.append("\n");
        LinkedHashMap<String, Integer> counts = new LinkedHashMap<String, Integer>();
        for (TransformServerListing listing : listings) {
            Set transforms = listing.getTransforms();
            if (!transforms.isEmpty()) {
                this.inc(counts, "Transforms", transforms.size());
            }
            for (DiscoveryItems mtzItems : listing.getMtzDiscoveryItems()) {
                this.inc(counts, mtzItems.getDescription(), mtzItems.size());
            }
            Map services = listing.getPublicWebServices();
            if (services.isEmpty()) continue;
            this.inc(counts, "Authenticators", services.size());
        }
        for (Map.Entry entry : counts.entrySet()) {
            sb.append(entry.getValue()).append(" ").append((String)entry.getKey()).append("\n");
        }
        return sb.toString();
    }

    private void inc(Map<String, Integer> counts, String itemsStr, int increment) {
        Integer count = counts.get(itemsStr);
        if (count == null) {
            count = 0;
        }
        count = count + increment;
        counts.put(itemsStr, count);
    }
}

