/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JDeclaration;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JVar;
import java.io.PrintWriter;

public class JFormatter {
    private int indentLevel;
    private String indentSpace;
    private PrintWriter pw;
    private char lastChar = '\u0000';
    private boolean atBeginningOfLine = true;

    public JFormatter(PrintWriter s, String space) {
        this.pw = s;
        this.indentSpace = space;
    }

    public JFormatter(PrintWriter s) {
        this(s, "    ");
    }

    public void close() {
        this.pw.close();
    }

    public JFormatter o() {
        --this.indentLevel;
        return this;
    }

    public JFormatter i() {
        ++this.indentLevel;
        return this;
    }

    private boolean needSpace(char c1, char c2) {
        if (c1 == ']' && c2 == '{') {
            return true;
        }
        if (c1 == ';') {
            return true;
        }
        if (c1 == ')' && c2 == '{') {
            return true;
        }
        if (c1 == ',' || c1 == '=') {
            return true;
        }
        if (c2 == '=') {
            return true;
        }
        if (Character.isDigit(c1)) {
            return c2 != '(' && c2 != ')' && c2 != ';' && c2 != ',';
        }
        if (Character.isJavaIdentifierPart(c1)) {
            switch (c2) {
                case '+': 
                case '>': 
                case '{': 
                case '}': {
                    return true;
                }
            }
            return Character.isJavaIdentifierStart(c2);
        }
        if (Character.isJavaIdentifierStart(c2)) {
            switch (c1) {
                case ')': 
                case '+': 
                case ']': 
                case '}': {
                    return true;
                }
            }
            return false;
        }
        if (Character.isDigit(c2)) {
            return c1 != '(';
        }
        return false;
    }

    private void spaceIfNeeded(char c) {
        if (this.atBeginningOfLine) {
            int i = 0;
            while (i < this.indentLevel) {
                this.pw.print(this.indentSpace);
                ++i;
            }
            this.atBeginningOfLine = false;
        } else if (this.lastChar != '\u0000' && this.needSpace(this.lastChar, c)) {
            this.pw.print(' ');
        }
    }

    public JFormatter p(char c) {
        this.spaceIfNeeded(c);
        this.pw.print(c);
        this.lastChar = c;
        return this;
    }

    public JFormatter p(String s) {
        this.spaceIfNeeded(s.charAt(0));
        this.pw.print(s);
        this.lastChar = s.charAt(s.length() - 1);
        return this;
    }

    public JFormatter nl() {
        this.pw.println();
        this.lastChar = '\u0000';
        this.atBeginningOfLine = true;
        return this;
    }

    public JFormatter g(JGenerable g) {
        g.generate(this);
        return this;
    }

    public JFormatter d(JDeclaration d) {
        d.declare(this);
        return this;
    }

    public JFormatter s(JStatement s) {
        s.state(this);
        return this;
    }

    public JFormatter b(JVar v) {
        v.bind(this);
        return this;
    }
}

