/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDeclaration;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JPackageMemberClass;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.util.UnicodeEscapeWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

public final class JPackage
implements JDeclaration,
JGenerable,
JClassContainer {
    private String name;
    private final JCodeModel owner;
    private final TreeMap classes = new TreeMap();
    private final HashSet resources = new HashSet();

    JPackage(String name, JCodeModel cw) {
        this.owner = cw;
        if (name.equals(".")) {
            String msg = "JPackage name . is not allowed";
            throw new IllegalArgumentException(msg);
        }
        int dots = 1;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '.') {
                ++dots;
            } else {
                if (dots > 1) {
                    String msg = "JPackage name " + name + " missing identifier";
                    throw new IllegalArgumentException(msg);
                }
                if (dots == 1 && !Character.isJavaIdentifierStart(c)) {
                    String msg = "JPackage name " + name + " contains illegal " + "character for beginning of identifier: " + c;
                    throw new IllegalArgumentException(msg);
                }
                if (!Character.isJavaIdentifierPart(c)) {
                    String msg = "JPackage name " + name + "contains illegal " + "character: " + c;
                    throw new IllegalArgumentException(msg);
                }
                dots = 0;
            }
            ++i;
        }
        if (!name.trim().equals("") && dots != 0) {
            String msg = "JPackage name not allowed to end with .";
            throw new IllegalArgumentException(msg);
        }
        this.name = name;
    }

    public JClassContainer parentContainer() {
        return this.parent();
    }

    public JPackage parent() {
        if (this.name.length() == 0) {
            return null;
        }
        int idx = this.name.lastIndexOf(46);
        return this.owner._package(this.name.substring(0, idx));
    }

    public JDefinedClass _class(int mods, String name) throws JClassAlreadyExistsException {
        return this._class(mods, name, false);
    }

    public JDefinedClass _class(int mods, String name, boolean isInterface) throws JClassAlreadyExistsException {
        if (this.classes.containsKey(name)) {
            throw new JClassAlreadyExistsException((JDefinedClass)this.classes.get(name));
        }
        JPackageMemberClass c = new JPackageMemberClass(this, mods, name, isInterface);
        this.classes.put(name, c);
        return c;
    }

    public JDefinedClass _class(String name) throws JClassAlreadyExistsException {
        return this._class(1, name);
    }

    public JDefinedClass _interface(int mods, String name) throws JClassAlreadyExistsException {
        return this._class(mods, name, true);
    }

    public JDefinedClass _interface(String name) throws JClassAlreadyExistsException {
        return this._interface(1, name);
    }

    public JResourceFile addResourceFile(JResourceFile rsrc) {
        this.resources.add(rsrc);
        return rsrc;
    }

    public Iterator propertyFiles() {
        return this.resources.iterator();
    }

    public void remove(JClass c) {
        if (c._package() != this) {
            throw new IllegalArgumentException("the specified class is not a member of this package, or it is a referenced class");
        }
        this.classes.remove(c.name());
    }

    public JClass ref(String name) {
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("JClass name contains '.': " + name);
        }
        String n = "";
        if (!this.isUnnamed()) {
            n = this.name + ".";
        }
        n = n + name;
        try {
            return this.owner.ref(Class.forName(n));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.toString());
        }
    }

    public JPackage subPackage(String pkg) {
        if (this.isUnnamed()) {
            return this.owner()._package(pkg);
        }
        return this.owner()._package(this.name + "." + pkg);
    }

    public Iterator classes() {
        return this.classes.values().iterator();
    }

    public boolean isDefined(String classLocalName) {
        Iterator itr = this.classes();
        while (itr.hasNext()) {
            if (!((JClass)itr.next()).name().equals(classLocalName)) continue;
            return true;
        }
        return false;
    }

    public final boolean isUnnamed() {
        return this.name.length() == 0;
    }

    public String name() {
        return this.name;
    }

    public final JCodeModel owner() {
        return this.owner;
    }

    File toPath(File dir) {
        if (this.name == null) {
            return dir;
        }
        return new File(dir, this.name.replace('.', File.separatorChar));
    }

    public void declare(JFormatter f) {
        if (this.name.length() != 0) {
            f.p("package").p(this.name).p(';').nl();
        }
    }

    public void generate(JFormatter f) {
        f.p(this.name);
    }

    void build(CodeWriter out) throws IOException {
        Iterator i = this.classes.values().iterator();
        while (i.hasNext()) {
            JPackageMemberClass c = (JPackageMemberClass)i.next();
            if (c.isHidden()) continue;
            UnicodeEscapeWriter bw = new UnicodeEscapeWriter(new BufferedWriter(new OutputStreamWriter(out.open(this, c.name() + ".java"))));
            JFormatter f = new JFormatter(new PrintWriter(bw));
            c.declare(f);
            f.close();
        }
        Iterator i2 = this.resources.iterator();
        while (i2.hasNext()) {
            JResourceFile rsrc = (JResourceFile)i2.next();
            OutputStream os = out.open(this, rsrc.name());
            rsrc.build(os);
            os.close();
        }
    }
}

