/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import net.sourceforge.jtds.jdbc.TdsComm;
import net.sourceforge.jtds.jdbc.TdsException;

public class CancelController {
    public static final String cvsVersion = "$Id: CancelController.java,v 1.1 2002/10/14 10:48:59 alin_sinpalean Exp $";
    private boolean awaitingData = false;
    private int cancelsRequested = 0;
    private int cancelsProcessed = 0;

    public synchronized void setQueryInProgressFlag() {
        this.awaitingData = true;
    }

    private synchronized void clearQueryInProgressFlag() {
        this.awaitingData = false;
    }

    public synchronized void finishQuery(boolean bl, boolean bl2) {
        if (!bl2) {
            this.clearQueryInProgressFlag();
        }
        if (bl) {
            this.handleCancelAck();
        }
    }

    public synchronized void doCancel(TdsComm tdsComm) throws IOException, TdsException {
        if (this.awaitingData && this.cancelsRequested == this.cancelsProcessed) {
            tdsComm.startPacket(6);
            tdsComm.sendPacket();
            ++this.cancelsRequested;
        }
    }

    private synchronized void handleCancelAck() {
        ++this.cancelsProcessed;
    }

    public synchronized int outstandingCancels() {
        return this.cancelsRequested - this.cancelsProcessed;
    }
}

