/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sourceforge.jtds.jdbc.DriverVersion;
import net.sourceforge.jtds.jdbc.TdsConnection;
import net.sourceforge.jtds.jdbc.TdsException;

public class Driver
implements java.sql.Driver {
    public static final String cvsVersion = "$Id: Driver.java,v 1.1 2002/10/14 10:48:59 alin_sinpalean Exp $";
    static final boolean debug = false;
    static final String oldSQLServerUrlPrefix = "jdbc:jtds://";
    static final String newSQLServerUrlPrefix = "jdbc:jtds:sqlserver://";
    static final String sybaseUrlPrefix = "jdbc:jtds:sybase://";
    static final String defaultSQLServerPort = "1433";
    static final String defaultSybasePort = "7100";

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{};
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return DriverVersion.getDriverMajorVersion();
    }

    public int getMinorVersion() {
        return DriverVersion.getDriverMinorVersion();
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        if (!this.parseUrl(string, properties)) {
            return null;
        }
        try {
            return new TdsConnection(properties);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("NumberFormatException converting port number.");
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
    }

    public boolean acceptsURL(String string) throws SQLException {
        return this.parseUrl(string, new Properties());
    }

    public boolean jdbcCompliant() {
        return false;
    }

    protected boolean parseUrl(String string, Properties properties) {
        String string2 = string;
        int n = -1;
        if (string2.startsWith(oldSQLServerUrlPrefix) || string2.startsWith(newSQLServerUrlPrefix) || string2.startsWith(sybaseUrlPrefix)) {
            if (string2.startsWith(oldSQLServerUrlPrefix)) {
                n = 1;
                string2 = string2.substring(oldSQLServerUrlPrefix.length());
            } else if (string2.startsWith(newSQLServerUrlPrefix)) {
                n = 1;
                string2 = string2.substring(newSQLServerUrlPrefix.length());
            } else if (string2.startsWith(sybaseUrlPrefix)) {
                n = 2;
                string2 = string.substring(sybaseUrlPrefix.length());
            }
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":/;", true);
                String string3 = null;
                String string4 = n == 2 ? defaultSybasePort : defaultSQLServerPort;
                String string5 = "";
                string3 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    if (string6.equals(":")) {
                        string4 = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreTokens()) {
                            string6 = stringTokenizer.nextToken();
                        }
                    }
                    if (stringTokenizer.hasMoreTokens() && string6.equals("/")) {
                        string5 = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreTokens()) {
                            string6 = stringTokenizer.nextToken();
                        }
                    }
                    while (string6.equals(";")) {
                        String string7 = stringTokenizer.nextToken();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string7, "=", false);
                        String string8 = stringTokenizer2.nextToken().toUpperCase();
                        if (stringTokenizer2.hasMoreTokens()) {
                            ((Hashtable)properties).put(string8, stringTokenizer2.nextToken());
                        }
                        if (!stringTokenizer.hasMoreTokens()) break;
                        string6 = stringTokenizer.nextToken();
                    }
                }
                if (stringTokenizer.hasMoreTokens() || !this.isValidHostname(string3)) {
                    return false;
                }
                ((Hashtable)properties).put("HOST", string3);
                ((Hashtable)properties).put("SERVERTYPE", "" + n);
                ((Hashtable)properties).put("PORT", string4);
                ((Hashtable)properties).put("DBNAME", string5);
                return true;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return false;
    }

    private boolean isValidHostname(String string) {
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

