/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import net.sourceforge.jtds.jdbc.PacketResult;
import net.sourceforge.jtds.jdbc.TdsConfused;

public class PacketDoneInProcResult
extends PacketResult {
    public static final String cvsVersion = "$Id: PacketDoneInProcResult.java,v 1.1 2002/10/14 10:48:59 alin_sinpalean Exp $";
    private byte status;
    private int rowCount;
    private int retStat;
    private boolean isRetStatSet;

    public PacketDoneInProcResult(byte by, byte by2, int n) throws TdsConfused {
        super(by);
        if (by != -1) {
            throw new TdsConfused("Internal error");
        }
        this.status = by2;
        this.rowCount = n;
        this.isRetStatSet = false;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean moreResults() {
        return (this.status & 1) != 0;
    }

    public boolean wasCanceled() {
        return (this.status & 0x20) != 0;
    }

    public boolean haveRetStat() {
        return this.isRetStatSet;
    }

    public void setRetStat(int n) {
        this.retStat = n;
        this.isRetStatSet = true;
    }

    public int getRetStat() {
        return this.retStat;
    }

    public String toString() {
        return "token type- " + Integer.toHexString(this.getPacketType() & 0xFF) + ", rowCount- " + this.getRowCount() + ", moreResults- " + this.moreResults() + ", wasCanceled- " + this.wasCanceled() + ", " + (this.haveRetStat() ? "retstat- " + this.getRetStat() : "no retstat");
    }
}

