/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import net.sourceforge.jtds.jdbc.Context;
import net.sourceforge.jtds.jdbc.PacketResult;
import net.sourceforge.jtds.jdbc.TdsAsciiInputStream;
import net.sourceforge.jtds.jdbc.TdsException;
import net.sourceforge.jtds.jdbc.TdsUtil;

public class PacketRowResult
extends PacketResult {
    Vector row = null;
    Context context;
    boolean wasNull = false;
    public static final String cvsVersion = "$Id: PacketRowResult.java,v 1.3 2002/10/22 09:50:10 alin_sinpalean Exp $";

    public PacketRowResult(Context context) {
        super((byte)-47);
        this.context = context;
        this.row = new Vector(this.realColumnCount());
        this.row.setSize(this.realColumnCount());
    }

    public Context getContext() {
        return this.context;
    }

    public void setElementAt(int n, Object object) throws SQLException {
        if (n < 1 || n > this.realColumnCount()) {
            throw new SQLException("Bad index " + n);
        }
        this.row.setElementAt(object, n - 1);
    }

    private int realColumnCount() {
        return this.context.getColumnInfo().realColumnCount();
    }

    public int getColumnType(int n) throws SQLException {
        return this.context.getColumnInfo().getJdbcType(n);
    }

    public Object getElementAt(int n) throws TdsException {
        if (n < 1 || n > this.realColumnCount()) {
            throw new TdsException("Bad index " + n);
        }
        return this.row.elementAt(n - 1);
    }

    public Object getObject(int n) throws SQLException {
        try {
            Object object = this.getElementAt(n);
            this.wasNull = false;
            if (object == null) {
                this.wasNull = true;
                return null;
            }
            switch (this.getColumnType(n)) {
                case 1: 
                case 12: {
                    if (object instanceof String) {
                        return object;
                    }
                    throw new SQLException("Was expecting CHAR data.  Got" + object.getClass().getName());
                }
                case -6: 
                case 4: 
                case 5: {
                    if (object instanceof Integer) {
                        return object;
                    }
                    if (!(object instanceof Number)) {
                        throw new SQLException("Can't convert " + object.getClass().getName() + " to Integer.");
                    }
                    return new Integer(((Number)object).intValue());
                }
                case -5: {
                    if (object instanceof Long) {
                        return object;
                    }
                    if (!(object instanceof Number)) {
                        throw new SQLException("Internal error");
                    }
                    return new Long(((Number)object).longValue());
                }
                case 7: {
                    if (!(object instanceof Float)) {
                        throw new SQLException("Internal error");
                    }
                    return object;
                }
                case 6: 
                case 8: {
                    if (object instanceof Double) {
                        return object;
                    }
                    if (object instanceof Number) {
                        return new Double(((Number)object).doubleValue());
                    }
                    throw new SQLException("Was expecting Numeric data.  Got" + object.getClass().getName());
                }
                case 91: {
                    if (!(object instanceof Timestamp)) {
                        throw new SQLException("Internal error");
                    }
                    return new java.sql.Date(((Date)((Timestamp)object)).getTime());
                }
                case 92: {
                    if (!(object instanceof Timestamp)) {
                        throw new SQLException("Internal error");
                    }
                    return new Time(((Date)((Timestamp)object)).getTime());
                }
                case 93: {
                    if (!(object instanceof Timestamp)) {
                        throw new SQLException("Internal error");
                    }
                    return object;
                }
                case -3: 
                case -2: {
                    return this.getBytes(n);
                }
                case 2: 
                case 3: {
                    if (object instanceof BigDecimal) {
                        return object;
                    }
                    if (object instanceof Number) {
                        return new BigDecimal(((Number)object).doubleValue());
                    }
                    throw new SQLException("Was expecting NUMERIC data.  Got" + object.getClass().getName());
                }
                case -1: {
                    if (object instanceof TdsAsciiInputStream) {
                        return object.toString();
                    }
                    if (object instanceof String) {
                        return object;
                    }
                    throw new SQLException("Was expecting LONGVARCHAR data. Got " + object.getClass().getName());
                }
                case -4: {
                    throw new SQLException("Not implemented");
                }
                case 0: {
                    throw new SQLException("Not implemented");
                }
                case 1111: {
                    throw new SQLException("Not implemented");
                }
                case -7: {
                    if (object instanceof Boolean) {
                        return object;
                    }
                    throw new SQLException("Was expecting BIT data. Got" + object.getClass().getName());
                }
            }
            throw new SQLException("Unknown datatype " + this.getColumnType(n));
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        byte[] byArray;
        block5: {
            try {
                Object object = this.getElementAt(n);
                this.wasNull = false;
                if (object == null) {
                    this.wasNull = true;
                    byArray = null;
                    break block5;
                }
                if (object instanceof byte[]) {
                    byArray = (byte[])object;
                    break block5;
                }
                if (object instanceof String) {
                    byArray = this.context.getEncoder().getBytes((String)object);
                    break block5;
                }
                throw new SQLException("Can't convert column " + n + " from " + object.getClass().getName() + " to byte[]");
            }
            catch (TdsException tdsException) {
                throw new SQLException(tdsException.getMessage());
            }
        }
        return byArray;
    }

    public double getDouble(int n) throws SQLException {
        double d;
        Object object = this.getObject(n);
        if (object == null) {
            d = 0.0;
        } else {
            try {
                switch (this.getColumnType(n)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        d = ((Number)object).doubleValue();
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        try {
                            Double d2 = new Double((String)object);
                            d = d2;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new SQLException(numberFormatException.getMessage());
                        }
                    }
                    default: {
                        throw new SQLException("Internal error. Don't know how to convert from java.sql.Types." + TdsUtil.javaSqlTypeToString(this.getColumnType(n)) + " to an Dboule");
                    }
                }
            }
            catch (ClassCastException classCastException) {
                throw new SQLException("Couldn't convert column " + n + " to an long.  " + classCastException.getMessage());
            }
        }
        return d;
    }

    public long getLong(int n) throws SQLException {
        long l = 0L;
        Object object = this.getObject(n);
        if (object == null) {
            l = 0L;
        } else {
            try {
                switch (this.getColumnType(n)) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        l = ((Number)object).longValue();
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        try {
                            Long l2 = new Long(object.toString().trim());
                            l = l2;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new SQLException("NumberFormatException: [" + numberFormatException.getMessage() + "]");
                        }
                    }
                    case 2: {
                        l = ((Number)object).longValue();
                        break;
                    }
                    case 3: {
                        l = ((Number)object).longValue();
                        break;
                    }
                    case -7: {
                        l = (Boolean)object != false ? 1L : 0L;
                        break;
                    }
                    default: {
                        throw new SQLException("Internal error. Don't know how to convert from java.sql.Types " + TdsUtil.javaSqlTypeToString(this.getColumnType(n)) + " to an long");
                    }
                }
            }
            catch (ClassCastException classCastException) {
                throw new SQLException("Couldn't convert column " + n + " to an long.  " + classCastException.getMessage());
            }
        }
        return l;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp;
        block4: {
            try {
                Object object = this.getElementAt(n);
                this.wasNull = false;
                if (object == null) {
                    this.wasNull = true;
                    timestamp = null;
                    break block4;
                }
                if (object instanceof Timestamp) {
                    timestamp = (Timestamp)object;
                    break block4;
                }
                throw new SQLException("Can't convert column " + n + " from " + object.getClass().getName() + " to Timestamp");
            }
            catch (TdsException tdsException) {
                throw new SQLException(tdsException.getMessage());
            }
        }
        return timestamp;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        BigDecimal bigDecimal = null;
        if (object instanceof Double) {
            bigDecimal = new BigDecimal((Double)object);
        } else if (object instanceof Float) {
            bigDecimal = new BigDecimal(((Float)object).doubleValue());
        } else if (object instanceof BigDecimal) {
            bigDecimal = (BigDecimal)object;
        } else if (object instanceof Number) {
            bigDecimal = BigDecimal.valueOf(((Number)object).longValue());
        } else if (object instanceof String) {
            try {
                bigDecimal = new BigDecimal((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException(numberFormatException.getMessage());
            }
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.setScale(n2);
    }

    public boolean getBoolean(int n) throws SQLException {
        boolean bl;
        Object object = this.getObject(n);
        if (object == null) {
            bl = false;
        } else {
            switch (this.getColumnType(n)) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (!(object instanceof Number)) {
                        throw new SQLException("Internal error");
                    }
                    bl = ((Number)object).intValue() != 0;
                    break;
                }
                case -7: {
                    if (!(object instanceof Boolean)) {
                        throw new SQLException("Internal error");
                    }
                    bl = (Boolean)object;
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    if (!(object instanceof String)) {
                        throw new SQLException("Internal error");
                    }
                    String string = object.toString().trim();
                    if (string.equalsIgnoreCase("0") || string.equalsIgnoreCase("false")) {
                        bl = false;
                        break;
                    }
                    if (string.equalsIgnoreCase("1") || string.equalsIgnoreCase("true")) {
                        bl = true;
                        break;
                    }
                }
                default: {
                    throw new SQLException("Can't convert column " + n + " from " + object.getClass().getName() + " to boolean");
                }
            }
        }
        return bl;
    }

    public boolean wasNull() {
        return this.wasNull;
    }
}

