/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.util.StringTokenizer;
import net.sourceforge.jtds.jdbc.ParameterListItem;
import net.sourceforge.jtds.jdbc.ParameterUtils;
import net.sourceforge.jtds.jdbc.Tds;

public class Procedure {
    public static final String cvsVersion = "$Id: Procedure.java,v 1.2 2002/11/07 11:07:01 alin_sinpalean Exp $";
    ParameterListItem[] parameterList = null;
    String sqlProcedureName = null;
    String rawQueryString = null;
    String procedureString = "";
    private Tds tds = null;
    private boolean hasLobs = false;

    private void init(String string, String string2, ParameterListItem[] parameterListItemArray, Tds tds) throws SQLException {
        this.rawQueryString = string;
        this.sqlProcedureName = string2;
        this.tds = tds;
        ParameterUtils.verifyThatParametersAreSet(parameterListItemArray);
        if (parameterListItemArray.length != ParameterUtils.countParameters(this.rawQueryString)) {
            throw new SQLException("Number of parameters in sql statement does not match the number of parameters  in parameter list");
        }
        this.procedureString = "create proc " + this.sqlProcedureName;
        ParameterUtils.createParameterMapping(this.rawQueryString, parameterListItemArray, this.tds);
        this.parameterList = new ParameterListItem[parameterListItemArray.length];
        int n = 0;
        while (n < this.parameterList.length) {
            this.parameterList[n] = (ParameterListItem)parameterListItemArray[n].clone();
            this.parameterList[n].value = null;
            if (this.parameterList[n].formalType.equalsIgnoreCase("image") || this.parameterList[n].formalType.equalsIgnoreCase("text") || this.parameterList[n].formalType.equalsIgnoreCase("ntext")) {
                this.hasLobs = true;
            }
            ++n;
        }
        this.procedureString = this.procedureString + this.createFormalParameterList(this.parameterList);
        this.procedureString = this.procedureString + " as ";
        StringTokenizer stringTokenizer = new StringTokenizer(this.rawQueryString, "'?\\", true);
        int n2 = 1;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            switch (n2) {
                case 1: {
                    if (string3.equals("?")) {
                        this.procedureString = this.procedureString + "@" + this.parameterList[n3].formalName;
                        ++n3;
                        break;
                    }
                    if (string3.equals("'")) {
                        this.procedureString = this.procedureString + string3;
                        n2 = 2;
                        break;
                    }
                    this.procedureString = this.procedureString + string3;
                    break;
                }
                case 2: {
                    if (string3.equals("'")) {
                        n2 = 1;
                    } else if (string3.equals("\\")) {
                        n2 = 3;
                    }
                    this.procedureString = this.procedureString + string3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    this.procedureString = this.procedureString + string3;
                    break;
                }
                default: {
                    throw new SQLException("Internal error.  Bad State " + n2);
                }
            }
        }
    }

    public Procedure(String string, String string2, ParameterListItem[] parameterListItemArray, Tds tds) throws SQLException {
        this.init(string, string2, parameterListItemArray, tds);
    }

    public String getPreparedSqlString() {
        return this.procedureString;
    }

    public String getProcedureName() {
        return this.sqlProcedureName;
    }

    public ParameterListItem getParameter(int n) {
        return this.parameterList[n];
    }

    private String createFormalParameterList(ParameterListItem[] parameterListItemArray) {
        String string;
        if (parameterListItemArray.length == 0) {
            string = "";
        } else {
            string = "(";
            int n = 0;
            while (n < parameterListItemArray.length) {
                if (n > 0) {
                    string = string + ", ";
                }
                string = string + "@" + parameterListItemArray[n].formalName + " " + parameterListItemArray[n].formalType;
                if (parameterListItemArray[n].isOutput) {
                    string = string + " output";
                }
                ++n;
            }
            string = string + ")";
        }
        return string;
    }

    public boolean compatibleParameters(ParameterListItem[] parameterListItemArray) throws SQLException {
        boolean bl = true;
        bl = this.parameterList.length == parameterListItemArray.length;
        int n = 0;
        while (bl && n < parameterListItemArray.length) {
            bl = !(!this.parameterList[n].formalType.startsWith("char") && !this.parameterList[n].formalType.startsWith("varchar") && !this.parameterList[n].formalType.startsWith("text") && !this.parameterList[n].formalType.startsWith("nchar") && !this.parameterList[n].formalType.startsWith("nvarchar") && !this.parameterList[n].formalType.startsWith("ntext") || parameterListItemArray[n].type != 1 && parameterListItemArray[n].type != 12 && parameterListItemArray[n].type != -1) ? this.parameterList[n].maxLength >= parameterListItemArray[n].maxLength : this.parameterList[n].formalType.equalsIgnoreCase(parameterListItemArray[n].formalType);
            ++n;
        }
        return bl;
    }

    public ParameterListItem[] getParameterList() {
        return this.parameterList;
    }

    public boolean hasLobParameters() {
        return this.hasLobs;
    }
}

