/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sourceforge.jtds.jdbc.CallableStatement_base;
import net.sourceforge.jtds.jdbc.CancelController;
import net.sourceforge.jtds.jdbc.Column;
import net.sourceforge.jtds.jdbc.Columns;
import net.sourceforge.jtds.jdbc.Context;
import net.sourceforge.jtds.jdbc.DriverVersion;
import net.sourceforge.jtds.jdbc.EncodingHelper;
import net.sourceforge.jtds.jdbc.EscapeProcessor;
import net.sourceforge.jtds.jdbc.MSSqlServerEscapeProcessor;
import net.sourceforge.jtds.jdbc.PacketColumnInfoResult;
import net.sourceforge.jtds.jdbc.PacketColumnNamesResult;
import net.sourceforge.jtds.jdbc.PacketColumnOrderResult;
import net.sourceforge.jtds.jdbc.PacketControlResult;
import net.sourceforge.jtds.jdbc.PacketDoneInProcResult;
import net.sourceforge.jtds.jdbc.PacketEndTokenResult;
import net.sourceforge.jtds.jdbc.PacketErrorResult;
import net.sourceforge.jtds.jdbc.PacketMsgResult;
import net.sourceforge.jtds.jdbc.PacketOutputParamResult;
import net.sourceforge.jtds.jdbc.PacketResult;
import net.sourceforge.jtds.jdbc.PacketRetStatResult;
import net.sourceforge.jtds.jdbc.PacketRowResult;
import net.sourceforge.jtds.jdbc.PacketTabNameResult;
import net.sourceforge.jtds.jdbc.PacketUnknown;
import net.sourceforge.jtds.jdbc.ParameterListItem;
import net.sourceforge.jtds.jdbc.Procedure;
import net.sourceforge.jtds.jdbc.SQLWarningChain;
import net.sourceforge.jtds.jdbc.SqlMessage;
import net.sourceforge.jtds.jdbc.SybaseEscapeProcessor;
import net.sourceforge.jtds.jdbc.TdsComm;
import net.sourceforge.jtds.jdbc.TdsConfused;
import net.sourceforge.jtds.jdbc.TdsConnection;
import net.sourceforge.jtds.jdbc.TdsDefinitions;
import net.sourceforge.jtds.jdbc.TdsException;
import net.sourceforge.jtds.jdbc.TdsNotImplemented;
import net.sourceforge.jtds.jdbc.TdsStatement;
import net.sourceforge.jtds.jdbc.TdsUnknownPacketSubType;
import net.sourceforge.jtds.jdbc.TdsUtil;
import net.sourceforge.jtds.jdbc.TimeoutHandler;
import net.sourceforge.jtds.jdbc.UniqueId;
import net.sourceforge.jtds.util.Logger;

public class Tds
implements TdsDefinitions {
    Socket sock = null;
    TdsComm comm = null;
    String databaseProductName;
    String databaseProductVersion;
    int databaseMajorVersion;
    TdsConnection connection;
    TdsStatement statement;
    String host;
    int serverType = -1;
    int port;
    String database;
    String user;
    String password;
    String appName;
    String serverName;
    String progName;
    byte progMajorVersion;
    byte progMinorVersion;
    boolean haveProcNameTable = false;
    String procNameGeneratorName = null;
    String procNameTableName = null;
    HashMap procedureCache = null;
    ArrayList proceduresOfTra = null;
    CancelController cancelController = null;
    SqlMessage lastServerMessage = null;
    private EncodingHelper encoder = null;
    private String charset = null;
    private boolean moreResults = false;
    private boolean moreResults2 = true;
    private int tdsVer = 70;
    private boolean showWarnings = false;
    private int zoneOffset = Calendar.getInstance().get(15);
    int maxRows = 0;
    public static final String cvsVersion = "$Id: Tds.java,v 1.7 2003/01/27 09:55:44 alin_sinpalean Exp $";
    static boolean ignoreNotImplemented = false;
    int transactionIsolationLevel = 2;
    boolean autoCommit = true;

    public Tds(TdsConnection tdsConnection, Properties properties) throws IOException, UnknownHostException, SQLException, TdsException {
        this.connection = tdsConnection;
        this.host = properties.getProperty("HOST");
        this.serverType = Integer.parseInt(properties.getProperty("SERVERTYPE"));
        this.port = Integer.parseInt(properties.getProperty("PORT"));
        this.database = null;
        this.user = properties.getProperty("USER");
        this.password = properties.getProperty("PASSWORD");
        this.appName = properties.getProperty("APPNAME", "jdbclib");
        this.serverName = properties.getProperty("SERVERNAME", this.host);
        this.progName = properties.getProperty("PROGNAME", "java_app");
        this.progMajorVersion = (byte)DriverVersion.getDriverMajorVersion();
        this.progMinorVersion = (byte)DriverVersion.getDriverMinorVersion();
        String string = properties.getProperty("TDS", "7.0");
        this.procedureCache = new HashMap();
        this.proceduresOfTra = new ArrayList();
        if (string.equals("5.0")) {
            this.tdsVer = 50;
        } else if (string.equals("4.2")) {
            this.tdsVer = 42;
        }
        if (System.getProperty("TDS_SHOW_WARNINGS") != null || properties.getProperty("TDS_SHOW_WARNINGS") != null) {
            this.showWarnings = true;
        }
        this.cancelController = new CancelController();
        this.sock = new Socket(this.host, this.port);
        this.sock.setTcpNoDelay(true);
        this.comm = new TdsComm(this.sock, this.tdsVer);
        String string2 = properties.getProperty("CHARSET");
        string2 = string2 == null ? properties.getProperty("charset") : string2;
        this.setCharset(string2);
        this.autoCommit = this.connection.getAutoCommit();
        this.transactionIsolationLevel = this.connection.getTransactionIsolation();
        if (!this.logon(properties.getProperty("DBNAME"))) {
            throw new SQLException("Logon failed.  " + this.lastServerMessage);
        }
    }

    public void setStatement(TdsStatement tdsStatement) {
        this.statement = tdsStatement;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public String getDatabase() {
        return this.database;
    }

    public int getServerType() {
        return this.serverType;
    }

    public String getUniqueProcedureName() throws SQLException {
        String string = null;
        if (this.serverType == 2) {
            if (null == this.procNameTableName) {
                this.procNameTableName = this.database + "." + this.user + ".jdbc_temp_stored_proc_names";
                this.procNameGeneratorName = this.user + ".jdbc_gen_temp_sp_names";
            }
            this.haveProcNameTable = this.createStoredProcedureNameTable();
            string = this.generateUniqueProcName();
        } else {
            string = "#jdbc#" + UniqueId.getUniqueId();
        }
        return string;
    }

    public synchronized byte getByte() throws IOException, TdsException {
        return this.comm.getByte();
    }

    public synchronized boolean isResultSet() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == -96 || by == -127;
    }

    public synchronized boolean isRetStat() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == 121;
    }

    public synchronized boolean isResultRow() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == -47;
    }

    public synchronized boolean isEndOfResults() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == -3 || by == -2 || by == -1;
    }

    public synchronized boolean isDoneInProc() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == -1;
    }

    public synchronized boolean isMessagePacket() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == -85;
    }

    public synchronized boolean isParamResult() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == -84;
    }

    public synchronized boolean isErrorPacket() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == -86;
    }

    public synchronized boolean isProcId() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == 124;
    }

    public synchronized boolean isEnvChange() throws TdsException, IOException {
        return this.comm.peek() == -29;
    }

    public void close() {
        this.comm.close();
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "" + this.database + ", " + this.sock.getLocalAddress() + ":" + this.sock.getLocalPort() + " -> " + this.sock.getInetAddress() + ":" + this.sock.getPort();
    }

    private synchronized boolean initSettings(String string) throws SQLException {
        boolean bl = true;
        try {
            if (string.length() > 0) {
                bl = this.changeDB(string);
            }
            if (bl) {
                bl = this.changeSettings(this.sqlStatementToInitialize());
            }
        }
        catch (TdsUnknownPacketSubType tdsUnknownPacketSubType) {
            throw new SQLException("Unknown response. " + tdsUnknownPacketSubType.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException("Network problem. " + iOException.getMessage());
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
        return bl;
    }

    public void cancel() throws IOException, TdsException {
        this.cancelController.doCancel(this.comm);
    }

    public boolean moreResults() {
        return this.moreResults2;
    }

    public synchronized void submitProcedure(String string, SQLWarningChain sQLWarningChain) throws SQLException {
        PacketResult packetResult = null;
        try {
            boolean bl;
            this.executeQuery(string, null, null, 0);
            do {
                if (!((packetResult = this.processSubPacket()) instanceof PacketMsgResult)) continue;
                sQLWarningChain.addOrReturn((PacketMsgResult)packetResult);
            } while (!(bl = packetResult instanceof PacketEndTokenResult && !((PacketEndTokenResult)packetResult).moreResults()));
        }
        catch (IOException iOException) {
            throw new SQLException("Network error" + iOException.getMessage());
        }
        catch (TdsUnknownPacketSubType tdsUnknownPacketSubType) {
            throw new SQLException(tdsUnknownPacketSubType.getMessage());
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
        sQLWarningChain.checkForExceptions();
    }

    public synchronized void executeProcedure(String string, ParameterListItem[] parameterListItemArray, ParameterListItem[] parameterListItemArray2, TdsStatement tdsStatement, SQLWarningChain sQLWarningChain, int n) throws SQLException, TdsException, IOException {
        if (this.cancelController.outstandingCancels() > 0) {
            this.processSubPacket();
            if (this.cancelController.outstandingCancels() > 0) {
                throw new SQLException("Something went completely wrong. A cancel request was lost.");
            }
        }
        this.checkMaxRows(tdsStatement);
        try {
            try {
                this.moreResults2 = true;
                this.comm.startPacket(3);
                if (this.tdsVer == 70) {
                    this.comm.appendTdsShort((short)string.length());
                    this.comm.appendChars(string);
                } else {
                    byte[] byArray = this.encoder.getBytes(string);
                    this.comm.appendByte((byte)byArray.length);
                    this.comm.appendBytes(byArray, byArray.length, (byte)0);
                }
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)0);
                int n2 = 0;
                while (n2 < parameterListItemArray.length) {
                    byte by = Tds.cvtJdbcTypeToNativeType(parameterListItemArray[n2].type);
                    this.comm.appendByte((byte)0);
                    if (parameterListItemArray2[n2].isOutput) {
                        this.comm.appendByte((byte)1);
                        if (by == 50 && parameterListItemArray2[n2].value == null) {
                            parameterListItemArray2[n2].value = Boolean.FALSE;
                        }
                    } else {
                        this.comm.appendByte((byte)0);
                    }
                    if (parameterListItemArray2[n2].value == null && (by == 48 || by == 52 || by == 56)) {
                        by = 38;
                    }
                    switch (by) {
                        case 47: {
                            Object object;
                            try {
                                object = (String)parameterListItemArray2[n2].value;
                            }
                            catch (ClassCastException classCastException) {
                                object = parameterListItemArray2[n2].value instanceof Boolean ? (Object)((Boolean)parameterListItemArray2[n2].value != false ? "1" : "0") : (Object)parameterListItemArray2[n2].value.toString();
                            }
                            if (this.tdsVer < 70 && object != null && ((String)object).length() == 0) {
                                object = " ";
                            }
                            int n3 = object != null ? ((String)object).length() : 0;
                            int n4 = parameterListItemArray[n2].maxLength;
                            if (parameterListItemArray[n2].formalType != null && parameterListItemArray[n2].formalType.startsWith("n")) {
                                if (n4 > 4000) {
                                    this.comm.appendByte((byte)99);
                                    this.comm.appendTdsInt(n4 * 2);
                                    if (object == null) {
                                        this.comm.appendTdsInt(-1);
                                        break;
                                    }
                                    this.comm.appendTdsInt(n3 * 2);
                                    this.comm.appendChars((String)object);
                                    break;
                                }
                                this.comm.appendByte((byte)-25);
                                this.comm.appendTdsShort((short)(n4 * 2));
                                if (object == null) {
                                    this.comm.appendTdsShort((short)-1);
                                    break;
                                }
                                if (((String)object).length() > 4000) {
                                    throw new IOException("Field too long");
                                }
                                this.comm.appendTdsShort((short)(n3 * 2));
                                this.comm.appendChars((String)object);
                                break;
                            }
                            if (this.tdsVer != 70 && n4 > 255) {
                                this.comm.appendByte((byte)35);
                                if (parameterListItemArray2[n2].value instanceof byte[]) {
                                    this.sendSybImage((byte[])parameterListItemArray2[n2].value);
                                    break;
                                }
                                this.sendSybImage(this.encoder.getBytes((String)object));
                                break;
                            }
                            this.sendSybChar((String)object, parameterListItemArray[n2].maxLength);
                            break;
                        }
                        case 38: {
                            this.comm.appendByte((byte)38);
                            this.comm.appendByte((byte)4);
                            if (parameterListItemArray2[n2].value == null) {
                                this.comm.appendByte((byte)0);
                                break;
                            }
                            this.comm.appendByte((byte)4);
                            this.comm.appendTdsInt(((Number)parameterListItemArray2[n2].value).intValue());
                            break;
                        }
                        case 56: {
                            this.comm.appendByte((byte)56);
                            this.comm.appendTdsInt(((Number)parameterListItemArray2[n2].value).intValue());
                            break;
                        }
                        case 52: {
                            this.comm.appendByte((byte)52);
                            this.comm.appendTdsShort(((Number)parameterListItemArray2[n2].value).shortValue());
                            break;
                        }
                        case 48: {
                            this.comm.appendByte((byte)48);
                            this.comm.appendByte(((Number)parameterListItemArray2[n2].value).byteValue());
                            break;
                        }
                        case 62: 
                        case 109: {
                            if (parameterListItemArray2[n2].value == null) {
                                this.comm.appendByte((byte)109);
                                this.comm.appendByte((byte)8);
                                this.comm.appendByte((byte)0);
                                break;
                            }
                            Object object = (Number)parameterListItemArray2[n2].value;
                            Double d = new Double(((Number)object).doubleValue());
                            this.comm.appendByte((byte)62);
                            this.comm.appendFlt8(d);
                            break;
                        }
                        case 111: {
                            this.writeDatetimeValue(parameterListItemArray2[n2].value, 111);
                            break;
                        }
                        case 34: {
                            this.comm.appendByte(by);
                            this.sendSybImage((byte[])parameterListItemArray2[n2].value);
                            break;
                        }
                        case 35: {
                            this.comm.appendByte((byte)35);
                            this.sendSybImage(this.encoder.getBytes((String)parameterListItemArray2[n2].value));
                            break;
                        }
                        case 50: 
                        case 104: {
                            if (parameterListItemArray2[n2].value == null) {
                                this.comm.appendByte((byte)104);
                                this.comm.appendByte((byte)1);
                                this.comm.appendByte((byte)0);
                                break;
                            }
                            this.comm.appendByte((byte)50);
                            if (parameterListItemArray2[n2].value.equals(Boolean.TRUE)) {
                                this.comm.appendByte((byte)1);
                                break;
                            }
                            this.comm.appendByte((byte)0);
                            break;
                        }
                        case 106: 
                        case 108: {
                            this.writeDecimalValue(by, parameterListItemArray2[n2].value, 0, -1);
                            break;
                        }
                        case 37: 
                        case 45: {
                            Object object = (byte[])parameterListItemArray2[n2].value;
                            int n5 = parameterListItemArray[n2].maxLength;
                            if (object == null) {
                                this.comm.appendByte((byte)37);
                                this.comm.appendByte((byte)n5);
                                this.comm.appendByte((byte)0);
                                break;
                            }
                            if (((Object)object).length > 255) {
                                if (this.tdsVer != 70) {
                                    throw new IOException("Field too long");
                                }
                                this.comm.appendByte((byte)-91);
                                if (n5 < 0 || n5 > 8000) {
                                    this.comm.appendTdsShort((short)8000);
                                } else {
                                    this.comm.appendTdsShort((short)n5);
                                }
                                this.comm.appendTdsShort((short)((byte[])object).length);
                            } else {
                                this.comm.appendByte((byte)37);
                                this.comm.appendByte((byte)n5);
                                this.comm.appendByte((byte)((byte[])object).length);
                            }
                            this.comm.appendBytes((byte[])object);
                            break;
                        }
                        default: {
                            throw new SQLException("Not implemented for nativeType 0x" + Integer.toHexString(by));
                        }
                    }
                    ++n2;
                }
                this.cancelController.setQueryInProgressFlag();
                this.comm.sendPacket();
                this.waitForDataOrTimeout(sQLWarningChain, n);
            }
            catch (IOException iOException) {
                throw new SQLException("Network error-  " + iOException.getMessage());
            }
            Object var13_17 = null;
            this.comm.packetType = 0;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            this.comm.packetType = 0;
            throw throwable;
        }
    }

    void checkMaxRows(Statement statement) throws SQLException, TdsException {
        if (statement == null) {
            return;
        }
        int n = statement.getMaxRows();
        if (n != this.maxRows) {
            this.submitProcedure("set rowcount " + n, new SQLWarningChain());
            this.maxRows = n;
        }
    }

    public synchronized void executeQuery(String string, TdsStatement tdsStatement, SQLWarningChain sQLWarningChain, int n) throws IOException, SQLException, TdsException {
        if (this.cancelController.outstandingCancels() > 0) {
            this.waitForDataOrTimeout(sQLWarningChain, n);
            this.processSubPacket();
            if (this.cancelController.outstandingCancels() > 0) {
                throw new SQLException("Something went completely wrong. A cancel request was lost.");
            }
        }
        this.checkMaxRows(tdsStatement);
        if (string.length() > 0) {
            try {
                this.comm.startPacket(1);
                if (this.tdsVer == 70) {
                    this.comm.appendChars(string);
                } else {
                    byte[] byArray = this.encoder.getBytes(string);
                    this.comm.appendBytes(byArray, byArray.length, (byte)0);
                }
                this.moreResults2 = true;
                this.cancelController.setQueryInProgressFlag();
                this.comm.sendPacket();
                this.waitForDataOrTimeout(sQLWarningChain, n);
                Object var7_6 = null;
                this.comm.packetType = 0;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.comm.packetType = 0;
                throw throwable;
            }
        }
    }

    public synchronized void discardResultSet(PacketRowResult packetRowResult) throws SQLException, IOException, TdsException {
        while (this.isResultRow()) {
            this.comm.skip(1);
            if (packetRowResult != null) {
                this.loadRow(packetRowResult);
            }
            if (!Logger.isActive()) continue;
            Logger.println("Discarded row.");
        }
        while (!this.isEndOfResults()) {
            this.processSubPacket();
        }
        this.goToNextResult(new SQLWarningChain());
    }

    public synchronized void discardResultSetOld(Context context) throws SQLException, IOException, TdsException {
        this.discardResultSet(new PacketRowResult(context));
    }

    public synchronized byte peek() throws IOException, TdsException {
        return this.comm.peek();
    }

    protected synchronized void goToNextResult(SQLWarningChain sQLWarningChain) throws TdsException, IOException, SQLException {
        while (this.moreResults()) {
            byte by = this.peek();
            if (by == -3 || by == -127 || by == -96 || by == -1 && this.statement instanceof PreparedStatement && !(this.statement instanceof CallableStatement)) break;
            PacketResult packetResult = this.processSubPacket();
            if (packetResult instanceof PacketOutputParamResult && this.statement != null && this.statement instanceof CallableStatement_base) {
                ((CallableStatement_base)this.statement).addOutputParam(((PacketOutputParamResult)packetResult).getValue());
                continue;
            }
            if (packetResult instanceof PacketEndTokenResult) {
                if (!((PacketEndTokenResult)packetResult).wasCanceled()) continue;
                sQLWarningChain.addException(new SQLException("Query was canceled or timed out."));
                continue;
            }
            if (!(packetResult instanceof PacketMsgResult)) continue;
            sQLWarningChain.addOrReturn((PacketMsgResult)packetResult);
        }
    }

    EncodingHelper getEncoder() {
        return this.encoder;
    }

    int getTdsVer() {
        return this.tdsVer;
    }

    String getDatabaseProductName() {
        return this.databaseProductName;
    }

    String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    private PacketOutputParamResult processOutputParam() throws TdsException, IOException {
        Object object;
        this.getSubPacketLength();
        this.comm.getString(this.comm.getByte() & 0xFF);
        this.comm.skip(5);
        byte by = this.comm.getByte();
        switch (by) {
            case 38: {
                this.comm.getByte();
                object = this.getIntValue(by);
                break;
            }
            case 48: 
            case 52: 
            case 56: {
                object = this.getIntValue(by);
                break;
            }
            case 34: {
                this.comm.getByte();
                object = this.getImageValue();
                break;
            }
            case 35: {
                this.comm.getByte();
                object = this.getTextValue(false);
                break;
            }
            case 99: {
                this.comm.getByte();
                object = this.getTextValue(true);
                break;
            }
            case 39: 
            case 47: {
                this.comm.getByte();
                object = this.getCharValue(false, true);
                break;
            }
            case -91: {
                this.comm.getTdsShort();
                int n = this.comm.getTdsShort();
                object = this.comm.getBytes(n, true);
                break;
            }
            case -89: {
                this.comm.getTdsShort();
                object = this.getCharValue(false, false);
                break;
            }
            case -17: 
            case 103: {
                this.comm.getByte();
                object = this.getCharValue(true, true);
                break;
            }
            case 59: {
                object = this.readFloatN(4);
                break;
            }
            case 62: {
                object = this.readFloatN(8);
                break;
            }
            case 109: {
                this.comm.getByte();
                byte by2 = this.comm.getByte();
                object = this.readFloatN(by2);
                break;
            }
            case 60: 
            case 110: 
            case 122: {
                this.comm.getByte();
                object = this.getMoneyValue(by);
                break;
            }
            case 106: 
            case 108: {
                this.comm.getByte();
                this.comm.getByte();
                byte by3 = this.comm.getByte();
                object = this.getDecimalValue(by3);
                break;
            }
            case 111: {
                this.comm.getByte();
                object = this.getDatetimeValue(by);
                break;
            }
            case 58: 
            case 61: {
                object = this.getDatetimeValue(by);
                break;
            }
            case 37: 
            case 45: {
                this.comm.getByte();
                int n = this.comm.getByte() & 0xFF;
                object = this.comm.getBytes(n, true);
                break;
            }
            case 104: {
                this.comm.getByte();
                if (this.comm.getByte() == 0) {
                    object = null;
                    break;
                }
                object = new Boolean(this.comm.getByte() != 0);
                break;
            }
            case 50: {
                byte by4 = this.comm.getByte();
                object = new Boolean(by4 != 0);
                break;
            }
            case 36: {
                int n = this.comm.getByte() & 0xFF;
                object = n == 0 ? null : TdsUtil.uniqueIdToString(this.comm.getBytes(n, false));
                break;
            }
            default: {
                Object var2_3 = null;
                throw new TdsNotImplemented("Don't now how to handle column type 0x" + Integer.toHexString(by));
            }
        }
        return new PacketOutputParamResult(object);
    }

    PacketResult processSubPacket() throws TdsUnknownPacketSubType, IOException, TdsException, SQLException {
        return this.processSubPacket(null);
    }

    synchronized PacketResult processSubPacket(Context context) throws TdsUnknownPacketSubType, SQLException, IOException, TdsException {
        PacketResult packetResult = null;
        this.moreResults = false;
        byte by = this.comm.getByte();
        if (Logger.isActive()) {
            Logger.println("processSubPacket: " + Integer.toHexString(by & 0xFF) + " " + "moreResults: " + this.moreResults());
        }
        switch (by) {
            case -29: {
                packetResult = this.processEnvChange();
                break;
            }
            case -86: 
            case -85: 
            case -27: {
                packetResult = this.processMsg(by);
                break;
            }
            case -84: {
                packetResult = this.processOutputParam();
                break;
            }
            case -83: {
                packetResult = this.processLoginAck();
                break;
            }
            case 121: {
                packetResult = this.processRetStat();
                break;
            }
            case 124: {
                packetResult = this.processProcId();
                break;
            }
            case -3: 
            case -2: 
            case -1: {
                packetResult = this.processEndToken(by);
                this.moreResults2 = ((PacketEndTokenResult)packetResult).moreResults();
                break;
            }
            case -96: {
                packetResult = this.processColumnNames();
                break;
            }
            case -95: {
                packetResult = this.processColumnInfo();
                break;
            }
            case -91: 
            case -89: 
            case -88: {
                this.comm.skip(this.comm.getTdsShort());
                packetResult = new PacketUnknown(by);
                break;
            }
            case -92: {
                packetResult = this.processTabName();
                break;
            }
            case -87: {
                int n = this.comm.getTdsShort();
                this.comm.skip(n);
                packetResult = new PacketColumnOrderResult();
                break;
            }
            case -82: {
                int n = this.comm.getTdsShort();
                this.comm.skip(n);
                packetResult = new PacketControlResult();
                break;
            }
            case -47: {
                packetResult = this.getRow(context);
                break;
            }
            case -127: {
                packetResult = this.processTds7Result();
                break;
            }
            default: {
                throw new TdsUnknownPacketSubType(by);
            }
        }
        return packetResult;
    }

    private void setCharset(String string) {
        if (string == null || string.length() > 30) {
            string = "iso_1";
        }
        if (string.startsWith("cp")) {
            string = "Cp" + string.substring(2);
        }
        if (!string.equals(this.charset)) {
            this.encoder = EncodingHelper.getHelper(string);
            this.charset = string;
        }
    }

    private String getClientName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (!stringTokenizer.hasMoreTokens()) {
            return "JOHNDOE";
        }
        string = stringTokenizer.nextToken();
        if (string.length() == 0) {
            return "JANEDOE";
        }
        if (Character.isDigit(string.charAt(0))) {
            return "BABYDOE";
        }
        return string.toUpperCase();
    }

    private int getSubPacketLength() throws IOException, TdsException {
        return this.comm.getTdsShort();
    }

    private boolean isFixedSizeColumn(byte by) throws TdsException {
        switch (by) {
            case 48: 
            case 50: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 112: 
            case 122: {
                return true;
            }
            case -17: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 99: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return false;
            }
        }
        throw new TdsException("Unrecognized column type 0x" + Integer.toHexString(by));
    }

    private Object getMoneyValue(int n) throws IOException, TdsException {
        BigDecimal bigDecimal;
        int n2;
        switch (n) {
            case 112: 
            case 122: {
                n2 = 4;
                break;
            }
            case 60: {
                n2 = 8;
                break;
            }
            case 110: {
                n2 = this.comm.getByte();
                break;
            }
            default: {
                throw new TdsException("Not a money value.");
            }
        }
        if (n2 == 0) {
            bigDecimal = null;
        } else {
            BigInteger bigInteger = null;
            if (n2 == 4) {
                bigInteger = BigInteger.valueOf(this.comm.getTdsInt());
            } else if (n2 == 8) {
                byte by = this.comm.getByte();
                byte by2 = this.comm.getByte();
                byte by3 = this.comm.getByte();
                byte by4 = this.comm.getByte();
                byte by5 = this.comm.getByte();
                byte by6 = this.comm.getByte();
                byte by7 = this.comm.getByte();
                byte by8 = this.comm.getByte();
                long l = (long)(by5 & 0xFF) + ((long)(by6 & 0xFF) << 8) + ((long)(by7 & 0xFF) << 16) + ((long)(by8 & 0xFF) << 24) + ((long)(by & 0xFF) << 32) + ((long)(by2 & 0xFF) << 40) + ((long)(by3 & 0xFF) << 48) + ((long)(by4 & 0xFF) << 56);
                bigInteger = BigInteger.valueOf(l);
            } else {
                throw new TdsConfused("Don't know what to do with len of " + n2);
            }
            bigDecimal = new BigDecimal(bigInteger, 4);
        }
        return bigDecimal;
    }

    private Object getDecimalValue(int n) throws TdsException, IOException, NumberFormatException {
        int n2 = this.comm.getByte() & 0xFF;
        if (--n2 < 1) {
            return null;
        }
        byte[] byArray = new byte[n2];
        int n3 = this.comm.getByte() == 0 ? -1 : 1;
        while (n2 > 0) {
            byArray[--n2] = this.comm.getByte();
        }
        BigInteger bigInteger = new BigInteger(n3, byArray);
        return new BigDecimal(bigInteger, n);
    }

    private Object getDatetimeValue(int n) throws IOException, TdsException {
        Timestamp timestamp;
        int n2 = n == 111 ? this.comm.getByte() : (n == 58 ? 4 : 8);
        switch (n2) {
            case 0: {
                timestamp = null;
                break;
            }
            case 8: {
                long l = this.comm.getTdsInt();
                long l2 = this.comm.getTdsInt();
                long l3 = l - 25567L;
                long l4 = l3 * 86400L + l2 / 300L;
                long l5 = l2 % 300L * 1000000L / 300L;
                long l6 = l4 * 1000L + l5 / 1000L - (long)this.zoneOffset;
                if (l5 % 1000L >= 500L) {
                    ++l6;
                }
                timestamp = new Timestamp(l6 - this.getDstOffset(l6));
                break;
            }
            case 4: {
                long l = this.comm.getTdsShort();
                long l7 = this.comm.getTdsShort();
                long l8 = l - 25567L;
                long l9 = l8 * 86400L + l7 * 60L;
                long l10 = l9 * 1000L - (long)this.zoneOffset;
                timestamp = new Timestamp(l10 - this.getDstOffset(l10));
                break;
            }
            default: {
                Object var7_4 = null;
                throw new TdsNotImplemented("Don't now how to handle date with size of " + n2);
            }
        }
        return timestamp;
    }

    private long getDstOffset(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new java.util.Date(l));
        return calendar.get(16);
    }

    private Object getIntValue(int n) throws IOException, TdsException {
        Integer n2;
        int n3;
        switch (n) {
            case 38: {
                n3 = this.comm.getByte();
                break;
            }
            case 56: {
                n3 = 4;
                break;
            }
            case 52: {
                n3 = 2;
                break;
            }
            case 48: {
                n3 = 1;
                break;
            }
            default: {
                throw new TdsNotImplemented("Can't handle integer of type " + Integer.toHexString(n));
            }
        }
        switch (n3) {
            case 4: {
                n2 = new Integer(this.comm.getTdsInt());
                break;
            }
            case 2: {
                n2 = new Integer((short)this.comm.getTdsShort());
                break;
            }
            case 1: {
                n2 = new Integer(Tds.toUInt(this.comm.getByte()));
                break;
            }
            case 0: {
                n2 = null;
                break;
            }
            default: {
                throw new TdsConfused("Bad SYBINTN length of " + n3);
            }
        }
        return n2;
    }

    private Object getCharValue(boolean bl, boolean bl2) throws TdsException, IOException {
        String string;
        int n;
        boolean bl3 = this.tdsVer == 70 && (bl || !bl2);
        int n2 = n = bl3 ? this.comm.getTdsShort() : this.comm.getByte() & 0xFF;
        if (this.tdsVer < 70 && n == 0 || this.tdsVer == 70 && n == 65535) {
            string = null;
        } else if (n >= 0) {
            string = bl ? this.comm.getString(n / 2) : this.encoder.getString(this.comm.getBytes(n, false), 0, n);
            if (this.tdsVer < 70 && " ".equals(string)) {
                string = "";
            }
        } else {
            throw new TdsConfused("String with length<0");
        }
        return string;
    }

    private Object getTextValue(boolean bl) throws TdsException, IOException {
        String string;
        byte by = this.comm.getByte();
        if (by == 0) {
            string = null;
        } else {
            this.comm.skip(24);
            int n = this.comm.getTdsInt();
            if (n >= 0) {
                string = bl ? this.comm.getString(n / 2) : this.encoder.getString(this.comm.getBytes(n, false), 0, n);
                if (this.tdsVer < 70 && " ".equals(string)) {
                    string = "";
                }
            } else {
                throw new TdsConfused("String with length<0");
            }
        }
        return string;
    }

    private Object getImageValue() throws TdsException, IOException {
        byte[] byArray;
        byte by = this.comm.getByte();
        if (by == 0) {
            byArray = null;
        } else {
            this.comm.skip(24);
            int n = this.comm.getTdsInt();
            if (n >= 0) {
                byArray = this.comm.getBytes(n, true);
            } else {
                throw new TdsConfused("String with length<0");
            }
        }
        return byArray;
    }

    private synchronized PacketRowResult loadRow(PacketRowResult packetRowResult) throws SQLException, TdsException, IOException {
        Columns columns = packetRowResult.getContext().getColumnInfo();
        int n = 1;
        while (n <= columns.realColumnCount()) {
            Object object;
            int n2 = columns.getNativeType(n);
            if (Logger.isActive()) {
                Logger.println("colno=" + n + " type=" + n2 + " offset=" + Integer.toHexString(this.comm.inBufferIndex));
            }
            switch (n2) {
                case 38: 
                case 48: 
                case 52: 
                case 56: {
                    object = this.getIntValue(n2);
                    break;
                }
                case 34: {
                    object = this.getImageValue();
                    break;
                }
                case 35: {
                    object = this.getTextValue(false);
                    break;
                }
                case 99: {
                    object = this.getTextValue(true);
                    break;
                }
                case 39: 
                case 47: {
                    object = this.getCharValue(false, false);
                    break;
                }
                case -17: 
                case 103: {
                    object = this.getCharValue(true, false);
                    break;
                }
                case 59: {
                    object = this.readFloatN(4);
                    break;
                }
                case 62: {
                    object = this.readFloatN(8);
                    break;
                }
                case 109: {
                    int n3 = this.comm.getByte();
                    object = this.readFloatN(n3);
                    break;
                }
                case 60: 
                case 110: 
                case 122: {
                    object = this.getMoneyValue(n2);
                    break;
                }
                case 106: 
                case 108: {
                    object = this.getDecimalValue(columns.getScale(n));
                    break;
                }
                case 58: 
                case 61: 
                case 111: {
                    object = this.getDatetimeValue(n2);
                    break;
                }
                case 37: 
                case 45: {
                    int n3;
                    int n4 = n3 = this.tdsVer == 70 ? this.comm.getTdsShort() : this.comm.getByte() & 0xFF;
                    if (this.tdsVer == 70 && n3 == 65535) {
                        object = null;
                        break;
                    }
                    object = this.comm.getBytes(n3, true);
                    break;
                }
                case 50: 
                case 104: {
                    if (n2 == 104 && this.comm.getByte() == 0) {
                        object = null;
                        break;
                    }
                    object = new Boolean(this.comm.getByte() != 0);
                    break;
                }
                case 36: {
                    int n3 = this.comm.getByte() & 0xFF;
                    object = n3 == 0 ? null : TdsUtil.uniqueIdToString(this.comm.getBytes(n3, false));
                    break;
                }
                default: {
                    object = null;
                    throw new TdsNotImplemented("Don't now how to handle column type 0x" + Integer.toHexString(n2));
                }
            }
            packetRowResult.setElementAt(n, object);
            ++n;
        }
        return packetRowResult;
    }

    private synchronized PacketRowResult getRow(Context context) throws SQLException, TdsException, IOException {
        PacketRowResult packetRowResult = new PacketRowResult(context);
        return this.loadRow(packetRowResult);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean logon(String var1_1) throws SQLException, TdsUnknownPacketSubType, IOException, TdsException {
        var2_2 = true;
        var3_3 = 0;
        var4_4 = new byte[]{};
        try {
            if (this.tdsVer == 70) {
                this.send70Login(var1_1);
                var1_1 = "";
            } else {
                this.comm.startPacket(2);
                var5_5 /* !! */  = this.encoder.getBytes(this.getClientName());
                this.comm.appendBytes(var5_5 /* !! */ , 30, var3_3);
                this.comm.appendByte(var5_5 /* !! */ .length < 30 ? (byte)var5_5 /* !! */ .length : 30);
                var5_5 /* !! */  = this.encoder.getBytes(this.user);
                this.comm.appendBytes(var5_5 /* !! */ , 30, var3_3);
                this.comm.appendByte(var5_5 /* !! */ .length < 30 ? (byte)var5_5 /* !! */ .length : 30);
                var5_5 /* !! */  = this.encoder.getBytes(this.password);
                this.comm.appendBytes(var5_5 /* !! */ , 30, var3_3);
                this.comm.appendByte(var5_5 /* !! */ .length < 30 ? (byte)var5_5 /* !! */ .length : 30);
                var5_5 /* !! */  = this.encoder.getBytes("00000116");
                this.comm.appendBytes(var5_5 /* !! */ , 8, var3_3);
                this.comm.appendBytes(var4_4, 16, var3_3);
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)-96);
                this.comm.appendByte((byte)36);
                this.comm.appendByte((byte)-52);
                this.comm.appendByte((byte)80);
                this.comm.appendByte((byte)18);
                this.comm.appendByte((byte)8);
                this.comm.appendByte((byte)3);
                this.comm.appendByte((byte)1);
                this.comm.appendByte((byte)6);
                this.comm.appendByte((byte)10);
                this.comm.appendByte((byte)9);
                this.comm.appendByte((byte)1);
                this.comm.appendByte((byte)1);
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)0);
                this.comm.appendBytes(var4_4, 7, var3_3);
                var5_5 /* !! */  = this.encoder.getBytes(this.appName);
                this.comm.appendBytes(var5_5 /* !! */ , 30, var3_3);
                this.comm.appendByte(var5_5 /* !! */ .length < 30 ? (byte)var5_5 /* !! */ .length : 30);
                var5_5 /* !! */  = this.encoder.getBytes(this.serverName);
                this.comm.appendBytes(var5_5 /* !! */ , 30, var3_3);
                this.comm.appendByte(var5_5 /* !! */ .length < 30 ? (byte)var5_5 /* !! */ .length : 30);
                this.comm.appendBytes(var4_4, 2, var3_3);
                var5_5 /* !! */  = this.encoder.getBytes(this.password);
                this.comm.appendBytes(var5_5 /* !! */ , 253, var3_3);
                this.comm.appendByte(var5_5 /* !! */ .length < 253 ? (byte)(var5_5 /* !! */ .length + 2) : -1);
                this.comm.appendByte((byte)4);
                this.comm.appendByte((byte)2);
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)0);
                var5_5 /* !! */  = this.encoder.getBytes(this.progName);
                this.comm.appendBytes(var5_5 /* !! */ , 10, var3_3);
                this.comm.appendByte(var5_5 /* !! */ .length < 10 ? (byte)var5_5 /* !! */ .length : 10);
                this.comm.appendByte((byte)6);
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)13);
                this.comm.appendByte((byte)17);
                var5_5 /* !! */  = this.encoder.getBytes("us_english");
                this.comm.appendBytes(var5_5 /* !! */ , 30, var3_3);
                this.comm.appendByte(var5_5 /* !! */ .length < 30 ? (byte)var5_5 /* !! */ .length : 30);
                this.comm.appendByte((byte)1);
                this.comm.appendShort((short)0);
                this.comm.appendBytes(var4_4, 8, var3_3);
                this.comm.appendShort((short)0);
                this.comm.appendByte((byte)0);
                var5_5 /* !! */  = this.encoder.getBytes(this.charset);
                this.comm.appendBytes(var5_5 /* !! */ , 30, var3_3);
                this.comm.appendByte(var5_5 /* !! */ .length < 30 ? (byte)var5_5 /* !! */ .length : 30);
                this.comm.appendByte((byte)1);
                var5_5 /* !! */  = this.encoder.getBytes("512");
                this.comm.appendBytes(var5_5 /* !! */ , 6, var3_3);
                this.comm.appendByte((byte)3);
                this.comm.appendBytes(var4_4, 8, var3_3);
                this.moreResults2 = true;
            }
            this.comm.sendPacket();
            var7_6 = null;
            this.comm.packetType = 0;
            if (true) ** GOTO lbl93
        }
        catch (Throwable var6_8) {
            var7_7 = null;
            this.comm.packetType = 0;
            throw var6_8;
        }
        do {
            if (var5_5 /* !! */  instanceof PacketErrorResult) {
                var2_2 = false;
            }
lbl93:
            // 4 sources

            v0 = this.processSubPacket();
            var5_5 /* !! */  = (byte[])v0;
        } while (!(v0 instanceof PacketEndTokenResult));
        if (var2_2) {
            var2_2 = this.initSettings(var1_1);
        }
        return var2_2;
    }

    private void send70Login(String string) throws IOException, TdsException {
        String string2 = "jTDS";
        byte by = 0;
        byte[] byArray = new byte[]{};
        String string3 = "jTDS";
        short s = (short)(86 + 2 * (this.user.length() + this.password.length() + string3.length() + this.serverName.length() + string2.length() + string.length()));
        this.comm.startPacket(16);
        this.comm.appendTdsInt(s);
        this.comm.appendTdsInt(0x70000000);
        this.comm.appendBytes(byArray, 16, by);
        this.comm.appendByte((byte)-32);
        this.comm.appendByte((byte)3);
        this.comm.appendBytes(byArray, 10, by);
        short s2 = 86;
        this.comm.appendTdsShort(s2);
        this.comm.appendTdsShort((short)0);
        this.comm.appendTdsShort(s2);
        this.comm.appendTdsShort((short)this.user.length());
        s2 = (short)(s2 + this.user.length() * 2);
        this.comm.appendTdsShort(s2);
        this.comm.appendTdsShort((short)this.password.length());
        s2 = (short)(s2 + this.password.length() * 2);
        this.comm.appendTdsShort(s2);
        this.comm.appendTdsShort((short)string3.length());
        s2 = (short)(s2 + string3.length() * 2);
        this.comm.appendTdsShort(s2);
        this.comm.appendTdsShort((short)this.serverName.length());
        s2 = (short)(s2 + this.serverName.length() * 2);
        this.comm.appendTdsShort((short)0);
        this.comm.appendTdsShort((short)0);
        this.comm.appendTdsShort(s2);
        this.comm.appendTdsShort((short)string2.length());
        s2 = (short)(s2 + string2.length() * 2);
        this.comm.appendTdsShort(s2);
        this.comm.appendTdsShort((short)0);
        this.comm.appendTdsShort(s2);
        this.comm.appendTdsShort((short)string.length());
        s2 = (short)(s2 + string.length() * 2);
        this.comm.appendBytes(byArray, 6, by);
        this.comm.appendTdsShort(s2);
        this.comm.appendTdsShort((short)0);
        this.comm.appendTdsInt(s);
        String string4 = Tds.tds7CryptPass(this.password);
        this.comm.appendChars(this.user);
        this.comm.appendChars(string4);
        this.comm.appendChars(string3);
        this.comm.appendChars(this.serverName);
        this.comm.appendChars(string2);
        this.comm.appendChars(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized boolean changeDB(String string) throws SQLException {
        boolean bl = true;
        try {
            if (string.length() > 32) throw new SQLException("Name too long - " + string);
            if (string.length() < 1) {
                throw new SQLException("Name too long - " + string);
            }
            int n = 0;
            while (true) {
                if (n >= string.length()) {
                    if (string.charAt(0) >= '0' && string.charAt(0) <= '9') {
                        string = "\"" + string + "\"";
                    }
                    try {
                        String string2 = "use " + string;
                        this.comm.startPacket(1);
                        if (this.tdsVer == 70) {
                            this.comm.appendChars(string2);
                        } else {
                            byte[] byArray = this.encoder.getBytes(string2);
                            this.comm.appendBytes(byArray, byArray.length, (byte)0);
                        }
                        this.moreResults2 = true;
                        this.comm.sendPacket();
                        Object var8_9 = null;
                        this.comm.packetType = 0;
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        this.comm.packetType = 0;
                        throw throwable;
                    }
                }
                char c = string.charAt(n);
                if (!(c == '_' && n != 0 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    if (c < '0') throw new SQLException("Bad database name- " + string);
                    if (c > '9') {
                        throw new SQLException("Bad database name- " + string);
                    }
                }
                ++n;
            }
            while (true) {
                PacketResult packetResult;
                if ((packetResult = this.processSubPacket()) instanceof PacketEndTokenResult) {
                    return bl;
                }
                if (!(packetResult instanceof PacketErrorResult)) continue;
                bl = false;
            }
        }
        catch (TdsUnknownPacketSubType tdsUnknownPacketSubType) {
            throw new SQLException("Unknown response. " + tdsUnknownPacketSubType.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException("Network problem. " + iOException.getMessage());
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.toString());
        }
    }

    private PacketMsgResult processMsg(byte by) throws IOException, TdsException {
        String string;
        SqlMessage sqlMessage = new SqlMessage();
        this.getSubPacketLength();
        sqlMessage.number = this.comm.getTdsInt();
        sqlMessage.state = this.comm.getByte();
        sqlMessage.severity = this.comm.getByte();
        int n = this.comm.getTdsShort();
        sqlMessage.message = this.comm.getString(n);
        if (this.showWarnings && sqlMessage.message != null && (string = sqlMessage.message.trim()).length() > 0) {
            System.err.println("Server message: " + string);
        }
        int n2 = this.comm.getByte() & 0xFF;
        sqlMessage.server = this.comm.getString(n2);
        if (by != -85 && by != -86) {
            throw new TdsConfused("Was expecting a msg or error token.  Found 0x" + Integer.toHexString(by & 0xFF));
        }
        int n3 = this.comm.getByte() & 0xFF;
        sqlMessage.procName = this.comm.getString(n3);
        sqlMessage.line = this.comm.getByte();
        this.comm.getByte();
        this.lastServerMessage = sqlMessage;
        if (by == -86) {
            return new PacketErrorResult(by, sqlMessage);
        }
        return new PacketMsgResult(by, sqlMessage);
    }

    private PacketResult processEnvChange() throws IOException, TdsException {
        int n = this.getSubPacketLength();
        byte by = this.comm.getByte();
        switch (by) {
            case 4: {
                String string;
                int n2 = this.comm.getByte() & 0xFF;
                if (this.tdsVer == 70) {
                    string = this.comm.getString(n2);
                    this.comm.skip(n - 2 - n2 * 2);
                } else {
                    string = this.encoder.getString(this.comm.getBytes(n2, false), 0, n2);
                    this.comm.skip(n - 2 - n2);
                }
                this.comm.resizeOutbuf(Integer.parseInt(string));
                if (!Logger.isActive()) break;
                Logger.println("Changed blocksize to " + string);
                break;
            }
            case 3: {
                String string;
                int n3 = this.comm.getByte() & 0xFF;
                if (this.tdsVer == 70) {
                    string = this.comm.getString(n3);
                    this.comm.skip(n - 2 - n3 * 2);
                } else {
                    string = this.encoder.getString(this.comm.getBytes(n3, false), 0, n3);
                    this.comm.skip(n - 2 - n3);
                }
                this.setCharset(string);
                if (!Logger.isActive()) break;
                Logger.println("Changed charset to " + string + '/' + this.encoder.getName());
                break;
            }
            case 1: {
                String string;
                int n4 = this.comm.getByte() & 0xFF;
                String string2 = this.tdsVer == 70 ? this.comm.getString(n4) : this.encoder.getString(this.comm.getBytes(n4, false), 0, n4);
                n4 = this.comm.getByte() & 0xFF;
                String string3 = string = this.tdsVer == 70 ? this.comm.getString(n4) : this.encoder.getString(this.comm.getBytes(n4, false), 0, n4);
                if (this.database != null && !string.equals(this.database)) {
                    throw new TdsException("Old database mismatch.");
                }
                this.database = string2;
                if (!Logger.isActive()) break;
                Logger.println("Changed database to " + this.database);
                break;
            }
            default: {
                this.comm.skip(n - 1);
            }
        }
        return new PacketResult(-29);
    }

    private PacketColumnNamesResult processColumnNames() throws IOException, TdsException {
        Columns columns = new Columns();
        int n = this.comm.getTdsShort();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = this.comm.getByte();
            String string = this.encoder.getString(this.comm.getBytes(by, false), 0, by);
            n2 = n2 + 1 + by;
            columns.setName(++n3, string);
            columns.setLabel(n3, string);
        }
        return new PacketColumnNamesResult(columns);
    }

    private PacketColumnInfoResult processColumnInfo() throws IOException, TdsException {
        int n;
        Columns columns = new Columns();
        int n2 = this.comm.getTdsShort();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = -1;
            int n6 = -1;
            n = -1;
            int n7 = -1;
            byte[] byArray = new byte[4];
            int n8 = 0;
            while (n8 < 4) {
                byArray[n8] = this.comm.getByte();
                ++n3;
                ++n8;
            }
            boolean bl = (byArray[2] & 1) > 0;
            boolean bl2 = (byArray[2] & 2) > 0;
            boolean bl3 = (byArray[2] & 0xC) > 0;
            boolean bl4 = (byArray[2] & 0x10) > 0;
            String string = "";
            byte by = this.comm.getByte();
            ++n3;
            if (by == 35 || by == 34) {
                this.comm.skip(4);
                n3 += 4;
                int n9 = this.comm.getTdsShort();
                n3 += 2;
                string = this.encoder.getString(this.comm.getBytes(n9, false), 0, n9);
                n3 += n9;
                n = Integer.MIN_VALUE;
            } else if (by == 106 || by == 108) {
                n = this.comm.getByte();
                ++n3;
                n6 = this.comm.getByte();
                ++n3;
                n5 = this.comm.getByte();
                ++n3;
            } else if (this.isFixedSizeColumn(by)) {
                n = this.lookupBufferSize(by);
            } else {
                n = this.comm.getByte() & 0xFF;
                ++n3;
            }
            this.populateColumn(columns.getColumn(++n4), by, null, n7, n, bl, bl4, bl3, bl2, string, n6, n5);
        }
        n = n2 - n3;
        if (n != 0) {
            throw new TdsException("skipping " + n + " bytes");
        }
        return new PacketColumnInfoResult(columns);
    }

    private PacketTabNameResult processTabName() throws IOException, TdsException {
        int n = this.comm.getTdsShort();
        this.comm.skip(n);
        return new PacketTabNameResult();
    }

    private PacketEndTokenResult processEndToken(byte by) throws TdsException, IOException {
        byte by2 = this.comm.getByte();
        this.comm.getByte();
        byte by3 = this.comm.getByte();
        this.comm.getByte();
        int n = this.comm.getTdsInt();
        if (by3 == -63) {
            n = 0;
        }
        if (by == -2) {
            n = -1;
        }
        PacketEndTokenResult packetEndTokenResult = new PacketEndTokenResult(by, by2, n);
        this.moreResults = packetEndTokenResult.moreResults();
        this.cancelController.finishQuery(packetEndTokenResult.wasCanceled(), packetEndTokenResult.moreResults());
        return packetEndTokenResult;
    }

    private PacketDoneInProcResult processDoneInProc(byte by) throws SQLException, TdsException, IOException {
        byte by2 = this.comm.getByte();
        this.comm.skip(3);
        int n = this.comm.getTdsInt();
        PacketDoneInProcResult packetDoneInProcResult = new PacketDoneInProcResult(by, by2, n);
        if (!packetDoneInProcResult.moreResults()) {
            throw new TdsException("What? No more results with a DONEINPROC!");
        }
        if (packetDoneInProcResult.moreResults() && this.peek() == -1) {
            packetDoneInProcResult = (PacketDoneInProcResult)this.processSubPacket();
        }
        while (packetDoneInProcResult.moreResults() && (this.peek() == 124 || this.peek() == 121)) {
            if (this.peek() == 124) {
                this.processSubPacket();
                continue;
            }
            if (this.peek() != 121) continue;
            PacketRetStatResult packetRetStatResult = (PacketRetStatResult)this.processSubPacket();
            packetDoneInProcResult.setRetStat(packetRetStatResult.getRetStat());
        }
        this.cancelController.finishQuery(packetDoneInProcResult.wasCanceled(), packetDoneInProcResult.moreResults());
        return packetDoneInProcResult;
    }

    private int lookupBufferSize(byte by) throws TdsException {
        switch (by) {
            case 48: {
                return 1;
            }
            case 52: {
                return 2;
            }
            case 56: {
                return 4;
            }
            case 59: {
                return 4;
            }
            case 62: {
                return 8;
            }
            case 61: {
                return 8;
            }
            case 58: {
                return 4;
            }
            case 50: {
                return 1;
            }
            case 60: {
                return 8;
            }
            case 112: 
            case 122: {
                return 4;
            }
        }
        throw new TdsException("Not fixed size column " + by);
    }

    private int lookupDisplaySize(byte by) throws TdsException {
        switch (by) {
            case 48: {
                return 3;
            }
            case 52: {
                return 6;
            }
            case 56: {
                return 11;
            }
            case 59: {
                return 14;
            }
            case 62: {
                return 24;
            }
            case 61: {
                return 23;
            }
            case 58: {
                return 16;
            }
            case 50: {
                return 1;
            }
            case 60: {
                return 21;
            }
            case 112: 
            case 122: {
                return 12;
            }
        }
        throw new TdsException("Not fixed size column " + by);
    }

    private void writeDatetimeValue(Object object, int n) throws IOException {
        this.comm.appendByte((byte)n);
        if (object == null) {
            this.comm.appendByte((byte)8);
            this.comm.appendByte((byte)0);
        } else {
            long l = 0L;
            if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                l = ((java.util.Date)timestamp).getTime();
                if (l % 1000L == 0L) {
                    l += (long)(timestamp.getNanos() / 1000000);
                }
            } else {
                l = ((java.util.Date)object).getTime();
            }
            l += (long)this.zoneOffset;
            l += this.getDstOffset(l);
            long l2 = l % 86400000L;
            long l3 = l / 86400000L;
            if (object instanceof Date) {
                l2 = 0L;
            } else if (object instanceof Time) {
                l3 = 0L;
            }
            int n2 = (int)l3 + 25567;
            if (l2 % 60000L == 0L && n2 < Short.MAX_VALUE) {
                this.comm.appendByte((byte)4);
                this.comm.appendByte((byte)4);
                this.comm.appendTdsShort((short)n2);
                this.comm.appendTdsShort((short)(l2 / 60000L));
            } else {
                int n3 = (int)((l2 * 300L + 100L) / 1000L);
                this.comm.appendByte((byte)8);
                this.comm.appendByte((byte)8);
                this.comm.appendTdsInt(n2);
                this.comm.appendTdsInt(n3);
            }
        }
    }

    private void writeDecimalValue(byte by, Object object, int n, int n2) throws TdsException, IOException {
        this.comm.appendByte((byte)106);
        if (object == null) {
            this.comm.appendByte((byte)0);
            this.comm.appendByte((byte)28);
            this.comm.appendByte((byte)12);
            this.comm.appendByte((byte)0);
        } else if (object instanceof Long) {
            long l = (Long)object;
            this.comm.appendByte((byte)9);
            this.comm.appendByte((byte)28);
            this.comm.appendByte((byte)0);
            this.comm.appendByte((byte)9);
            if (l >= 0L) {
                this.comm.appendByte((byte)1);
            } else {
                this.comm.appendByte((byte)0);
                l = -l;
            }
            int n3 = 0;
            while (n3 < 8) {
                this.comm.appendByte((byte)(l & 0xFFL));
                l >>>= 8;
                ++n3;
            }
        } else {
            int n4;
            byte by2;
            byte[] byArray;
            byte by3;
            BigDecimal bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : (object instanceof Number ? new BigDecimal(((Number)object).doubleValue()) : (object instanceof Boolean ? new BigDecimal((Boolean)object != false ? 1.0 : 0.0) : new BigDecimal(object.toString())));
            boolean bl = false;
            byte by4 = bigDecimal.signum() < 0 ? (byte)0 : 1;
            do {
                by3 = (byte)bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                byArray = bigInteger.abs().toByteArray();
                by2 = (byte)(byArray.length + 1);
                if (by2 <= 13) break;
                n4 = by2 - 13;
                if ((by3 = (byte)(by3 - n4 * 2)) < 0) {
                    throw new TdsException("can\u00b4t sent this BigDecimal");
                }
                bigDecimal = bigDecimal.setScale((int)by3, 4);
            } while (bl = true);
            byte by5 = 28;
            this.comm.appendByte(by2);
            this.comm.appendByte(by5);
            this.comm.appendByte(by3);
            this.comm.appendByte(by2);
            this.comm.appendByte(by4);
            n4 = byArray.length - 1;
            while (n4 >= 0) {
                this.comm.appendByte(byArray[n4]);
                --n4;
            }
        }
    }

    private Object readFloatN(int n) throws TdsException, IOException {
        Number number;
        switch (n) {
            case 8: {
                long l = this.comm.getTdsInt64();
                number = new Double(Double.longBitsToDouble(l));
                break;
            }
            case 4: {
                int n2 = this.comm.getTdsInt();
                number = new Float(Float.intBitsToFloat(n2));
                break;
            }
            case 0: {
                number = null;
                break;
            }
            default: {
                throw new TdsNotImplemented("Don't now how to handle float with size of " + n + "(0x" + Integer.toHexString(n & 0xFF) + ")");
            }
        }
        return number;
    }

    private boolean createStoredProcedureNameTable() {
        boolean bl = false;
        String string = null;
        try {
            Statement statement = this.connection.createStatement();
            try {
                string = "create table " + this.procNameTableName + "(                                       " + "     id        NUMERIC(10, 0) IDENTITY, " + "     session   int not null,            " + "     name      char(29) not null        " + ")                                       ";
                statement.executeUpdate(string);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                string = "create procedure " + this.procNameGeneratorName + "        " + "as                                                    " + "begin tran                                            " + "insert into " + this.procNameTableName + "                 " + "    (session, name)                                   " + " values                                               " + "    (@@spid, '')                                      " + "                                                      " + "update " + this.procNameTableName + "                      " + "  set name=('" + this.user + ".jdbctmpsp' +                " + "            convert(varchar, @@IDENTITY))             " + "  where id = @@IDENTITY                               " + "                                                      " + "select name from " + this.procNameTableName + "            " + "   where id=@@IDENTITY                                " + "                                                      " + "commit tran                                           " + "";
                statement.execute(string);
                statement.execute("sp_procxmode " + this.procNameGeneratorName + ", 'anymode' ");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    private String generateUniqueProcName() throws SQLException {
        Statement statement = this.connection.createStatement();
        boolean bl = statement.execute("exec " + this.procNameGeneratorName);
        if (!bl) {
            throw new SQLException("Confused.  Was expecting a result set.");
        }
        ResultSet resultSet = statement.getResultSet();
        if (!resultSet.next()) {
            throw new SQLException("Couldn't get stored proc name");
        }
        return resultSet.getString(1);
    }

    private void sendSybImage(byte[] byArray) throws IOException {
        int n = byArray == null ? 0 : byArray.length;
        this.comm.appendTdsInt(n);
        this.comm.appendTdsInt(n);
        int n2 = 0;
        while (n2 < n) {
            this.comm.appendByte(byArray[n2]);
            ++n2;
        }
    }

    private void sendSybChar(String string, int n) throws IOException {
        if (string == null) {
            this.comm.appendByte((byte)39);
            this.comm.appendByte((byte)(n > 255 ? -1 : (byte)n));
            this.comm.appendByte((byte)0);
            return;
        }
        byte[] byArray = this.encoder.getBytes(string);
        if (this.tdsVer == 70) {
            this.comm.appendByte((byte)-89);
            this.comm.appendTdsShort((short)n);
            this.comm.appendTdsShort((short)byArray.length);
        } else {
            if (n > 255 || byArray.length > 255) {
                throw new IOException("String too long");
            }
            this.comm.appendByte((byte)39);
            this.comm.appendByte((byte)n);
            if (byArray.length != 0) {
                this.comm.appendByte((byte)byArray.length);
            } else {
                this.comm.appendByte((byte)1);
                this.comm.appendByte((byte)32);
            }
        }
        this.comm.appendBytes(byArray);
    }

    private PacketResult processLoginAck() throws TdsException, IOException {
        short s;
        this.getSubPacketLength();
        if (this.tdsVer == 70) {
            this.comm.skip(5);
            s = this.comm.getByte();
            this.databaseProductName = this.comm.getString(s);
            byte by = this.comm.getByte();
            this.databaseMajorVersion = by;
            this.databaseProductVersion = "0" + by + ".0" + this.comm.getByte() + ".0" + (256 * (this.comm.getByte() + 1) + this.comm.getByte());
        } else {
            this.comm.skip(5);
            s = this.comm.getByte();
            this.databaseProductName = this.comm.getString(s);
            this.comm.skip(1);
            byte by = this.comm.getByte();
            this.databaseMajorVersion = by;
            this.databaseProductVersion = "" + by + "." + this.comm.getByte();
            this.comm.skip(1);
        }
        if (this.databaseProductName.length() > 1 && -1 != this.databaseProductName.indexOf(0)) {
            s = (short)this.databaseProductName.indexOf(0);
            this.databaseProductName = this.databaseProductName.substring(0, s);
        }
        return new PacketResult(-83);
    }

    private PacketResult processProcId() throws IOException, TdsException {
        this.comm.skip(8);
        return new PacketResult(124);
    }

    private PacketRetStatResult processRetStat() throws IOException, TdsException {
        return new PacketRetStatResult(this.comm.getTdsInt());
    }

    private PacketResult processTds7Result() throws IOException, TdsException {
        int n = this.comm.getTdsShort();
        Columns columns = new Columns(n);
        int n2 = 1;
        while (n2 <= n) {
            int n3;
            byte[] byArray = new byte[4];
            int n4 = 0;
            while (n4 < 4) {
                byArray[n4] = this.comm.getByte();
                ++n4;
            }
            boolean bl = (byArray[2] & 1) > 0;
            boolean bl2 = (byArray[2] & 2) > 0;
            boolean bl3 = (byArray[2] & 0xC) > 0;
            boolean bl4 = (byArray[2] & 0x10) > 0;
            int n5 = this.comm.getByte() & 0xFF;
            if (n5 == 239) {
                n5 = -17;
            }
            int n6 = -1;
            if (Tds.isLargeType(n5)) {
                n6 = n5;
                if (n5 != -17) {
                    n5 -= 128;
                }
            }
            int n7 = -1;
            String string = "";
            if (Tds.isBlobType(n5)) {
                n3 = this.comm.getTdsInt();
                string = this.comm.getString(this.comm.getTdsShort());
            } else {
                n3 = this.isFixedSizeColumn((byte)n5) ? this.lookupBufferSize((byte)n5) : (Tds.isLargeType(n6) ? this.comm.getTdsShort() : (int)this.comm.getByte());
            }
            int n8 = -1;
            int n9 = -1;
            if (n5 == 106 || n5 == 108) {
                n8 = this.comm.getByte();
                n9 = this.comm.getByte();
            }
            byte by = this.comm.getByte();
            String string2 = this.comm.getString(by);
            this.populateColumn(columns.getColumn(n2), n5, string2, n7, n3, bl, bl4, bl3, bl2, string, n8, n9);
            ++n2;
        }
        return new PacketColumnNamesResult(columns);
    }

    private void populateColumn(Column column, int n, String string, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2, int n4, int n5) {
        if (string != null) {
            column.setName(string);
            column.setLabel(string);
        }
        column.setType(n);
        column.setBufferSize(n3);
        column.setNullable(bl ? 1 : 0);
        column.setAutoIncrement(bl2);
        column.setReadOnly(!bl3);
        column.setCaseSensitive(bl4);
        if (string2 != null) {
            int n6 = string2.lastIndexOf(46);
            column.setTableName(string2.substring(n6 + 1));
            n6 = n6 == -1 ? 0 : n6;
            string2 = string2.substring(0, n6);
            if (n6 > 0) {
                n6 = string2.lastIndexOf(46);
                column.setSchema(string2.substring(n6 + 1));
                n6 = n6 == -1 ? 0 : n6;
                string2 = string2.substring(0, n6);
            }
            if (n6 > 0) {
                column.setCatalog(string2);
            }
        }
        switch (n) {
            case 60: 
            case 110: 
            case 112: 
            case 122: {
                column.setScale(4);
                break;
            }
            case 61: {
                column.setScale(3);
                break;
            }
            case 111: {
                if (n3 == 8) {
                    column.setScale(3);
                    break;
                }
                column.setScale(0);
                break;
            }
            default: {
                column.setScale(n5 < 0 ? 0 : n5);
            }
        }
        switch (n) {
            case 34: 
            case 37: 
            case 45: {
                n4 = n3;
                n2 = 2 * n4;
                break;
            }
            case 35: 
            case 39: 
            case 47: {
                n2 = n4 = n3;
                break;
            }
            case -17: 
            case 99: 
            case 103: {
                n2 = n4 = n3 >> 1;
                break;
            }
            case 50: {
                n4 = 1;
                n2 = 1;
                break;
            }
            case 36: {
                n4 = 36;
                n2 = 36;
                break;
            }
            case 61: {
                n4 = 23;
                n2 = 23;
                break;
            }
            case 58: {
                n4 = 16;
                n2 = 3 + 16;
                break;
            }
            case 111: {
                if (n3 == 8) {
                    n4 = 23;
                    n2 = 23;
                    break;
                }
                n4 = 16;
                n2 = 3 + 16;
                break;
            }
            case 106: 
            case 108: {
                n2 = (n3 == n5 ? 3 : 2) + n4;
                break;
            }
            case 62: {
                n4 = 15;
                n2 = 9 + 15;
                break;
            }
            case 59: {
                n4 = 7;
                n2 = 7 + 7;
                break;
            }
            case 109: {
                if (n3 == 8) {
                    n4 = 15;
                    n2 = 9 + 15;
                    break;
                }
                n4 = 7;
                n2 = 7 + 7;
                break;
            }
            case 56: {
                n4 = 10;
                n2 = 1 + 10;
                break;
            }
            case 52: {
                n4 = 5;
                n2 = 1 + 5;
                break;
            }
            case 48: {
                n4 = 2;
                n2 = 1 + 2;
                break;
            }
            case 38: {
                if (n3 == 4) {
                    n4 = 10;
                    n2 = 1 + 10;
                    break;
                }
                if (n3 == 2) {
                    n4 = 5;
                    n2 = 1 + 5;
                    break;
                }
                n4 = 2;
                n2 = 1 + 2;
                break;
            }
            case 60: {
                n4 = 19;
                n2 = 2 + 19;
                break;
            }
            case 112: 
            case 122: {
                n4 = 10;
                n2 = 2 + 10;
                break;
            }
            case 110: {
                if (n3 == 8) {
                    n4 = 19;
                    n2 = 2 + 19;
                    break;
                }
                n4 = 10;
                n2 = 2 + 10;
            }
        }
        column.setDisplaySize(n2);
        column.setPrecision(n4);
    }

    private void waitForDataOrTimeout(SQLWarningChain sQLWarningChain, int n) throws IOException, TdsException {
        if (n == 0 || sQLWarningChain == null) {
            this.comm.peek();
        } else {
            TimeoutHandler timeoutHandler = new TimeoutHandler(this, sQLWarningChain, n);
            timeoutHandler.start();
            this.comm.peek();
            timeoutHandler.interrupt();
            timeoutHandler = null;
        }
    }

    public static String toNativeSql(String string, int n) throws SQLException {
        EscapeProcessor escapeProcessor = n == 2 ? new SybaseEscapeProcessor(string) : new MSSqlServerEscapeProcessor(string);
        return escapeProcessor.nativeString();
    }

    public static byte cvtJdbcTypeToNativeType(int n) throws TdsNotImplemented {
        byte by = 0;
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                by = 47;
                break;
            }
            case -6: {
                by = 48;
                break;
            }
            case 5: {
                by = 52;
                break;
            }
            case 4: {
                by = 56;
                break;
            }
            case -7: {
                by = 50;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                by = 62;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                by = 111;
                break;
            }
            case -2: {
                by = 45;
                break;
            }
            case -3: {
                by = 37;
                break;
            }
            case -4: {
                by = 34;
                break;
            }
            case -5: {
                by = 106;
                break;
            }
            case 2: {
                by = 108;
                break;
            }
            case 3: {
                by = 106;
                break;
            }
            default: {
                throw new TdsNotImplemented("cvtJdbcTypeToNativeType (" + TdsUtil.javaSqlTypeToString(n) + ")");
            }
        }
        return by;
    }

    public static int cvtNativeTypeToJdbcType(int n, int n2) throws TdsException {
        int n3 = 1111;
        block0 : switch (n) {
            case 45: {
                n3 = -2;
                break;
            }
            case 50: {
                n3 = -7;
                break;
            }
            case 104: {
                n3 = -7;
                break;
            }
            case 47: {
                n3 = 1;
                break;
            }
            case -17: {
                n3 = 1;
                break;
            }
            case 58: {
                n3 = 93;
                break;
            }
            case 61: {
                n3 = 93;
                break;
            }
            case 111: {
                n3 = 93;
                break;
            }
            case 106: {
                n3 = 3;
                break;
            }
            case 108: {
                n3 = 2;
                break;
            }
            case 62: {
                n3 = 6;
                break;
            }
            case 109: {
                switch (n2) {
                    case 4: {
                        n3 = 7;
                        break block0;
                    }
                    case 8: {
                        n3 = 6;
                        break block0;
                    }
                }
                throw new TdsException("Bad size of SYBFLTN");
            }
            case 48: {
                n3 = -6;
                break;
            }
            case 52: {
                n3 = 5;
                break;
            }
            case 56: {
                n3 = 4;
                break;
            }
            case 38: {
                switch (n2) {
                    case 1: {
                        n3 = -6;
                        break block0;
                    }
                    case 2: {
                        n3 = 5;
                        break block0;
                    }
                    case 4: {
                        n3 = 4;
                        break block0;
                    }
                }
                throw new TdsException("Bad size of SYBINTN");
            }
            case 122: {
                n3 = 3;
                break;
            }
            case 112: {
                n3 = 3;
                break;
            }
            case 60: {
                n3 = 3;
                break;
            }
            case 110: {
                n3 = 3;
                break;
            }
            case 59: {
                n3 = 7;
                break;
            }
            case 35: {
                n3 = -1;
                break;
            }
            case 99: {
                n3 = -1;
                break;
            }
            case 34: {
                n3 = -3;
                break;
            }
            case 37: {
                n3 = -3;
                break;
            }
            case 39: {
                n3 = 12;
                break;
            }
            case 103: {
                n3 = 12;
                break;
            }
            case 36: {
                n3 = 12;
                break;
            }
            default: {
                throw new TdsException("Unknown native data type " + Integer.toHexString(n & 0xFF));
            }
        }
        return n3;
    }

    private static boolean isBlobType(int n) {
        return n == 35 || n == 34 || n == 99;
    }

    private static boolean isLargeType(int n) {
        return n == -17 || n > 128;
    }

    private static int toUInt(byte by) {
        int n = by & 0xFF;
        return n;
    }

    private static String tds7CryptPass(String string) {
        int n = 23130;
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = string.charAt(n3) ^ n;
            int n5 = n4 >> 4 & 0xF0F;
            int n6 = n4 << 4 & 0xF0F0;
            cArray[n3] = (char)(n5 | n6);
            ++n3;
        }
        return new String(cArray);
    }

    void commit() throws SQLException {
        String string = "IF @@TRANCOUNT>0 COMMIT TRAN";
        this.submitProcedure(string, new SQLWarningChain());
        this.proceduresOfTra.clear();
    }

    void rollback() throws SQLException {
        SQLException sQLException = null;
        try {
            this.submitProcedure("IF @@TRANCOUNT>0 ROLLBACK TRAN", new SQLWarningChain());
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        Iterator iterator = ((AbstractList)this.proceduresOfTra).iterator();
        while (iterator.hasNext()) {
            Procedure procedure = (Procedure)iterator.next();
            this.procedureCache.remove(procedure.rawQueryString);
        }
        this.proceduresOfTra.clear();
        if (sQLException != null) {
            throw sQLException;
        }
    }

    void skipToEnd_do_not_call() throws SQLException, IOException, TdsUnknownPacketSubType, TdsException {
        if (this.moreResults) {
            PacketResult packetResult;
            boolean bl;
            while (!(bl = (packetResult = this.processSubPacket()) instanceof PacketEndTokenResult && !((PacketEndTokenResult)packetResult).moreResults())) {
            }
        }
    }

    private String sqlStatementToInitialize() {
        return this.serverType == 2 ? "set quoted_identifier on set textsize 50000" : "";
    }

    private String sqlStatementToSetTransactionIsolationLevel() throws SQLException {
        StringBuffer stringBuffer;
        block13: {
            block12: {
                stringBuffer = new StringBuffer(48);
                stringBuffer.append("set transaction isolation level ");
                if (this.serverType != 2) break block12;
                switch (this.transactionIsolationLevel) {
                    case 1: {
                        throw new SQLException("Bad transaction level");
                    }
                    case 2: {
                        stringBuffer.append('1');
                        break block13;
                    }
                    case 4: {
                        throw new SQLException("Bad transaction level");
                    }
                    case 8: {
                        stringBuffer.append('3');
                        break block13;
                    }
                    default: {
                        throw new SQLException("Bad transaction level");
                    }
                }
            }
            switch (this.transactionIsolationLevel) {
                case 1: {
                    stringBuffer.append(" read uncommitted");
                    break;
                }
                case 2: {
                    stringBuffer.append(" read committed");
                    break;
                }
                case 4: {
                    stringBuffer.append(" repeatable read");
                    break;
                }
                case 8: {
                    throw new SQLException("SQLServer does not support TRANSACTION_SERIALIZABLE");
                }
                default: {
                    throw new SQLException("Bad transaction level");
                }
            }
        }
        return stringBuffer.toString();
    }

    private String sqlStatementToSetCommit() {
        String string = this.serverType == 2 ? (this.autoCommit ? "set CHAINED off" : "set CHAINED on") : (this.autoCommit ? "set implicit_transactions off" : "set implicit_transactions on");
        return string;
    }

    protected String sqlStatementForSettings(boolean bl, int n) throws SQLException {
        if (bl == this.autoCommit && n == this.transactionIsolationLevel) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl != this.autoCommit) {
            this.autoCommit = bl;
            stringBuffer.append(this.sqlStatementToSetCommit()).append(' ');
        }
        if (n != this.transactionIsolationLevel) {
            this.transactionIsolationLevel = n;
            stringBuffer.append(this.sqlStatementToSetTransactionIsolationLevel()).append(' ');
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    protected void changeSettings(boolean bl, int n) throws SQLException {
        String string = this.sqlStatementForSettings(bl, n);
        if (string != null) {
            try {
                this.changeSettings(string);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw new SQLException(exception.toString());
            }
        }
    }

    private synchronized boolean changeSettings(String string) throws TdsUnknownPacketSubType, TdsException, IOException, SQLException {
        boolean bl = true;
        if (string.length() == 0) {
            return true;
        }
        try {
            this.comm.startPacket(1);
            if (this.tdsVer == 70) {
                this.comm.appendChars(string);
            } else {
                byte[] byArray = this.encoder.getBytes(string);
                this.comm.appendBytes(byArray, byArray.length, (byte)0);
            }
            this.moreResults2 = true;
            this.comm.sendPacket();
            Object var6_5 = null;
            this.comm.packetType = 0;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.comm.packetType = 0;
            throw throwable;
        }
        boolean bl2 = false;
        while (!bl2) {
            PacketResult packetResult = this.processSubPacket();
            boolean bl3 = bl2 = packetResult instanceof PacketEndTokenResult && !((PacketEndTokenResult)packetResult).moreResults();
            if (!(packetResult instanceof PacketErrorResult)) continue;
            bl = false;
        }
        return bl;
    }
}

