/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.test;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestBase
extends TestCase {
    Connection con;
    Properties props;

    public TestBase(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.connect();
    }

    public void tearDown() throws Exception {
        this.disconnect();
    }

    public Connection getConnection() throws Exception {
        Class.forName("net.sourceforge.jtds.jdbc.Driver");
        String string = "conf/connection.properties";
        this.props = this.loadProperties(string);
        String string2 = this.props.getProperty("url");
        Connection connection = DriverManager.getConnection(string2, this.props);
        this.showWarnings(connection.getWarnings());
        this.initLanguage(connection);
        return connection;
    }

    public void showWarnings(SQLWarning sQLWarning) {
        while (sQLWarning != null) {
            System.out.println(sQLWarning.getMessage());
            sQLWarning = sQLWarning.getNextWarning();
        }
    }

    private void disconnect() throws Exception {
        if (this.con != null) {
            this.con.close();
            this.con = null;
        }
    }

    protected void connect() throws Exception {
        this.disconnect();
        this.con = this.getConnection();
    }

    protected void connectODBC() throws Exception {
        this.disconnect();
        this.con = this.getConnectionODBC();
    }

    public void dump(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 1;
        while (n2 <= n) {
            if (n2 > 1) {
                System.out.print(", ");
            }
            System.out.print(resultSetMetaData.getColumnName(n2));
            ++n2;
        }
        System.out.println();
        while (resultSet.next()) {
            this.dumpRow(resultSet);
        }
    }

    public void dumpRow(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 1;
        while (n2 <= n) {
            if (n2 > 1) {
                System.out.print(", ");
            }
            System.out.print(resultSet.getObject(n2));
            ++n2;
        }
        System.out.println();
    }

    public Connection getConnectionODBC() throws Exception {
        Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        String string = "conf/odbc-connection.properties";
        Properties properties = this.loadProperties(string);
        String string2 = properties.getProperty("url");
        Connection connection = DriverManager.getConnection(string2, properties);
        this.showWarnings(connection.getWarnings());
        this.initLanguage(connection);
        return connection;
    }

    private void initLanguage(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("set LANGUAGE 'us_english'");
        statement.close();
    }

    private Properties loadProperties(String string) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            Assert.fail((String)("Connection properties not found (" + file + ")."));
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        return properties;
    }

    protected void makeTestTables(Statement statement) throws SQLException {
        String string = "CREATE TABLE #test ( f_int INT, f_varchar VARCHAR(255) )";
        statement.execute(string);
    }

    public void makeObjects(Statement statement, int n) throws SQLException {
        statement.execute("TRUNCATE TABLE #test");
        int n2 = 0;
        while (n2 < n) {
            String string = "INSERT INTO #test(f_int, f_varchar) VALUES (" + n2 + ", 'Row " + n2 + "')";
            statement.execute(string);
            ++n2;
        }
    }
}

