/*
 * Decompiled with CFR 0.152.
 */
package com.securitycentric.metacoretex;

import com.securitycentric.metacoretex.Attacker;
import com.securitycentric.metacoretex.gui.MainWindow;
import com.securitycentric.metacoretex.gui.SplashFrame;
import com.securitycentric.metacoretex.interfaces.Probe;
import com.securitycentric.metacoretex.lib.ProbeToolz;
import com.securitycentric.metacoretex.lib.TLock;
import com.securitycentric.metacoretex.lib.Target;
import com.securitycentric.metacoretex.xml.conf.Config;
import com.securitycentric.metacoretex.xml.conf.MCTXConfig;
import com.securitycentric.metacoretex.xml.conf.MCTXOption;
import com.securitycentric.metacoretex.xml.conf.MCTXProbeConfig;
import com.securitycentric.metacoretex.xml.conf.MCTXTarget;
import com.securitycentric.metacoretex.xml.conf.ObjectFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class Init {
    public static String version = new String("$Id: Init.java,v 1.41 2003/10/02 02:20:44 visigoth_6 Exp $");
    public static Probe selectedProbe;
    public static int probeTimeout;
    public static boolean safeChecks;
    public static boolean console;
    public static String userDir;
    public static Vector allProbeVect;
    public static Vector reportVect;
    public static Vector depVect;
    public static Hashtable probeVectHash;
    public static ThreadGroup threadGroup;
    public static Vector targVect;
    public static Properties config;
    public static MainWindow mainWindow;
    public static SplashFrame splash;
    public static Dimension screenSize;
    public static Vector attackVect;
    public static JAXBContext confctx;

    public static void main(String[] args) {
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        splash = new SplashFrame();
        Init.centerWindow(splash);
        splash.show();
        splash.setValue(10);
        Init.genComponents();
        splash.setValue(30);
        userDir = System.getProperty("user.dir");
        Init.loadGlobals();
        targVect.add(new Target("localhost"));
        splash.setValue(40);
        splash.setValue(60);
        try {
            ProbeToolz.loadProbesFromDir(new File(config.getProperty("probe.dir")), depVect);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        splash.setValue(70);
        Init.processDepVect();
        splash.setValue(80);
        Iterator i = allProbeVect.iterator();
        while (i.hasNext()) {
            Probe tmpo = (Probe)i.next();
            System.out.println("Probe: " + tmpo.getName());
        }
        splash.setValue(100);
        splash.setText("By visigoth <visigoth@securitycentric.com>");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        splash.setVisible(false);
        splash.dispose();
        mainWindow = new MainWindow();
        console = false;
        mainWindow.setSize(700, 500);
        Init.centerWindow(mainWindow);
        mainWindow.show();
        if (System.getProperty("os.name").startsWith("Window")) {
            Init.doMessage("Warning", "Windows support is sketchy at best.\nBe sure to review README.windows!");
        }
    }

    private static void saveProperties() {
        try {
            File propFile = new File(userDir + "/conf/mctx.properties");
            String saveMess = "Would you like to save your global \nconfig options?";
            if (!propFile.exists() && Init.askYesNo("Save", saveMess) == 0) {
                config.store(new FileOutputStream(propFile), "Saved Globals-Delete this file to get back to defaults");
                Init.doMessage("Config Saved", "Global configuration options are being saved to:\n" + userDir + "/conf/mctx.properties");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void genComponents() {
        allProbeVect = new Vector();
        targVect = new Vector();
        attackVect = new Vector();
        reportVect = new Vector();
        depVect = new Vector();
        config = new Properties();
        try {
            confctx = JAXBContext.newInstance((String)"com.securitycentric.metacoretex.xml.conf");
        }
        catch (JAXBException je) {
            splash.setText("JAXB Exception!!");
        }
    }

    public static void fire() {
        Init.clearProbeReports();
        Init.genAttackers();
        try {
            probeTimeout = Integer.parseInt(config.getProperty("probe.timeout"));
        }
        catch (NumberFormatException ne) {
            Init.doError("User Specified bad number in global config", ne);
            return;
        }
        safeChecks = Boolean.getBoolean(config.getProperty("safe.checks.only"));
        Iterator i = attackVect.iterator();
        while (i.hasNext()) {
            ((Attacker)i.next()).start();
        }
    }

    public static void stopAttacker(int x) {
        ((Thread)attackVect.get(x)).interrupt();
    }

    public static void clearProbeReports() {
        Iterator it = reportVect.iterator();
        while (it.hasNext()) {
            Target tar = (Target)it.next();
            tar.clearProbeReports();
            tar.clearProbeExceptions();
            tar.clearKb();
        }
        reportVect.clear();
    }

    public static void scanDone() {
        TLock.unlockAll();
        Init.mainWindow.repFrame.moveToFront();
        mainWindow.toFront(Init.mainWindow.repFrame);
    }

    private static void genAttackers() {
        int threadMax;
        try {
            threadMax = Integer.parseInt(config.getProperty("threads.max"));
        }
        catch (NumberFormatException ne) {
            JOptionPane.showMessageDialog(null, "User Specified bad threads.max : " + config.getProperty("threads.max"), "Error", 0);
            threadMax = 0;
        }
        int targCount = targVect.size();
        attackVect.clear();
        threadGroup = new ThreadGroup("Attacker Group");
        int threads = targCount < threadMax ? targCount : threadMax;
        for (int i = 0; i < threads; ++i) {
            attackVect.add(new Attacker(threadGroup));
        }
    }

    public static boolean processDepVect() {
        int vectSize;
        int newSize;
        block0: do {
            vectSize = depVect.size();
            Iterator i = depVect.iterator();
            while (i.hasNext()) {
                int index;
                Probe tmpPrb = (Probe)i.next();
                int id = tmpPrb.getProbeId();
                if (ProbeToolz.isLoaded(allProbeVect, id)) {
                    ProbeToolz.removeProbe(id);
                }
                if ((index = ProbeToolz.getIndex(allProbeVect, tmpPrb)) == -1) continue;
                if (splash != null) {
                    splash.setText(tmpPrb.getName());
                }
                Init.loadProbe(tmpPrb, index);
                depVect.remove(tmpPrb);
                continue block0;
            }
        } while ((newSize = depVect.size()) < vectSize);
        System.out.println("Had " + newSize + " remaining probes");
        depVect.clear();
        return newSize == 0;
    }

    public static void loadProbe(Probe pr, int index) {
        allProbeVect.add(index, pr);
        if (!probeVectHash.containsKey(pr.getFamily())) {
            probeVectHash.put(pr.getFamily(), new Vector());
        }
        ((Vector)probeVectHash.get(pr.getFamily())).add(pr);
    }

    public static void fireStatusChanged() {
        mainWindow.updateScanStatus();
    }

    public static void centerWindow(Component frame) {
        Dimension frameSize = frame.getSize();
        if (frameSize.height > Init.screenSize.height) {
            frameSize.height = Init.screenSize.height;
        }
        if (frameSize.width > Init.screenSize.width) {
            frameSize.width = Init.screenSize.width;
        }
        frame.setLocation((Init.screenSize.width - frameSize.width) / 2, (Init.screenSize.height - frameSize.height) / 2);
    }

    public static void ShutDown() {
        Init.saveProperties();
        System.exit(0);
    }

    public static void LoadConfig(File xmlConf) {
        try {
            Unmarshaller um = confctx.createUnmarshaller();
            MCTXConfig cfg = (MCTXConfig)um.unmarshal(xmlConf);
            Iterator gloIter = cfg.getGlobalOption().iterator();
            while (gloIter.hasNext()) {
                MCTXOption opt = (MCTXOption)gloIter.next();
                config.setProperty(opt.getName(), opt.getValue());
            }
            targVect.clear();
            Iterator tarIter = cfg.getTarget().iterator();
            while (tarIter.hasNext()) {
                MCTXTarget mctxtar = (MCTXTarget)tarIter.next();
                Target tmpTarg = new Target(mctxtar.getHost());
                targVect.add(tmpTarg);
            }
            Iterator prcfgIter = cfg.getProbeConfig().iterator();
            while (prcfgIter.hasNext()) {
                MCTXProbeConfig pcfg = (MCTXProbeConfig)prcfgIter.next();
                Probe prb = ProbeToolz.getProbeById(pcfg.getProbeId());
                if (prb == null) {
                    System.out.println("Config option for non-existant probe!");
                    continue;
                }
                Iterator proptIter = pcfg.getProbeOption().iterator();
                while (proptIter.hasNext()) {
                    MCTXOption propt = (MCTXOption)proptIter.next();
                    prb.addOption(propt.getName(), propt.getValue());
                }
                prb.setEnabled(pcfg.isProbeEnabled());
            }
        }
        catch (JAXBException je) {
            Init.doError("Unmarshaller Error", (Exception)((Object)je));
        }
    }

    public static void SaveConfig(File xmlConf) {
        try {
            xmlConf.createNewFile();
            Marshaller m = confctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            ObjectFactory fac = new ObjectFactory();
            Config cfg = fac.createConfig();
            Iterator<Object> gloIt = config.keySet().iterator();
            while (gloIt.hasNext()) {
                String key = (String)gloIt.next();
                MCTXOption opt = fac.createMCTXOption();
                opt.setName(key);
                opt.setValue(config.getProperty(key));
                cfg.getGlobalOption().add(opt);
            }
            Iterator probIt = allProbeVect.iterator();
            while (probIt.hasNext()) {
                Probe probe = (Probe)probIt.next();
                Vector propts = probe.getOptionKeys();
                MCTXProbeConfig prbcfg = fac.createMCTXProbeConfig();
                prbcfg.setProbeId(probe.getProbeId());
                prbcfg.setProbeVersion(probe.getVersion());
                Iterator proptIt = propts.iterator();
                while (proptIt.hasNext()) {
                    String key = (String)proptIt.next();
                    MCTXOption opt = fac.createMCTXOption();
                    opt.setName(key);
                    opt.setValue(probe.getOption(key));
                    prbcfg.getProbeOption().add(opt);
                }
                prbcfg.setProbeEnabled(probe.isEnabled());
                cfg.getProbeConfig().add(prbcfg);
            }
            Iterator targIt = targVect.iterator();
            while (targIt.hasNext()) {
                MCTXTarget mctxtarg = fac.createMCTXTarget();
                Target targ = (Target)targIt.next();
                mctxtarg.setHost(targ.getHost());
                cfg.getTarget().add(mctxtarg);
            }
            FileOutputStream os = new FileOutputStream(xmlConf);
            m.marshal((Object)cfg, (OutputStream)os);
        }
        catch (JAXBException je) {
            je.printStackTrace();
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public static void loadTargetFile(File file) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                targVect.add(new Target(line.trim()));
            }
        }
        catch (IOException ie) {
            JOptionPane.showMessageDialog(null, ie.getMessage(), "I/O Exception", 0);
        }
    }

    public static void doError(String mess, Exception e) {
        if (console) {
            System.out.println(mess + "\n" + e.getMessage());
            e.printStackTrace();
        } else {
            JOptionPane.showMessageDialog(mainWindow, mess + " : " + e.getMessage(), "Error!", 0);
            e.printStackTrace();
        }
    }

    public static void doMessage(String title, String mess) {
        if (console) {
            System.out.println(mess);
        } else {
            JOptionPane.showMessageDialog(mainWindow, mess, title, 1);
        }
    }

    public static int askYesNo(String title, String mess) {
        if (console) {
            return 1;
        }
        return JOptionPane.showConfirmDialog(null, mess, title, 0);
    }

    private static void loadGlobals() {
        System.setProperty("javax.net.ssl.trustStore", userDir + "/.truststore");
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
        config.setProperty("threads.max", "5");
        config.setProperty("safe.checks.only", "true");
        config.setProperty("probe.timeout", "60");
        config.setProperty("update.url", "https://xml.metacoretex.com:8443/MetaWeb/Update");
        config.setProperty("probe.compiler.classpath", userDir + "/dist/MetaCoreTex.jar");
        config.setProperty("probe.dir", userDir + "/probes/");
        config.setProperty("conf.dir", userDir + "/conf/");
        config.setProperty("jar.dir", userDir + "/dist/");
        config.setProperty("template.dir", userDir + "/docs/templates/");
        try {
            File propFile = new File(userDir + "/conf/mctx.properties");
            if (propFile.exists()) {
                config.load(new FileInputStream(propFile));
            }
        }
        catch (IOException e) {
            Init.doError("Error Loading Global Defaults", e);
        }
    }

    static {
        console = true;
        probeVectHash = new Hashtable();
    }
}

