/*
 * Decompiled with CFR 0.152.
 */
package com.securitycentric.metacoretex.gui.wizards;

import com.securitycentric.metacoretex.Init;
import com.securitycentric.metacoretex.adapters.UpdateTableModel;
import com.securitycentric.metacoretex.lib.UpdateException;
import com.securitycentric.metacoretex.lib.UpdateToolz;
import com.securitycentric.metacoretex.xml.update.MCTXUpdate;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;

public class UpdateWizard
extends JFrame
implements Runnable {
    private JButton cancelButton;
    private JPanel centPanel;
    private JScrollPane confPane;
    private JTable confTable;
    private JScrollPane probPane;
    private JTable probeTable;
    private JPanel southPanel;
    private JSplitPane splitPane;
    private JButton updateButton;
    TreeMap newTree;
    TreeMap upTree;
    MCTXUpdate upDate;
    UpdateTableModel probeTabMod;
    UpdateTableModel confTabMod;

    public UpdateWizard() {
        this.initComponents();
        Init.centerWindow(this);
    }

    private void initComponents() {
        this.centPanel = new JPanel();
        this.splitPane = new JSplitPane();
        this.probPane = new JScrollPane();
        this.probeTable = new JTable();
        this.confPane = new JScrollPane();
        this.confTable = new JTable();
        this.southPanel = new JPanel();
        this.cancelButton = new JButton();
        this.updateButton = new JButton();
        this.setTitle("MetaCoretex Update Interactive");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                UpdateWizard.this.exitForm(evt);
            }
        });
        this.centPanel.setLayout(new BoxLayout(this.centPanel, 1));
        this.splitPane.setDividerLocation(150);
        this.splitPane.setOrientation(0);
        this.probeTable.setPreferredScrollableViewportSize(new Dimension(400, 150));
        this.probPane.setViewportView(this.probeTable);
        this.splitPane.setLeftComponent(this.probPane);
        this.confTable.setPreferredScrollableViewportSize(new Dimension(400, 150));
        this.confPane.setViewportView(this.confTable);
        this.splitPane.setRightComponent(this.confPane);
        this.centPanel.add(this.splitPane);
        this.getContentPane().add((Component)this.centPanel, "Center");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdateWizard.this.cancelButtonActionPerformed(evt);
            }
        });
        this.southPanel.add(this.cancelButton);
        this.updateButton.setText("Update");
        this.updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdateWizard.this.updateButtonActionPerformed(evt);
            }
        });
        this.southPanel.add(this.updateButton);
        this.getContentPane().add((Component)this.southPanel, "South");
        this.pack();
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        try {
            UpdateToolz.doUpdate(this.upDate);
        }
        catch (UpdateException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Update Failed!", 0);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void run() {
        try {
            this.upDate = UpdateToolz.getUpdate();
            UpdateToolz.removeDuplicates(this.upDate);
            this.probeTable.setModel(new UpdateTableModel(this.upDate, 1));
            this.confTable.setModel(new UpdateTableModel(this.upDate, 2));
            this.pack();
            this.show();
        }
        catch (UpdateException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Update Error!", 0);
            this.setVisible(false);
            this.dispose();
        }
    }
}

