/*
 * Decompiled with CFR 0.152.
 */
package com.securitycentric.metacoretex.gui.wizards;

import com.securitycentric.metacoretex.Init;
import com.securitycentric.metacoretex.gui.UpdateStatus;
import com.securitycentric.metacoretex.gui.wizards.UpdatePanel;
import com.securitycentric.metacoretex.lib.UpdateException;
import com.securitycentric.metacoretex.lib.UpdateToolz;
import com.securitycentric.metacoretex.xml.update.MCTXUpdate;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class UpdateWizard1
extends JFrame
implements Runnable {
    private JButton backButton;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton helpButton;
    private JLayeredPane layeredPane;
    private JButton nextButton;
    private JButton updateButton;
    public Vector panVect;
    MCTXUpdate upDate = null;
    private String help = "Use this wizard to select the updates you would like to install";
    int pageIndex;

    public UpdateWizard1() {
        this.preInit();
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.helpButton = new JButton();
        this.cancelButton = new JButton();
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.updateButton = new JButton();
        this.layeredPane = new JLayeredPane();
        this.setTitle("Update Wizard");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                UpdateWizard1.this.exitForm(evt);
            }
        });
        this.helpButton.setText("Help");
        this.helpButton.setMaximumSize(new Dimension(75, 25));
        this.helpButton.setPreferredSize(new Dimension(75, 25));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdateWizard1.this.helpButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.helpButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdateWizard1.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.backButton.setText("Back");
        this.backButton.setPreferredSize(new Dimension(75, 25));
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdateWizard1.this.backButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.backButton);
        this.nextButton.setText("Next");
        this.nextButton.setIconTextGap(0);
        this.nextButton.setPreferredSize(new Dimension(75, 25));
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdateWizard1.this.nextButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.nextButton);
        this.updateButton.setText("Update");
        this.updateButton.setPreferredSize(new Dimension(80, 25));
        this.updateButton.setEnabled(false);
        this.updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdateWizard1.this.updateButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.updateButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.layeredPane, "Center");
        this.pack();
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, this.help, "Help", 1);
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        int fileCount = 0;
        try {
            fileCount = UpdateToolz.doUpdate(this.upDate);
        }
        catch (UpdateException e) {
            Init.doError("Updater Error", e);
            return;
        }
        Init.doMessage("Update Complete", "Update Complete. " + fileCount + " files updated");
        this.setVisible(false);
        this.dispose();
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        --this.pageIndex;
        this.layeredPane.moveToFront((Component)this.panVect.get(this.pageIndex));
        if (this.pageIndex == 0) {
            this.backButton.setEnabled(false);
        }
        this.nextButton.setEnabled(true);
        this.updateButton.setEnabled(false);
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        ++this.pageIndex;
        this.layeredPane.moveToFront((Component)this.panVect.get(this.pageIndex));
        if (this.pageIndex + 1 >= this.panVect.size()) {
            this.nextButton.setEnabled(false);
            this.updateButton.setEnabled(true);
        }
        this.backButton.setEnabled(true);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void preInit() {
        this.panVect = new Vector();
    }

    public void postInit() {
        this.layeredPane.setPreferredSize(new Dimension(500, 400));
        this.pack();
        Init.centerWindow(this);
    }

    public void addPanel(JPanel pan) {
        this.panVect.add(pan);
        this.layeredPane.add((Component)pan, new Integer(10));
        this.layeredPane.validate();
    }

    public void run() {
        UpdateStatus upStat = new UpdateStatus();
        Init.centerWindow(upStat);
        upStat.show();
        upStat.update("Getting Update XML Report", 30);
        try {
            this.upDate = UpdateToolz.getUpdate();
        }
        catch (UpdateException e) {
            Init.doError("Update Error while getting update XML", e);
            return;
        }
        upStat.update("Removing Current Entries", 50);
        UpdateToolz.removeDuplicates(this.upDate);
        upStat.update("Building Interactive Interface", 70);
        this.addPanel(new UpdatePanel(this.upDate, 1, "Select From Available Probe Updates"));
        this.addPanel(new UpdatePanel(this.upDate, 2, "Select From Available Config Updates"));
        this.addPanel(new UpdatePanel(this.upDate, 3, "Select From Available JAR Updates"));
        upStat.update("Complete", 100);
        upStat.setVisible(false);
        upStat.dispose();
        this.show();
    }
}

