/*
 * Decompiled with CFR 0.152.
 */
package com.securitycentric.metacoretex.lib;

import com.securitycentric.metacoretex.lib.VersionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    private String verString;
    private int[] verNums;
    private Pattern pat = Pattern.compile("[\\d\\._]{3,}");
    private Matcher m;

    public Version(String verStr) throws VersionException {
        this.m = this.pat.matcher(verStr);
        if (this.m.find()) {
            this.verString = this.m.group();
            String[] strAry = this.verString.split("[\\._]+");
            this.verNums = new int[strAry.length];
            for (int i = 0; i < strAry.length; ++i) {
                try {
                    this.verNums[i] = Integer.parseInt(strAry[i]);
                    continue;
                }
                catch (NumberFormatException ne) {
                    throw new VersionException("Column " + i + " seems malformed: " + strAry[i]);
                }
            }
        } else {
            throw new VersionException("Couldn't find version numbers in string");
        }
    }

    public boolean isNewerThan(Version ver) {
        for (int i = 0; i < ver.verCount(); ++i) {
            int them;
            int us = this.verInt(i);
            if (us > (them = ver.verInt(i))) {
                return true;
            }
            if (them <= us) continue;
            return false;
        }
        return false;
    }

    public boolean isOlderThan(Version ver) {
        for (int i = 0; i < ver.verCount(); ++i) {
            int us = this.verInt(i);
            int them = ver.verInt(i);
            if (them > us) {
                return true;
            }
            if (us <= them) continue;
            return false;
        }
        return false;
    }

    public int verInt(int index) {
        if (index >= this.verNums.length) {
            return 0;
        }
        return this.verNums[index];
    }

    public int verCount() {
        return this.verNums.length;
    }

    public String toString() {
        return this.verString;
    }
}

