/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JArray;
import com.sun.codemodel.JArrayCompRef;
import com.sun.codemodel.JAssignment;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JAtom;
import com.sun.codemodel.JCast;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;

public abstract class JExpr {
    private static JExpression __this = new JAtom("this");
    private static JExpression __super = new JAtom("super");
    private static JExpression __null = new JAtom("null");
    private static String charEscape = "\bb\tt\nn\ff\rr\"\"''\\\\";

    private JExpr() {
    }

    public static JExpression assign(JAssignmentTarget lhs, JExpression rhs) {
        return new JAssignment(lhs, rhs);
    }

    public static JExpression assignPlus(JAssignmentTarget lhs, JExpression rhs) {
        return new JAssignment(lhs, rhs, "+");
    }

    public static JInvocation _new(JClass c) {
        return new JInvocation(c);
    }

    public static JInvocation _new(JType t) {
        return new JInvocation(t);
    }

    public static JInvocation invoke(String method) {
        return new JInvocation(null, method);
    }

    public static JInvocation invoke(JExpression lhs, JMethod method) {
        return new JInvocation(lhs, method.name());
    }

    public static JInvocation invoke(JExpression lhs, String method) {
        return new JInvocation(lhs, method);
    }

    public static JFieldRef ref(String field) {
        return new JFieldRef(null, field);
    }

    public static JFieldRef ref(JExpression lhs, JVar field) {
        return new JFieldRef(lhs, field.name());
    }

    public static JFieldRef ref(JExpression lhs, String field) {
        return new JFieldRef(lhs, field);
    }

    public static JFieldRef refthis(String field) {
        return new JFieldRef(null, field, true);
    }

    public static JExpression dotclass(final JClass cl) {
        return new JExpressionImpl(){

            public void generate(JFormatter f) {
                f.p('(').g(cl).p(".class)");
            }
        };
    }

    public static JExpression dotclass(final JType t) {
        return new JExpressionImpl(){

            public void generate(JFormatter f) {
                f.p('(').g(t).p(".class)");
            }
        };
    }

    public static JArrayCompRef component(JExpression lhs, JExpression index) {
        return new JArrayCompRef(lhs, index);
    }

    public static JCast cast(JType type, JExpression expr) {
        return new JCast(type, expr);
    }

    public static JArray newArray(JType type) {
        return new JArray(type, null);
    }

    public static JArray newArray(JType type, JExpression size) {
        return new JArray(type, size);
    }

    public static JExpression _this() {
        return __this;
    }

    public static JExpression _super() {
        return __super;
    }

    public static JExpression _null() {
        return __null;
    }

    public static JExpression lit(boolean b) {
        return new JAtom(b ? "true" : "false");
    }

    public static JExpression lit(int n) {
        return new JAtom(Integer.toString(n));
    }

    public static JExpression lit(long n) {
        return new JAtom(Long.toString(n) + "L");
    }

    public static JExpression lit(float f) {
        return new JAtom(Float.toString(f) + "F");
    }

    public static JExpression lit(double d) {
        return new JAtom(Double.toString(d) + "D");
    }

    private static String quotify(char quote, String s) {
        int n = s.length();
        StringBuffer sb = new StringBuffer(n + 2);
        sb.append(quote);
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            int j = 0;
            while (j < 8) {
                if (c == charEscape.charAt(j * 2)) {
                    sb.append('\\');
                    sb.append(charEscape.charAt(j * 2 + 1));
                    break;
                }
                ++j;
            }
            if (j == 8) {
                if (c < ' ' || '~' < c) {
                    sb.append("\\u");
                    String hex = Integer.toHexString(c & 0xFFFF);
                    int k = hex.length();
                    while (k < 4) {
                        sb.append('0');
                        ++k;
                    }
                    sb.append(hex);
                } else {
                    sb.append(c);
                }
            }
            ++i;
        }
        sb.append(quote);
        return sb.toString();
    }

    public static JExpression lit(char c) {
        return new JAtom(JExpr.quotify('\'', "" + c));
    }

    public static JExpression lit(String s) {
        return new JAtom(JExpr.quotify('\"', s));
    }

    public static JExpression direct(final String source) {
        return new JExpressionImpl(){

            public void generate(JFormatter f) {
                f.p('(').p(source).p(')');
            }
        };
    }
}

