/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.writer.FileWithPrologCodeWriter;
import com.sun.codemodel.writer.ProgressCodeWriter;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.reader.Controller;
import com.sun.msv.reader.trex.ng.RELAXNGReader;
import com.sun.msv.verifier.jaxp.SAXParserFactoryImpl;
import com.sun.tools.xjc.ConsoleErrorReporter;
import com.sun.tools.xjc.Messages;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.generator.GeneratorContext;
import com.sun.tools.xjc.generator.SkeletonGenerator;
import com.sun.tools.xjc.generator.marshaller.MarshallerGenerator;
import com.sun.tools.xjc.generator.unmarshaller.Automaton;
import com.sun.tools.xjc.generator.unmarshaller.UnmarshallerGenerator;
import com.sun.tools.xjc.generator.unmarshaller.util.AutomatonToGraphViz;
import com.sun.tools.xjc.generator.validator.ValidatorGenerator;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.util.AnnotationRemover;
import com.sun.tools.xjc.reader.Util;
import com.sun.tools.xjc.reader.dtd.TDTDReader;
import com.sun.tools.xjc.reader.relaxng.TRELAXNGReader;
import com.sun.tools.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.xjc.reader.xmlschema.CustomizationContextChecker;
import com.sun.tools.xjc.reader.xmlschema.ExtensionBindingChecker;
import com.sun.tools.xjc.reader.xmlschema.IncorrectNamespaceURIChecker;
import com.sun.tools.xjc.reader.xmlschema.ProhibitedFeaturesFilter;
import com.sun.tools.xjc.reader.xmlschema.SchemaConstraintChecker;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.AnnotationParserFactoryImpl;
import com.sun.tools.xjc.reader.xmlschema.transformer.DOMForest;
import com.sun.tools.xjc.reader.xmlschema.transformer.DOMForestParser;
import com.sun.tools.xjc.reader.xmlschema.transformer.Internalizer;
import com.sun.tools.xjc.util.ErrorHandlerFilter;
import com.sun.tools.xjc.writer.SignatureWriter;
import com.sun.tools.xjc.writer.Writer;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.impl.parser.JAXPParser;
import com.sun.xml.xsom.impl.parser.XMLParser;
import com.sun.xml.xsom.impl.parser.XSOMParser;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.XMLFilterImpl;

public class Driver {
    private static final int MODE_BGM = 0;
    private static final int MODE_SIGNATURE = 1;
    private static final int MODE_SERIALIZE = 2;
    private static final int MODE_CODE = 3;
    private static final int MODE_AUTOMATA = 4;
    private static final int MODE_FOREST = 5;
    public static final int SCHEMA_DTD = 0;
    public static final int SCHEMA_XMLSCHEMA = 1;
    public static final int SCHEMA_RELAXNG = 2;
    public static final int SCHEMA_AUTODETECT = -1;

    public static void main(final String[] args) throws Exception {
        final Throwable[] ex = new Throwable[1];
        Thread th = new Thread(){

            public void run() {
                try {
                    Driver._main(args);
                }
                catch (Throwable e) {
                    ex[0] = e;
                }
            }
        };
        th.start();
        th.join();
        if (ex[0] != null) {
            if (ex[0] instanceof Exception) {
                throw (Exception)ex[0];
            }
            throw (Error)ex[0];
        }
    }

    private static void _main(String[] args) throws Exception {
        try {
            System.exit(Driver.run(args, System.err, System.out));
        }
        catch (BadCommandLineException e) {
            System.out.println(e.getMessage());
            System.out.println();
            Driver.usage(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int run(String[] args, PrintStream status, PrintStream out) throws Exception {
        Vector<InputSource> grammars = new Vector<InputSource>();
        Vector<InputSource> bindFiles = new Vector<InputSource>();
        Vector<URL> classpaths = new Vector<URL>();
        boolean noNS = false;
        File targetDir = new File(".");
        Options opt = new Options();
        String defaultPackage = "";
        int mode = 3;
        int schemaLanguage = -1;
        String proxyHost = null;
        String oldProxyHost = null;
        String proxyPort = null;
        String oldProxyPort = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equals("-help")) {
                    Driver.usage(false);
                }
                if (args[i].equals("-private")) {
                    Driver.usage(true);
                }
                if (args[i].equals("-noNS")) {
                    noNS = true;
                } else if (args[i].equals("-classpath") || args[i].equals("-cp")) {
                    if (i == args.length - 1) {
                        throw new BadCommandLineException(Messages.format("Driver.MissingClassPath"));
                    }
                    classpaths.add(new File(args[++i]).toURL());
                } else if (args[i].equals("-d")) {
                    if (i == args.length - 1) {
                        throw new BadCommandLineException(Messages.format("Driver.MissingDir"));
                    }
                    targetDir = new File(args[++i]);
                } else if (args[i].equals("-readOnly")) {
                    opt.readOnly = true;
                } else if (args[i].equals("-p")) {
                    if (i == args.length - 1) {
                        throw new BadCommandLineException(Messages.format("Driver.MissingPackageName"));
                    }
                    defaultPackage = args[++i];
                } else if (args[i].equals("-debug")) {
                    opt.debugMode = true;
                } else if (args[i].equals("-trace-unmarshaller")) {
                    opt.traceUnmarshaller = true;
                } else if (args[i].equals("-nv")) {
                    opt.strictCheck = false;
                } else if (args[i].equals("-verbose")) {
                    opt.verbose = true;
                } else if (args[i].equals("-b")) {
                    if (i == args.length - 1) {
                        throw new BadCommandLineException(Messages.format("Driver.MissingFileName"));
                    }
                    if (args[i + 1].startsWith("-")) {
                        throw new BadCommandLineException(Messages.format("Driver.MissingFileName"));
                    }
                    bindFiles.add(Util.getInputSource(args[++i]));
                } else if (args[i].equals("-dtd")) {
                    schemaLanguage = 0;
                } else if (args[i].equals("-relaxng")) {
                    schemaLanguage = 2;
                } else if (args[i].equals("-xmlschema")) {
                    schemaLanguage = 1;
                } else if (args[i].equals("-mode")) {
                    if (++i == args.length) {
                        throw new BadCommandLineException(Messages.format("Driver.MissingModeOperand"));
                    }
                    if (args[i].equals("bgm")) {
                        mode = 0;
                    } else if (args[i].equals("serial")) {
                        mode = 2;
                    } else if (args[i].equals("code")) {
                        mode = 3;
                    } else if (args[i].equals("sig")) {
                        mode = 1;
                    } else if (args[i].equals("automata")) {
                        mode = 4;
                    } else {
                        if (!args[i].equals("forest")) throw new BadCommandLineException(Messages.format("Driver.UnrecognizedMode", args[i]));
                        mode = 5;
                    }
                } else if (args[i].equals("-extension")) {
                    opt.compatibilityMode = 2;
                } else if (args[i].equals("-host")) {
                    if (i == args.length - 1) {
                        throw new BadCommandLineException(Messages.format("Driver.MissingProxyHost"));
                    }
                    if (args[i + 1].startsWith("-")) {
                        throw new BadCommandLineException(Messages.format("Driver.MissingProxyHost"));
                    }
                    proxyHost = args[++i];
                } else {
                    if (!args[i].equals("-port")) throw new BadCommandLineException(Messages.format("Driver.UnrecognizedParameter", args[i]));
                    if (i == args.length - 1) {
                        throw new BadCommandLineException(Messages.format("Driver.MissingProxyPort"));
                    }
                    if (args[i + 1].startsWith("-")) {
                        throw new BadCommandLineException(Messages.format("Driver.MissingProxyPort"));
                    }
                    proxyPort = args[++i];
                }
            } else {
                grammars.add(Util.getInputSource(args[i]));
            }
            ++i;
        }
        if (proxyHost != null || proxyPort != null) {
            if (proxyHost != null && proxyPort != null) {
                oldProxyHost = System.setProperty("http.proxyHost", proxyHost);
                oldProxyPort = System.setProperty("http.proxyPort", proxyPort);
            } else {
                if (proxyHost != null) throw new BadCommandLineException(Messages.format("Driver.MissingProxyPort"));
                throw new BadCommandLineException(Messages.format("Driver.MissingProxyHost"));
            }
        }
        if (!classpaths.isEmpty()) {
            URLClassLoader userClsLoader = new URLClassLoader(classpaths.toArray(new URL[classpaths.size()]));
            Thread.currentThread().setContextClassLoader(userClsLoader);
        }
        if (grammars.size() == 0) {
            throw new BadCommandLineException(Messages.format("Driver.MissingGrammar"));
        }
        try {
            AnnotatedGrammar grammar;
            if (status != null) {
                status.println(Messages.format("Driver.ParsingSchema"));
            }
            Controller controller = new Controller(new ConsoleErrorReporter(out));
            if (mode == 5) {
                Driver.buildXMLSchemaDOMForest(grammars.toArray(new InputSource[0]), bindFiles.toArray(new InputSource[0]), controller).dump(System.out);
                return 0;
            }
            try {
                grammar = Driver.loadGrammar(schemaLanguage, grammars.toArray(new InputSource[0]), bindFiles.toArray(new InputSource[0]), controller, defaultPackage, opt);
                if (grammar == null) {
                    out.println(Messages.format("Driver.ParseFailed"));
                    return -1;
                }
            }
            catch (SAXException e) {
                if (e.getException() == null) throw e;
                e.getException().printStackTrace(out);
                throw e;
            }
            if (status != null) {
                status.println(Messages.format("Driver.CompilingSchema"));
            }
            switch (mode) {
                case 0: {
                    Writer.writeToConsole(noNS, false, grammar);
                    return 0;
                }
                case 1: {
                    SignatureWriter.write(grammar, new OutputStreamWriter(out));
                    return 0;
                }
                case 2: {
                    ObjectOutputStream stream = new ObjectOutputStream(out);
                    stream.writeObject(AnnotationRemover.remove(grammar));
                    stream.close();
                    return 0;
                }
                case 3: {
                    CodeWriter cw = Driver.createCodeWriter(targetDir, opt.readOnly);
                    if (status != null) {
                        cw = new ProgressCodeWriter(cw, status);
                    }
                    if (Driver.generateCode(grammar, opt, controller, cw)) return 0;
                    out.println(Messages.format("Driver.FailedToGenerateCode"));
                    return -1;
                }
                case 4: {
                    GeneratorContext context = SkeletonGenerator.generate(grammar, opt, controller);
                    Automaton[] automata = UnmarshallerGenerator.generate(grammar, context, opt);
                    int i2 = 0;
                    while (i2 < automata.length) {
                        AutomatonToGraphViz.convert(automata[i2], new File(targetDir, automata[i2].getOwner().getTypeAsDefined().name() + ".gif"));
                        ++i2;
                    }
                    return 0;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        catch (StackOverflowError e) {
            if (opt.debugMode) {
                throw e;
            }
            out.println(Messages.format("Driver.StackOverflow"));
            return -1;
        }
    }

    public static AnnotatedGrammar loadGrammar(int schemaLanguage, InputSource[] grammars, InputSource[] bindFiles, Controller controller, String defaultPackage, Options opt) throws SAXException, IOException {
        if (schemaLanguage == -1) {
            schemaLanguage = Driver.guessSchemaLanguage(grammars);
        }
        try {
            AnnotatedGrammar grammar;
            switch (schemaLanguage) {
                case 0: {
                    InputSource bindFile = null;
                    if (bindFiles.length > 0) {
                        bindFile = bindFiles[0];
                    }
                    if (bindFile == null) {
                        bindFile = new InputSource(new StringReader("<?xml version='1.0'?><xml-java-binding-schema><options package='" + defaultPackage + "'/></xml-java-binding-schema>"));
                    }
                    grammar = Driver.loadDTDGrammar(grammars[0], bindFile, controller);
                    break;
                }
                case 2: {
                    grammar = Driver.loadRELAXNGGrammar(grammars[0], controller, defaultPackage);
                    break;
                }
                case 1: {
                    if (opt.strictCheck && !SchemaConstraintChecker.check(grammars, controller)) {
                        return null;
                    }
                    grammar = Driver.loadXMLSchemaGrammar(grammars, bindFiles, controller, defaultPackage, opt);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            if (controller.hadError()) {
                grammar = null;
            }
            return grammar;
        }
        catch (SAXException e) {
            if (opt.debugMode) {
                if (e.getException() != null) {
                    e.getException().printStackTrace();
                } else {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }

    public static AnnotatedGrammar loadDTDGrammar(InputSource source, InputSource bindFile, Controller controller) {
        return TDTDReader.parse(source, bindFile, controller, new ExpressionPool());
    }

    public static DOMForest buildXMLSchemaDOMForest(InputSource[] sources, InputSource[] externalBindingFiles, Controller controller) throws SAXException, IOException {
        DOMForest forest;
        try {
            DocumentBuilderFactory domBuilder = DocumentBuilderFactory.newInstance();
            domBuilder.setNamespaceAware(true);
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            forest = new DOMForest(parserFactory, domBuilder.newDocumentBuilder());
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        forest.setErrorHandler(controller);
        int i = 0;
        while (i < sources.length) {
            forest.parse(sources[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < externalBindingFiles.length) {
            Element root = forest.parse(externalBindingFiles[i2]).getDocumentElement();
            if (!root.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxb") || !root.getLocalName().equals("bindings")) {
                controller.error(new SAXParseException(Messages.format("Driver.NotABindingFile", root.getNamespaceURI(), root.getLocalName()), null, externalBindingFiles[i2].getSystemId(), -1, -1));
            }
            ++i2;
        }
        Internalizer.transform(forest, controller);
        return forest;
    }

    public static AnnotatedGrammar loadXMLSchemaGrammar(InputSource[] sources, InputSource[] externalBindingFiles, final Controller controller, String defaultPackage, Options opt) throws SAXException, IOException {
        DOMForest forest = Driver.buildXMLSchemaDOMForest(sources, externalBindingFiles, controller);
        final DOMForestParser forestParser = new DOMForestParser(forest, new JAXPParser());
        final Options o = opt;
        XSOMParser reader = new XSOMParser(new XMLParser(){

            public void parse(InputSource source, ContentHandler handler) throws SAXException, IOException {
                handler = this.wrapBy(new ProhibitedFeaturesFilter(controller, o.compatibilityMode == 1), handler);
                handler = this.wrapBy(new ExtensionBindingChecker(controller), handler);
                handler = this.wrapBy(new IncorrectNamespaceURIChecker(controller), handler);
                handler = this.wrapBy(new CustomizationContextChecker(controller), handler);
                forestParser.parse(source, handler);
            }

            private ContentHandler wrapBy(XMLFilterImpl filter, ContentHandler handler) {
                filter.setContentHandler(handler);
                return filter;
            }
        });
        JCodeModel codeModel = new JCodeModel();
        reader.setAnnotationParser(new AnnotationParserFactoryImpl(codeModel));
        reader.setErrorHandler(controller);
        int i = 0;
        while (i < sources.length) {
            reader.parse(sources[i]);
            ++i;
        }
        XSSchemaSet xs = reader.getResult();
        if (xs == null) {
            return null;
        }
        AnnotatedGrammar grammar = BGMBuilder.build(xs, codeModel, controller, defaultPackage);
        if (controller.hadError() || grammar == null) {
            return null;
        }
        return grammar;
    }

    public static AnnotatedGrammar loadRELAXNGGrammar(InputSource source, Controller controller, String defaultPackage) {
        TRELAXNGReader reader = new TRELAXNGReader(controller, new SAXParserFactoryImpl(RELAXNGReader.getRELAXNGSchema4Schema()), defaultPackage);
        reader.parse(source);
        return reader.getAnnotatedResult();
    }

    public static boolean generateCode(AnnotatedGrammar grammar, Options opt, ErrorHandler errorHandler, CodeWriter cw) throws IOException, SAXException {
        ErrorHandlerFilter ehFilter = new ErrorHandlerFilter(errorHandler);
        GeneratorContext context = SkeletonGenerator.generate(grammar, opt, ehFilter);
        UnmarshallerGenerator.generate(grammar, context, opt);
        MarshallerGenerator.generate(grammar, context, opt);
        ValidatorGenerator.generate(grammar, context, opt);
        if (ehFilter.hadError()) {
            return false;
        }
        grammar.codeModel.build(cw);
        return true;
    }

    public static int guessSchemaLanguage(InputSource[] grammars) {
        if (grammars.length > 1) {
            return 1;
        }
        String name = grammars[0].getSystemId();
        String lastFour = name.substring(Math.max(0, name.length() - 4)).toLowerCase();
        if (name.endsWith(".rng")) {
            return 2;
        }
        if (name.endsWith(".dtd")) {
            return 0;
        }
        return 1;
    }

    public static CodeWriter createCodeWriter(File targetDir, boolean readonly) throws IOException {
        String format = Messages.format("Driver.DateFormat") + " '" + Messages.format("Driver.At") + "' " + Messages.format("Driver.TimeFormat");
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return new FileWithPrologCodeWriter(targetDir, Messages.format("Driver.FilePrologComment", dateFormat.format(new Date())), readonly);
    }

    private static void usage(boolean privateUsage) {
        if (privateUsage) {
            System.out.println(Messages.format("Driver.Private.Usage"));
        } else {
            System.out.println(Messages.format("Driver.Public.Usage"));
        }
        System.exit(-1);
    }

    public static class BadCommandLineException
    extends Exception {
        BadCommandLineException(String msg) {
            super(msg);
        }
    }
}

