/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.generator.field;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.util.ExpressionWalker;
import com.sun.tools.xjc.generator.field.FieldRenderer;
import com.sun.tools.xjc.generator.field.FieldRendererFactory;
import com.sun.tools.xjc.generator.marshaller.FieldMarshallerGenerator;
import com.sun.tools.xjc.generator.util.BlockReference;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.FieldUse;
import com.sun.tools.xjc.grammar.PrimitiveItem;
import com.sun.tools.xjc.grammar.xducer.TypeAdaptedTransducer;
import java.util.ArrayList;

public final class ConstFieldRenderer
implements FieldRenderer {
    private JCodeModel codeModel;
    private boolean isCollection = false;
    private final FieldUse use;
    private JVar $ref;
    private int count;
    public static final FieldRendererFactory theFactory = new FieldRendererFactory(){

        public FieldRenderer create(FieldUse fu) {
            return new ConstFieldRenderer(fu);
        }
    };

    public ConstFieldRenderer(FieldUse _use) {
        this.use = _use;
    }

    public void generate(JDefinedClass interfaceClass, JDefinedClass implementationClass) {
        this.codeModel = this.use.codeModel;
        JExpression initializer = this.calcInitializer();
        this.$ref = interfaceClass.field(25, this.getValueType(), this.use.name, initializer);
    }

    public JBlock getOnSetEventHandler() {
        return JBlock.dummyInstance;
    }

    public void unsetValues(JBlock body) {
    }

    public JExpression hasSetValue() {
        return null;
    }

    public JExpression getValue() {
        return this.$ref;
    }

    public JType getValueType() {
        return this.isCollection ? this.getType().array() : this.getType();
    }

    private JType getType() {
        return this.use.type;
    }

    public FieldUse getFieldUse() {
        return this.use;
    }

    public void setter(JBlock body, JExpression newValue) {
    }

    public JExpression ifCountEqual(int i) {
        if (i == this.count) {
            return null;
        }
        return JExpr.lit(false);
    }

    public JExpression ifCountGte(int i) {
        if (i <= this.count) {
            return null;
        }
        return JExpr.lit(false);
    }

    public JExpression ifCountLte(int i) {
        if (i >= this.count) {
            return null;
        }
        return JExpr.lit(false);
    }

    private JExpression calcInitializer() {
        FieldItem[] items = this.use.getItems();
        final ArrayList result = new ArrayList();
        items[0].exp.visit(new ExpressionWalker(){

            public void onList(ListExp exp) {
                ConstFieldRenderer.this.isCollection = true;
                exp.exp.visit(this);
            }

            public void onOther(OtherExp exp) {
                if (exp instanceof PrimitiveItem) {
                    PrimitiveItem pi = (PrimitiveItem)exp;
                    JExpression init = TypeAdaptedTransducer.adapt(pi.xducer, ConstFieldRenderer.this).generateConstant(pi);
                    result.add(init);
                }
            }
        });
        this.count = result.size();
        if (!this.isCollection) {
            return (JExpression)result.get(0);
        }
        JInvocation inv = JExpr._new(this.getType().array());
        int i = 0;
        while (i < result.size()) {
            inv.arg((JExpression)result.get(i));
            ++i;
        }
        return inv;
    }

    public FieldMarshallerGenerator createMarshaller(JBlock block, String uniqueId) {
        if (!this.isCollection) {
            return new SingleFMGImpl();
        }
        JVar $idx = block.decl(this.codeModel.INT, "idx" + uniqueId, JExpr.lit(0));
        return new CollectionFMGImpl($idx);
    }

    private class CollectionFMGImpl
    implements FieldMarshallerGenerator {
        private final JVar $idx;

        CollectionFMGImpl(JVar _$idx) {
            this.$idx = _$idx;
        }

        public JExpression hasMore() {
            return this.$idx.ne(ConstFieldRenderer.this.$ref.ref("length"));
        }

        public JExpression peek(boolean typed, boolean increment) {
            return ConstFieldRenderer.this.$ref.component(increment ? this.$idx.incr() : this.$idx);
        }

        public void increment(BlockReference block) {
            block.get().assignPlus(this.$idx, JExpr.lit(1));
        }

        public FieldMarshallerGenerator clone(JBlock block, String uniqueId) {
            JVar $newidx = block.decl(((ConstFieldRenderer)ConstFieldRenderer.this).codeModel.INT, "idx" + uniqueId, this.$idx);
            return new CollectionFMGImpl($newidx);
        }

        public FieldRenderer owner() {
            return ConstFieldRenderer.this;
        }
    }

    private final class SingleFMGImpl
    implements FieldMarshallerGenerator {
        private SingleFMGImpl() {
        }

        public JExpression hasMore() {
            return JExpr.lit(true);
        }

        public JExpression peek(boolean typed, boolean increment) {
            return ConstFieldRenderer.this.$ref;
        }

        public void increment(BlockReference block) {
        }

        public FieldMarshallerGenerator clone(JBlock block, String uniqueId) {
            return this;
        }

        public FieldRenderer owner() {
            return ConstFieldRenderer.this;
        }
    }
}

