/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.generator.unmarshaller;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitor;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.grammar.util.ExpressionWalker;
import com.sun.tools.xjc.generator.GeneratorContext;
import com.sun.tools.xjc.generator.unmarshaller.Alphabet;
import com.sun.tools.xjc.generator.unmarshaller.Automaton;
import com.sun.tools.xjc.generator.unmarshaller.State;
import com.sun.tools.xjc.generator.unmarshaller.Transition;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.FieldUse;
import com.sun.tools.xjc.grammar.IgnoreItem;
import com.sun.tools.xjc.grammar.InterfaceItem;
import com.sun.tools.xjc.grammar.JavaItem;
import com.sun.tools.xjc.grammar.JavaItemVisitor;
import com.sun.tools.xjc.grammar.PrimitiveItem;
import com.sun.tools.xjc.grammar.SuperClassItem;
import com.sun.tools.xjc.grammar.WildcardItem;
import java.util.Map;

public class AutomatonBuilder {
    private final ClassItem classItem;
    private final GeneratorContext context;
    private final Map otherAutomata;
    private State tail;
    private int idGen = 0;
    private final ExpressionVisitor normal = new Normal();
    private final ExpressionVisitor inIgnoredItem = new Base(){

        public Object onValue(ValueExp exp) {
            return this.createIgnoredTextTransition();
        }

        public Object onData(DataExp exp) {
            return this.createIgnoredTextTransition();
        }

        public Object onAnyString() {
            return this.createIgnoredTextTransition();
        }

        public Object onList(ListExp exp) {
            return this.createIgnoredTextTransition();
        }

        private State createIgnoredTextTransition() {
            State head = new State();
            head.addTransition(new Transition(new Alphabet.IgnoredText(), AutomatonBuilder.this.tail));
            return head;
        }
    };

    public static void build(Automaton a, GeneratorContext context, Map automata) {
        ClassItem ci = a.getOwner();
        a.setInitialState((State)ci.exp.visit(new AutomatonBuilder(ci, context, automata).new Normal()));
    }

    private Automaton getAutomaton(ClassItem ci) {
        return (Automaton)this.otherAutomata.get(ci);
    }

    private AutomatonBuilder(ClassItem ci, GeneratorContext _context, Map _automata) {
        this.tail = new State();
        this.tail.isFinalState = true;
        this.classItem = ci;
        this.context = _context;
        this.otherAutomata = _automata;
    }

    private class Normal
    extends Base
    implements JavaItemVisitor {
        private FieldUse currentField = null;
        private boolean inSuperClass = false;

        private Normal() {
        }

        public Object onOther(OtherExp exp) {
            if (exp instanceof JavaItem) {
                return ((JavaItem)exp).visitJI(this);
            }
            return exp.exp.visit(this);
        }

        public Object onIgnore(IgnoreItem item) {
            return item.exp.visit(AutomatonBuilder.this.inIgnoredItem);
        }

        public Object onField(FieldItem fi) {
            if (this.currentField != null) {
                throw new InternalError();
            }
            this.currentField = AutomatonBuilder.this.classItem.getField(fi.name);
            Object r = fi.exp.visit(this);
            this.currentField = null;
            return r;
        }

        public Object onInterface(InterfaceItem item) {
            return item.exp.visit(this);
        }

        public Object onSuper(SuperClassItem item) {
            this.inSuperClass = true;
            Object ret = item.exp.visit(this);
            this.inSuperClass = false;
            return ret;
        }

        public Object onWildcard(WildcardItem item) {
            State head = new State();
            if (this.currentField == null) {
                throw new InternalError();
            }
            Alphabet.Wildcard a = new Alphabet.Wildcard(item.range, AutomatonBuilder.this.context.getField(this.currentField), AutomatonBuilder.this.idGen++);
            head.addTransition(new Transition(a, AutomatonBuilder.this.tail));
            return head;
        }

        public Object onClass(ClassItem item) {
            Alphabet.StaticReference a;
            State head = new State();
            if (this.inSuperClass) {
                a = new Alphabet.SuperClass(AutomatonBuilder.this.getAutomaton(item), AutomatonBuilder.this.idGen++);
            } else {
                if (this.currentField == null) {
                    throw new InternalError();
                }
                a = new Alphabet.Child(AutomatonBuilder.this.getAutomaton(item), AutomatonBuilder.this.context.getField(this.currentField), AutomatonBuilder.this.idGen++);
            }
            head.addTransition(new Transition(a, AutomatonBuilder.this.tail));
            return head;
        }

        public Object onPrimitive(PrimitiveItem item) {
            if (this.currentField == null) {
                throw new InternalError();
            }
            State head = new State();
            head.addTransition(new Transition(new Alphabet.BoundText(item, AutomatonBuilder.this.context.getField(this.currentField)), AutomatonBuilder.this.tail));
            return head;
        }

        public Object onValue(ValueExp exp) {
            throw new InternalError();
        }

        public Object onData(DataExp exp) {
            throw new InternalError();
        }

        public Object onAnyString() {
            throw new InternalError();
        }
    }

    private abstract class Base
    implements ExpressionVisitor {
        private Base() {
        }

        public Object onRef(ReferenceExp exp) {
            return exp.exp.visit(this);
        }

        public Object onOther(OtherExp exp) {
            return exp.exp.visit(this);
        }

        public Object onEpsilon() {
            return AutomatonBuilder.this.tail;
        }

        public Object onElement(ElementExp exp) {
            final boolean[] type = new boolean[1];
            exp.contentModel.visit(new ExpressionWalker(){

                public void onElement(ElementExp exp) {
                }

                public void onAttribute(AttributeExp exp) {
                }

                public void onData(DataExp exp) {
                    type[0] = true;
                }

                public void onValue(ValueExp exp) {
                    type[0] = true;
                }

                public void onAnyString() {
                    type[0] = true;
                }
            });
            return this.onItem(exp, new Alphabet.EnterElement(exp.getNameClass(), type[0]), new Alphabet.LeaveElement(exp.getNameClass()));
        }

        public Object onAttribute(AttributeExp exp) {
            State _tail = AutomatonBuilder.this.tail;
            _tail.absorb(this.onItem(exp, new Alphabet.EnterAttribute(exp.getNameClass(), AutomatonBuilder.this.idGen++), new Alphabet.LeaveAttribute(exp.getNameClass())));
            return _tail;
        }

        private State onItem(NameClassAndExpression exp, Alphabet s, Alphabet e) {
            State newTail = new State();
            newTail.addTransition(new Transition(e, AutomatonBuilder.this.tail));
            AutomatonBuilder.this.tail = newTail;
            State contentHead = (State)exp.getContentModel().visit(this);
            State head = new State();
            head.addTransition(new Transition(s, contentHead));
            return head;
        }

        public Object onInterleave(InterleaveExp exp) {
            Expression[] children = exp.getChildren();
            State head = new State();
            State currentTail = AutomatonBuilder.this.tail;
            int i = 0;
            while (i < children.length) {
                AutomatonBuilder.this.tail = currentTail;
                head.absorb((State)children[i].visit(this));
                ++i;
            }
            currentTail.absorb(head);
            return currentTail;
        }

        public Object onSequence(SequenceExp exp) {
            Expression[] children = exp.getChildren();
            int i = children.length - 1;
            while (i >= 0) {
                AutomatonBuilder.this.tail = (State)children[i].visit(this);
                --i;
            }
            return AutomatonBuilder.this.tail;
        }

        public Object onChoice(ChoiceExp exp) {
            Expression[] children = exp.getChildren();
            State currentTail = AutomatonBuilder.this.tail;
            State head = exp.isEpsilonReducible() ? AutomatonBuilder.this.tail : new State();
            int i = 0;
            while (i < children.length) {
                AutomatonBuilder.this.tail = currentTail;
                head.absorb((State)children[i].visit(this));
                ++i;
            }
            return head;
        }

        public Object onOneOrMore(OneOrMoreExp exp) {
            State _tail = AutomatonBuilder.this.tail;
            State newHead = (State)exp.exp.visit(this);
            _tail.absorb(newHead);
            return newHead;
        }

        public Object onList(ListExp exp) {
            State head = (State)exp.exp.visit(this);
            head.isListState = true;
            return head;
        }

        public Object onNullSet() {
            return new State();
        }

        public Object onMixed(MixedExp exp) {
            throw new InternalError();
        }

        public Object onConcur(ConcurExp exp) {
            throw new InternalError();
        }

        public abstract Object onValue(ValueExp var1);

        public abstract Object onData(DataExp var1);

        public abstract Object onAnyString();
    }
}

