/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.annotator;

import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionCloner;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.util.NotAllowedRemover;
import com.sun.tools.xjc.reader.annotator.AnnotatorController;
import com.sun.tools.xjc.reader.annotator.ChoiceAnnotator;
import com.sun.tools.xjc.reader.annotator.DatatypeSimplifier;
import com.sun.tools.xjc.reader.annotator.EmptyJavaItemRemover;
import com.sun.tools.xjc.reader.annotator.FieldItemAnnotation;
import com.sun.tools.xjc.reader.annotator.HierarchyAnnotator;
import com.sun.tools.xjc.reader.annotator.PrimitiveTypeAnnotator;
import com.sun.tools.xjc.reader.annotator.RelationNormalizer;
import com.sun.tools.xjc.reader.annotator.SymbolSpaceTypeAssigner;
import com.sun.tools.xjc.reader.annotator.TemporaryClassItemRemover;
import com.sun.tools.xjc.writer.Writer;
import java.io.PrintStream;

public class Annotator {
    private static PrintStream debug = null;

    public static Expression annotate(AnnotatedGrammar grammar, AnnotatorController controller) {
        if (debug != null) {
            debug.println("---------------------------------------------");
            debug.println("initial grammar");
            Writer.writeToConsole(true, grammar);
            debug.println("---------------------------------------------");
        }
        if (debug != null) {
            debug.println("removing notAllowed");
        }
        ExpressionCloner visitor = new NotAllowedRemover(grammar.getPool());
        grammar.topLevel = grammar.topLevel.visit(visitor);
        if (grammar.topLevel == Expression.nullSet) {
            return Expression.nullSet;
        }
        ClassItem[] classes = grammar.getClasses();
        int i = 0;
        while (i < classes.length) {
            classes[i].exp = classes[i].exp.visit(visitor);
            ++i;
        }
        if (debug != null) {
            Writer.writeToConsole(true, grammar);
            debug.println("---------------------------------------------");
        }
        if (debug != null) {
            debug.println("removing empty JavaItems");
        }
        visitor = new EmptyJavaItemRemover(grammar.getPool());
        grammar.topLevel = grammar.topLevel.visit(visitor);
        if (grammar.topLevel == Expression.nullSet) {
            return Expression.nullSet;
        }
        classes = grammar.getClasses();
        i = 0;
        while (i < classes.length) {
            classes[i].exp = classes[i].exp.visit(visitor);
            ++i;
        }
        if (debug != null) {
            Writer.writeToConsole(true, grammar);
            debug.println("---------------------------------------------");
        }
        if (debug != null) {
            debug.println("simplifying datatypes");
        }
        grammar.topLevel = grammar.topLevel.visit(new DatatypeSimplifier(grammar.getPool()));
        if (debug != null) {
            Writer.writeToConsole(true, grammar);
            debug.println("---------------------------------------------");
        }
        if (debug != null) {
            debug.println("examining primitive types");
        }
        visitor = new PrimitiveTypeAnnotator(grammar, controller);
        grammar.topLevel = grammar.topLevel.visit(visitor);
        if (grammar.topLevel == Expression.nullSet) {
            return Expression.nullSet;
        }
        classes = grammar.getClasses();
        i = 0;
        while (i < classes.length) {
            classes[i].exp = classes[i].exp.visit(visitor);
            ++i;
        }
        if (debug != null) {
            Writer.writeToConsole(true, grammar);
            debug.println("---------------------------------------------");
        }
        if (debug != null) {
            debug.println("annotating complex choices");
        }
        ChoiceAnnotator.annotate(grammar, controller);
        if (debug != null) {
            Writer.writeToConsole(true, grammar);
            debug.println("---------------------------------------------");
        }
        if (debug != null) {
            debug.println("removing temporary class items");
        }
        TemporaryClassItemRemover.remove(grammar);
        if (debug != null) {
            Writer.writeToConsole(true, grammar);
            debug.println("---------------------------------------------");
        }
        if (debug != null) {
            debug.println("adding field items");
        }
        FieldItemAnnotation.annotate(grammar, controller);
        if (debug != null) {
            Writer.writeToConsole(true, grammar);
            debug.println("---------------------------------------------");
        }
        if (debug != null) {
            debug.println("computing type hierarchy");
        }
        HierarchyAnnotator.annotate(grammar, controller);
        if (debug != null) {
            Writer.writeToConsole(true, grammar);
            debug.println("---------------------------------------------");
        }
        if (debug != null) {
            debug.println("determining types for symbol spaces");
        }
        SymbolSpaceTypeAssigner.assign(grammar, controller);
        if (debug != null) {
            Writer.writeToConsole(true, grammar);
            debug.println("---------------------------------------------");
        }
        if (debug != null) {
            debug.println("normalizing relations");
        }
        RelationNormalizer.normalize(grammar, controller);
        if (debug != null) {
            Writer.writeToConsole(true, grammar);
            debug.println("---------------------------------------------");
        }
        return grammar.topLevel;
    }
}

