/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.annotator;

import com.sun.codemodel.JPackage;
import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.datatype.xsd.StringType;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.DataOrValueExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionCloner;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.ValueExp;
import com.sun.tools.xjc.generator.util.WhitespaceNormalizer;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.IgnoreItem;
import com.sun.tools.xjc.grammar.PrimitiveItem;
import com.sun.tools.xjc.grammar.xducer.BuiltinDatatypeTransducerFactory;
import com.sun.tools.xjc.grammar.xducer.EnumerationXducer;
import com.sun.tools.xjc.grammar.xducer.IdentityTransducer;
import com.sun.tools.xjc.grammar.xducer.Transducer;
import com.sun.tools.xjc.reader.annotator.AnnotatorController;
import com.sun.tools.xjc.util.CodeModelClassFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.relaxng.datatype.Datatype;

class PrimitiveTypeAnnotator
extends ExpressionCloner {
    private final AnnotatedGrammar grammar;
    private final AnnotatorController controller;
    private final CodeModelClassFactory classFactory;
    private final Set visitedExps = new HashSet();
    private final Map primitiveItems = new HashMap();
    private JPackage currentPackage;

    PrimitiveTypeAnnotator(AnnotatedGrammar _grammar, AnnotatorController _controller) {
        super(_grammar.getPool());
        this.grammar = _grammar;
        this.controller = _controller;
        this.classFactory = new CodeModelClassFactory(this.controller.getErrorHandler());
        this.currentPackage = _grammar.codeModel._package("");
    }

    public Expression onRef(ReferenceExp exp) {
        JPackage oldPackage = this.currentPackage;
        if (this.controller.getPackageTracker().get(exp) != null) {
            this.currentPackage = this.controller.getPackageTracker().get(exp);
        }
        if (this.visitedExps.add(exp)) {
            Expression e = this.processEnumeration(exp.name, exp.exp);
            if (e == null) {
                e = exp.exp.visit(this);
            }
            exp.exp = e;
        }
        this.currentPackage = oldPackage;
        return exp;
    }

    public Expression onOther(OtherExp exp) {
        if (exp instanceof PrimitiveItem) {
            return exp;
        }
        if (exp instanceof IgnoreItem) {
            return exp;
        }
        if (this.visitedExps.add(exp)) {
            exp.exp = exp.exp.visit(this);
        }
        return exp;
    }

    public Expression onElement(ElementExp exp) {
        if (this.visitedExps.add(exp)) {
            Expression e = this.processEnumeration(exp);
            if (e == null) {
                e = exp.contentModel.visit(this);
            }
            exp.contentModel = e;
        }
        return exp;
    }

    public Expression onAttribute(AttributeExp exp) {
        if (this.visitedExps.contains(exp)) {
            return exp;
        }
        Expression e = this.processEnumeration(exp);
        if (e == null) {
            e = exp.exp.visit(this);
        }
        e = this.pool.createAttribute(exp.nameClass, e);
        this.visitedExps.add(e);
        return e;
    }

    public Expression processEnumeration(NameClassAndExpression exp) {
        NameClass nc = exp.getNameClass();
        if (!(nc instanceof SimpleNameClass)) {
            return null;
        }
        return this.processEnumeration(((SimpleNameClass)nc).localName + "Values", exp.getContentModel());
    }

    public Expression processEnumeration(String className, Expression exp) {
        if (className == null) {
            return null;
        }
        Expression e = exp.visit(new ExpressionCloner(this.pool){

            public Expression onAttribute(AttributeExp exp) {
                return exp;
            }

            public Expression onElement(ElementExp exp) {
                return exp;
            }

            public Expression onOther(OtherExp exp) {
                return exp;
            }

            public Expression onRef(ReferenceExp exp) {
                if (exp.name == null) {
                    return exp.exp.visit(this);
                }
                return exp;
            }
        });
        if (!(e instanceof ChoiceExp)) {
            return null;
        }
        ChoiceExp cexp = (ChoiceExp)e;
        Expression[] children = cexp.getChildren();
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof ValueExp)) {
                return null;
            }
            ++i;
        }
        className = this.controller.getNameConverter().toClassName(className);
        String _package = "";
        PrimitiveItem p = new PrimitiveItem(new EnumerationXducer(this.controller.getNameConverter(), this.classFactory.createClass(this.currentPackage, className, null), cexp, new HashMap(), null), (DatabindableDatatype)StringType.theInstance, (Expression)cexp);
        this.primitiveItems.put(exp, p);
        return p;
    }

    public Expression onData(DataExp exp) {
        return this.onDataOrValue(exp);
    }

    public Expression onValue(ValueExp exp) {
        return this.onDataOrValue(exp);
    }

    private Expression onDataOrValue(DataOrValueExp exp) {
        XSDatatype guard;
        Transducer xducer;
        if (this.primitiveItems.containsKey(exp)) {
            return (Expression)this.primitiveItems.get(exp);
        }
        Datatype dt = exp.getType();
        if (dt instanceof XSDatatype) {
            xducer = BuiltinDatatypeTransducerFactory.get(this.grammar, (XSDatatype)dt);
            guard = (XSDatatype)dt;
        } else {
            xducer = new IdentityTransducer(this.grammar.codeModel, WhitespaceNormalizer.PRESERVE);
            guard = StringType.theInstance;
        }
        PrimitiveItem p = new PrimitiveItem(xducer, (DatabindableDatatype)guard, (Expression)((Object)exp));
        this.primitiveItems.put(exp, p);
        return p;
    }
}

