/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.fmt.JTextFile;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.reader.NameConverter;
import com.sun.tools.xjc.reader.PackageTracker;
import com.sun.tools.xjc.reader.annotator.AnnotatorController;
import com.sun.tools.xjc.reader.annotator.DatatypeSimplifier;
import com.sun.tools.xjc.reader.annotator.HierarchyAnnotator;
import com.sun.tools.xjc.reader.annotator.RelationNormalizer;
import com.sun.tools.xjc.reader.annotator.SymbolSpaceTypeAssigner;
import com.sun.tools.xjc.reader.xmlschema.AGMFragmentBuilder;
import com.sun.tools.xjc.reader.xmlschema.AlternativeParticleBinder;
import com.sun.tools.xjc.reader.xmlschema.ClassSelector;
import com.sun.tools.xjc.reader.xmlschema.ComplexTypeFlag;
import com.sun.tools.xjc.reader.xmlschema.DefaultParticleBinder;
import com.sun.tools.xjc.reader.xmlschema.ErrorReporter;
import com.sun.tools.xjc.reader.xmlschema.FieldBuilder;
import com.sun.tools.xjc.reader.xmlschema.ParticleBinder;
import com.sun.tools.xjc.reader.xmlschema.SimpleTypeBuilder;
import com.sun.tools.xjc.reader.xmlschema.TypeBuilder;
import com.sun.tools.xjc.reader.xmlschema.UnusedCustomizationChecker;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIGlobalBinding;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BISchemaBinding;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIXSerializable;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIXSuperClass;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BindInfo;
import com.sun.tools.xjc.util.CodeModelClassFactory;
import com.sun.tools.xjc.util.ErrorHandlerFilter;
import com.sun.tools.xjc.util.WrappedSAXException;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class BGMBuilder
implements AnnotatorController {
    protected final ClassSelector selector;
    protected final TypeBuilder typeBuilder;
    protected final FieldBuilder fieldBuilder;
    protected final ParticleBinder particleBinder;
    protected final AGMFragmentBuilder agmFragmentBuilder;
    protected final Set particlesWithGlobalElementSkip = new HashSet();
    private final Map complexTypeFlags = new Hashtable();
    private BIGlobalBinding globalBinding;
    private NameConverter nameConverter;
    protected final XSSchemaSet schemas;
    private final Map externalBindInfos = new HashMap();
    public final ErrorReporter errorReporter;
    protected final ExpressionPool pool = new ExpressionPool();
    public final AnnotatedGrammar grammar;
    protected final SimpleTypeBuilder simpleTypeBuilder;
    protected final CodeModelClassFactory codeModelClassFactory;
    private Set reportedAbstractComplexTypes = null;

    public static AnnotatedGrammar build(XSSchemaSet schemas, JCodeModel codeModel, ErrorHandler errorHandler, String defPackage) throws SAXException {
        ErrorHandlerFilter ehFilter = new ErrorHandlerFilter(errorHandler);
        try {
            AnnotatedGrammar grammar = new BGMBuilder(schemas, codeModel, ehFilter, defPackage)._build(schemas);
            if (ehFilter.hadError()) {
                return null;
            }
            return grammar;
        }
        catch (WrappedSAXException e) {
            throw e.getException();
        }
    }

    public void setComplexTypeFlag(XSComplexType type, ComplexTypeFlag flag) {
        BGMBuilder._assert(this.complexTypeFlags.put(type, flag) == null);
    }

    public ComplexTypeFlag getComplexTypeFlag(XSComplexType type) {
        Object r = this.complexTypeFlags.get(type);
        BGMBuilder._assert(r != null);
        return (ComplexTypeFlag)r;
    }

    private AnnotatedGrammar _build(XSSchemaSet schemas) {
        this.buildContents();
        this.buildTopLevelExp();
        this.reportUnusedCustomizations();
        if (!this.errorReporter.hadError()) {
            this.grammar.topLevel = this.grammar.topLevel.visit(new DatatypeSimplifier(this.grammar.getPool()));
            HierarchyAnnotator.annotate(this.grammar, this);
            SymbolSpaceTypeAssigner.assign(this.grammar, this);
            RelationNormalizer.normalize(this.grammar, this);
        }
        return this.grammar;
    }

    private void promoteGlobalBindings() {
        BIXSerializable serial;
        BIXSuperClass root;
        Iterator itr = this.schemas.iterateSchema();
        while (itr.hasNext()) {
            XSSchema s = (XSSchema)itr.next();
            BindInfo bi = this.getBindInfo(s);
            BIGlobalBinding gb = (BIGlobalBinding)bi.get(BIGlobalBinding.NAME);
            if (gb == null || this.globalBinding != null) continue;
            this.globalBinding = gb;
            this.globalBinding.markAsAcknowledged();
        }
        if (this.globalBinding == null) {
            this.globalBinding = new BIGlobalBinding(this.grammar.codeModel);
            BindInfo big = new BindInfo(null);
            big.addDecl(this.globalBinding);
            big.setOwner(this, null);
        }
        if ((root = this.globalBinding.getSuperClassExtension()) != null) {
            this.grammar.rootClass = root.getRootClass();
        }
        if ((serial = this.globalBinding.getSerializableExtension()) != null) {
            this.grammar.serialVersionUID = new Long(serial.getUID());
        }
        this.nameConverter = this.globalBinding.getNameConverter();
        this.globalBinding.dispatchGlobalConversions(this.schemas);
    }

    public BIGlobalBinding getGlobalBinding() {
        return this.globalBinding;
    }

    public NameConverter getNameConverter() {
        return this.nameConverter;
    }

    private void buildContents() {
        Iterator itr = this.schemas.iterateSchema();
        while (itr.hasNext()) {
            XSSchema s = (XSSchema)itr.next();
            if (s.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema")) continue;
            this.checkMultipleSchemaBindings(s);
            this.processPackageJavadoc(s);
            this.populate(s.iterateAttGroupDecls());
            this.populate(s.iterateAttributeDecls());
            this.populate(s.iterateComplexTypes());
            this.populate(s.iterateElementDecls());
            this.populate(s.iterateModelGroupDecls());
            this.populate(s.iterateSimpleTypes());
        }
    }

    private void checkMultipleSchemaBindings(XSSchema schema) {
        ArrayList<Locator> locations = new ArrayList<Locator>();
        BindInfo bi = this.getBindInfo(schema);
        int i = 0;
        while (i < bi.size()) {
            if (bi.get(i).getName() == BISchemaBinding.NAME) {
                locations.add(bi.get(i).getLocation());
            }
            ++i;
        }
        if (locations.size() <= 1) {
            return;
        }
        this.errorReporter.error((Locator)locations.get(0), "BGMBuilder.MultipleSchemaBindings", schema.getTargetNamespace());
        int i2 = 1;
        while (i2 < locations.size()) {
            this.errorReporter.error((Locator)locations.get(i2), "BGMBuilder.MultipleSchemaBindings.Location");
            ++i2;
        }
    }

    private void populate(Iterator itr) {
        while (itr.hasNext()) {
            XSComponent sc = (XSComponent)itr.next();
            this.selector.select(sc);
        }
    }

    private void processPackageJavadoc(XSSchema s) {
        BISchemaBinding cust = (BISchemaBinding)this.getBindInfo(s).get(BISchemaBinding.NAME);
        if (cust == null) {
            return;
        }
        if (cust.getJavadoc() == null) {
            return;
        }
        JTextFile html = new JTextFile("package.html");
        html.setContents(cust.getJavadoc());
        this.selector.getPackage(s.getTargetNamespace()).addResourceFile(html);
    }

    private void buildTopLevelExp() {
        Expression top = Expression.nullSet;
        Iterator itr = this.schemas.iterateElementDecls();
        while (itr.hasNext()) {
            XSElementDecl decl = (XSElementDecl)itr.next();
            ClassItem ci = this.selector.select(decl);
            if (ci == null) continue;
            top = this.pool.createChoice(top, ci);
        }
        if (top == Expression.nullSet) {
            this.errorReporter.warning(null, "BGMBuilder.NoGlobalElement", null);
        }
        this.grammar.topLevel = top;
    }

    private void reportUnusedCustomizations() {
        new UnusedCustomizationChecker(this).run();
    }

    public BGMBuilder(XSSchemaSet _schemas, JCodeModel codeModel, ErrorHandler _errorHandler, String defaultPackage) {
        this.schemas = _schemas;
        this.grammar = new AnnotatedGrammar(Expression.nullSet, this.pool, codeModel);
        this.errorReporter = new ErrorReporter(_errorHandler);
        this.simpleTypeBuilder = new SimpleTypeBuilder(this);
        this.typeBuilder = new TypeBuilder(this);
        this.fieldBuilder = new FieldBuilder(this);
        this.agmFragmentBuilder = new AGMFragmentBuilder(this);
        this.codeModelClassFactory = new CodeModelClassFactory(_errorHandler);
        this.promoteGlobalBindings();
        this.selector = new ClassSelector(this, defaultPackage);
        this.particleBinder = this.getGlobalBinding().isModelGroupBinding() ? new AlternativeParticleBinder(this) : new DefaultParticleBinder(this);
    }

    public BindInfo getBindInfo(XSComponent schemaComponent) {
        BindInfo bi = this.getBindInfoReadOnly(schemaComponent);
        if (bi != null) {
            return bi;
        }
        bi = new BindInfo(null);
        bi.setOwner(this, schemaComponent);
        this.externalBindInfos.put(schemaComponent, bi);
        return bi;
    }

    public BindInfo getBindInfoReadOnly(XSComponent schemaComponent) {
        BindInfo bi = (BindInfo)this.externalBindInfos.get(schemaComponent);
        if (bi != null) {
            return bi;
        }
        XSAnnotation annon = schemaComponent.getAnnotation();
        if (annon != null && (bi = (BindInfo)annon.getAnnotation()) != null) {
            if (bi.getOwner() == null) {
                bi.setOwner(this, schemaComponent);
            }
            return bi;
        }
        return null;
    }

    protected Expression processMinMax(Expression item, XSParticle p) {
        return this.processMinMax(item, p.getMinOccurs(), p.getMaxOccurs());
    }

    protected Expression processMinMax(Expression item, int min, int max) {
        Expression exp = Expression.epsilon;
        int i = 0;
        while (i < min) {
            exp = this.pool.createSequence(item, exp);
            ++i;
        }
        if (max == -1) {
            if (min == 1) {
                return this.pool.createOneOrMore(item);
            }
            return this.pool.createSequence(exp, this.pool.createZeroOrMore(item));
        }
        Expression tmp = Expression.epsilon;
        int i2 = min;
        while (i2 < max) {
            tmp = this.pool.createOptional(this.pool.createSequence(item, tmp));
            ++i2;
        }
        return this.pool.createSequence(exp, tmp);
    }

    protected Expression approximateMinMax(Expression item, XSParticle p) {
        return this.approximateMinMax(item, p.getMinOccurs(), p.getMaxOccurs());
    }

    protected Expression approximateMinMax(Expression item, int min, int max) {
        if (1 < min) {
            return this.pool.createOneOrMore(item);
        }
        if (min == 1) {
            if (max != 1) {
                return this.pool.createOneOrMore(item);
            }
            return item;
        }
        if (max == 1) {
            return this.pool.createOptional(item);
        }
        return this.pool.createZeroOrMore(item);
    }

    protected Expression applyRecursively(XSModelGroup mg, ParticleHandler f) {
        Expression[] exp = new Expression[mg.getSize()];
        int i = 0;
        while (i < exp.length) {
            exp[i] = (Expression)f.particle(mg.getChild(i));
            ++i;
        }
        if (mg.getCompositor() == XSModelGroup.SEQUENCE) {
            Expression r = Expression.epsilon;
            int i2 = 0;
            while (i2 < exp.length) {
                r = this.pool.createSequence(r, exp[i2]);
                ++i2;
            }
            return r;
        }
        if (mg.getCompositor() == XSModelGroup.ALL) {
            Expression r = Expression.epsilon;
            int i3 = 0;
            while (i3 < exp.length) {
                r = this.pool.createInterleave(r, exp[i3]);
                ++i3;
            }
            return r;
        }
        if (mg.getCompositor() == XSModelGroup.CHOICE) {
            Expression r = Expression.nullSet;
            int i4 = 0;
            while (i4 < exp.length) {
                r = this.pool.createChoice(r, exp[i4]);
                ++i4;
            }
            return r;
        }
        BGMBuilder._assert(false);
        return null;
    }

    void checkAbstractComplexType(XSElementDecl decl) {
        XSType t = decl.getType();
        if (t.isComplexType() && t.asComplexType().isAbstract()) {
            if (this.reportedAbstractComplexTypes == null) {
                this.reportedAbstractComplexTypes = new HashSet();
            }
            if (this.reportedAbstractComplexTypes.add(t)) {
                this.errorReporter.error(t.getLocator(), "BGMBuilder.AbstractComplexType", t.getName());
                this.errorReporter.error(decl.getLocator(), "BGMBuilder.AbstractComplexType.SourceLocation");
            }
        }
    }

    private static void _assert(boolean b) {
        if (!b) {
            throw new InternalError("assertion failed");
        }
    }

    public PackageTracker getPackageTracker() {
        throw new InternalError();
    }

    public void reportError(Expression[] locations, String msg) {
        this.reportError(new Locator[0], msg);
    }

    public void reportError(Locator[] locations, String msg) {
        Locator loc = null;
        if (locations.length != 0) {
            loc = locations[0];
        }
        this.errorReporter.errorFormatted(loc, msg);
    }

    public ErrorHandler getErrorHandler() {
        return this.errorReporter.getErrorHandler();
    }

    static interface ParticleHandler {
        public Object particle(XSParticle var1);
    }
}

