/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.tools.xjc.reader.xmlschema.Messages;
import com.sun.tools.xjc.util.WrappedSAXException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ErrorReporter {
    private ErrorHandler errorHandler;
    private boolean hadError = false;

    ErrorReporter(ErrorHandler handler) {
        this.setErrorHandler(handler);
    }

    boolean hadError() {
        return this.hadError;
    }

    void setErrorHandler(ErrorHandler h) {
        this.errorHandler = h;
    }

    ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void error(Locator loc, String prop) {
        this.error(loc, prop, new Object[0]);
    }

    public void error(Locator loc, String prop, Object arg1) {
        this.error(loc, prop, new Object[]{arg1});
    }

    public void error(Locator loc, String prop, Object arg1, Object arg2) {
        this.error(loc, prop, new Object[]{arg1, arg2});
    }

    public void error(Locator loc, String prop, Object arg1, Object arg2, Object arg3) {
        this.error(loc, prop, new Object[]{arg1, arg2, arg3});
    }

    public void errorFormatted(Locator loc, String msg) {
        try {
            this.hadError = true;
            this.errorHandler.error(new SAXParseException(msg, loc));
        }
        catch (SAXException e) {
            throw new WrappedSAXException(e);
        }
    }

    public void error(Locator loc, String prop, Object[] args) {
        this.errorFormatted(loc, Messages.format(prop, args));
    }

    public void warning(Locator loc, String prop, Object[] args) {
        try {
            this.errorHandler.warning(new SAXParseException(Messages.format(prop, args), loc));
        }
        catch (SAXException e) {
            throw new WrappedSAXException(e);
        }
    }
}

