/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.tools.xjc.reader.xmlschema.Messages;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public class ExtensionBindingChecker
extends XMLFilterImpl {
    private final NamespaceSupport nsSupport = new NamespaceSupport();
    private int count = 0;
    private final Set enabledExtensions = new HashSet();
    private Locator locator;
    private int cutDepth = 0;
    private static final ContentHandler stub = new DefaultHandler();
    private ContentHandler next;

    public ExtensionBindingChecker(ErrorHandler handler) {
        this.setErrorHandler(handler);
    }

    protected boolean isSupportedExtension(String namespaceUri) {
        return namespaceUri.equals("http://java.sun.com/xml/ns/jaxb/xjc");
    }

    private boolean needsToBePruned(String uri) {
        if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
            return false;
        }
        if (uri.equals("http://java.sun.com/xml/ns/jaxb")) {
            return false;
        }
        return !this.enabledExtensions.contains(uri);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.count = 0;
        this.cutDepth = 0;
        this.nsSupport.reset();
        this.enabledExtensions.clear();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.nsSupport.pushContext();
        this.nsSupport.declarePrefix(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
        this.nsSupport.popContext();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.cutDepth == 0) {
            String v = atts.getValue("http://java.sun.com/xml/ns/jaxb", "extensionBindingPrefixes");
            if (v != null) {
                if (this.count != 0) {
                    this.error(Messages.format("ExtensionBindingChecker.UnexpectedExtensionBindingPrefixes"));
                }
                StringTokenizer tokens = new StringTokenizer(v);
                while (tokens.hasMoreTokens()) {
                    String prefix = tokens.nextToken();
                    String uri = this.nsSupport.getURI(prefix);
                    if (uri == null) {
                        this.error(Messages.format("ExtensionBindingChecker.UndeclaredPrefix", prefix));
                        continue;
                    }
                    if (!this.isSupportedExtension(uri)) {
                        this.error(Messages.format("ExtensionBindingChecker.UnsupportedExtension", prefix));
                    }
                    this.enabledExtensions.add(uri);
                }
            }
            if (this.needsToBePruned(namespaceURI)) {
                super.setContentHandler(stub);
                this.cutDepth = 1;
            }
        } else {
            ++this.cutDepth;
        }
        ++this.count;
        super.startElement(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        if (this.cutDepth != 0) {
            --this.cutDepth;
            if (this.cutDepth == 0) {
                super.setContentHandler(this.next);
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    public void setContentHandler(ContentHandler handler) {
        this.next = handler;
        if (this.getContentHandler() != stub) {
            super.setContentHandler(handler);
        }
    }

    private SAXParseException error(String msg) throws SAXException {
        SAXParseException spe = new SAXParseException(msg, this.locator);
        this.getErrorHandler().error(spe);
        return spe;
    }
}

