/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.util;

import java.util.ArrayList;
import org.apache.xerces.xni.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtils {
    public static Element getFirstChildElement(Element parent, String nsUri, String localPart) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node item = children.item(i);
            if (item instanceof Element && nsUri.equals(item.getNamespaceURI()) && localPart.equals(item.getLocalName())) {
                return (Element)item;
            }
            ++i;
        }
        return null;
    }

    public static Element[] getChildElements(Element parent, String nsUri, String localPart) {
        ArrayList<Node> a = new ArrayList<Node>();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node item = children.item(i);
            if (item instanceof Element && nsUri.equals(item.getNamespaceURI()) && localPart.equals(item.getLocalName())) {
                a.add(item);
            }
            ++i;
        }
        return a.toArray(new Element[a.size()]);
    }

    public static Element[] getChildElements(Element parent) {
        ArrayList<Node> a = new ArrayList<Node>();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node item = children.item(i);
            if (item instanceof Element) {
                a.add(item);
            }
            ++i;
        }
        return a.toArray(new Element[a.size()]);
    }

    public static String getElementText(Element element) throws DOMException {
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3) {
                return child.getNodeValue();
            }
            child = child.getNextSibling();
        }
        return element.getNodeValue();
    }

    public static Element getElement(Document parent, String name) {
        NodeList children = parent.getElementsByTagName(name);
        if (children.getLength() >= 1) {
            return (Element)children.item(0);
        }
        return null;
    }

    public static Element getElement(Document parent, QName qname2) {
        NodeList children = parent.getElementsByTagNameNS(qname2.uri, qname2.localpart);
        if (children.getLength() >= 1) {
            return (Element)children.item(0);
        }
        return null;
    }

    public static Element getElement(Document parent, String namespaceURI, String localName) {
        NodeList children = parent.getElementsByTagNameNS(namespaceURI, localName);
        if (children.getLength() >= 1) {
            return (Element)children.item(0);
        }
        return null;
    }

    private static Element[] getElements(NodeList children) {
        Element[] elements = null;
        int len = 0;
        int i = 0;
        while (i < children.getLength()) {
            if (elements == null) {
                elements = new Element[1];
            }
            if (elements.length == len) {
                Element[] buf = new Element[elements.length + 1];
                System.arraycopy(elements, 0, buf, 0, elements.length);
                elements = buf;
            }
            elements[len++] = (Element)children.item(i);
            ++i;
        }
        return elements;
    }
}

