/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.writer;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.FieldUse;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;

public class SignatureWriter {
    private final AnnotatedGrammar grammar;
    private final ClassItem[] classes;
    private final Hashtable classSet = new Hashtable();
    private final Writer out;
    private int indent = 0;

    public static void write(AnnotatedGrammar grammar, Writer out) throws IOException {
        new SignatureWriter(grammar, out).dump();
    }

    private SignatureWriter(AnnotatedGrammar grammar, Writer out) {
        this.grammar = grammar;
        this.out = out;
        this.classes = grammar.getClasses();
        int i = 0;
        while (i < this.classes.length) {
            this.classSet.put(this.classes[i].getTypeAsDefined(), this.classes[i]);
            ++i;
        }
    }

    private void printIndent() throws IOException {
        int i = 0;
        while (i < this.indent) {
            this.out.write("  ");
            ++i;
        }
    }

    private void println(String s) throws IOException {
        this.printIndent();
        this.out.write(s);
        this.out.write(10);
    }

    private void dump() throws IOException {
        TreeSet<JPackage> packages = new TreeSet<JPackage>(new Comparator(){

            public int compare(Object lhs, Object rhs) {
                return ((JPackage)lhs).name().compareTo(((JPackage)rhs).name());
            }
        });
        int i = 0;
        while (i < this.classes.length) {
            JDefinedClass cls = this.classes[i].getTypeAsDefined();
            packages.add(cls._package());
            ++i;
        }
        Iterator itr = packages.iterator();
        while (itr.hasNext()) {
            this.dump((JPackage)itr.next());
        }
        this.out.flush();
    }

    private void dump(JPackage pkg) throws IOException {
        this.println("package " + pkg.name() + " {");
        ++this.indent;
        this.dumpChildren(pkg);
        --this.indent;
        this.println("}");
    }

    private void dumpChildren(JClassContainer cont) throws IOException {
        Iterator itr = cont.classes();
        while (itr.hasNext()) {
            JDefinedClass cls = (JDefinedClass)itr.next();
            ClassItem ci = (ClassItem)this.classSet.get(cls);
            if (ci == null) continue;
            this.dump(ci);
        }
    }

    private void dump(ClassItem ci) throws IOException {
        JDefinedClass cls = ci.getTypeAsDefined();
        StringBuffer buf = new StringBuffer();
        buf.append("interface ");
        buf.append(cls.name());
        boolean first = true;
        Iterator itr = cls._implements();
        while (itr.hasNext()) {
            if (first) {
                buf.append(" extends ");
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(this.printName((JClass)itr.next()));
        }
        buf.append(" {");
        this.println(buf.toString());
        ++this.indent;
        FieldUse[] fu = ci.getDeclaredFieldUses();
        int i = 0;
        while (i < fu.length) {
            String type = !fu[i].multiplicity.isAtMostOnce() ? "List<" + this.printName(fu[i].type) + ">" : this.printName(fu[i].type);
            this.println(type + " " + fu[i].name + ";");
            ++i;
        }
        this.dumpChildren(cls);
        --this.indent;
        this.println("}");
    }

    private String printName(JType t) {
        String name = t.fullName();
        if (name.startsWith("java.lang.")) {
            name = name.substring(10);
        }
        return name;
    }
}

