/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom3.UserDataHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class NodeImpl
implements Node,
NodeList,
EventTarget,
Cloneable,
Serializable {
    public static final short TREE_POSITION_PRECEDING = 1;
    public static final short TREE_POSITION_FOLLOWING = 2;
    public static final short TREE_POSITION_ANCESTOR = 4;
    public static final short TREE_POSITION_DESCENDANT = 8;
    public static final short TREE_POSITION_EQUIVALENT = 16;
    public static final short TREE_POSITION_SAME_NODE = 32;
    public static final short TREE_POSITION_DISCONNECTED = 0;
    static final long serialVersionUID = -6316591992167219696L;
    public static final short ELEMENT_DEFINITION_NODE = -1;
    protected NodeImpl ownerNode;
    protected short flags;
    protected static final short READONLY = 1;
    protected static final short SYNCDATA = 2;
    protected static final short SYNCCHILDREN = 4;
    protected static final short OWNED = 8;
    protected static final short FIRSTCHILD = 16;
    protected static final short SPECIFIED = 32;
    protected static final short IGNORABLEWS = 64;
    protected static final short HASSTRING = 128;
    protected static final short UNNORMALIZED = 256;
    protected static final short IDATTRIBUTE = 512;

    protected NodeImpl(CoreDocumentImpl ownerDocument) {
        this.ownerNode = ownerDocument;
    }

    public NodeImpl() {
    }

    public abstract short getNodeType();

    public abstract String getNodeName();

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String x) throws DOMException {
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.insertBefore(newChild, null);
    }

    public Node cloneNode(boolean deep) {
        NodeImpl newnode;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        try {
            newnode = (NodeImpl)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("**Internal Error**" + e);
        }
        newnode.ownerNode = this.ownerDocument();
        newnode.isOwned(false);
        newnode.isReadOnly(false);
        this.ownerDocument().callUserDataHandlers(this, newnode, (short)1);
        return newnode;
    }

    public Document getOwnerDocument() {
        if (this.isOwned()) {
            return this.ownerNode.ownerDocument();
        }
        return (Document)((Object)this.ownerNode);
    }

    CoreDocumentImpl ownerDocument() {
        if (this.isOwned()) {
            return this.ownerNode.ownerDocument();
        }
        return (CoreDocumentImpl)this.ownerNode;
    }

    void setOwnerDocument(CoreDocumentImpl doc) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (!this.isOwned()) {
            this.ownerNode = doc;
        }
    }

    public Node getParentNode() {
        return null;
    }

    NodeImpl parentNode() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    ChildNode previousSibling() {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
    }

    public Node removeChild(Node oldChild) throws DOMException {
        throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
    }

    public int getLength() {
        return 0;
    }

    public Node item(int index) {
        return null;
    }

    public void normalize() {
    }

    public boolean isSupported(String feature, String version) {
        return this.ownerDocument().getImplementation().hasFeature(feature, version);
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String prefix) throws DOMException {
        throw new DOMException(14, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null));
    }

    public String getLocalName() {
        return null;
    }

    public void addEventListener(String type, EventListener listener, boolean useCapture) {
        this.ownerDocument().addEventListener(this, type, listener, useCapture);
    }

    public void removeEventListener(String type, EventListener listener, boolean useCapture) {
        this.ownerDocument().removeEventListener(this, type, listener, useCapture);
    }

    public boolean dispatchEvent(Event event) {
        return this.ownerDocument().dispatchEvent(this, event);
    }

    public String getBaseURI() {
        return null;
    }

    public short compareTreePosition(Node other) {
        int i;
        if (this == other) {
            return 48;
        }
        short thisType = this.getNodeType();
        short otherType = other.getNodeType();
        if (thisType == 6 || thisType == 12 || otherType == 6 || otherType == 12) {
            return 0;
        }
        Node thisAncestor = this;
        Node otherAncestor = other;
        int thisDepth = 0;
        int otherDepth = 0;
        Node node = this;
        while (node != null) {
            ++thisDepth;
            if (node == other) {
                return 5;
            }
            thisAncestor = node;
            node = node.getParentNode();
        }
        node = other;
        while (node != null) {
            ++otherDepth;
            if (node == this) {
                return 10;
            }
            otherAncestor = node;
            node = node.getParentNode();
        }
        Node thisNode = this;
        Node otherNode = other;
        short thisAncestorType = thisAncestor.getNodeType();
        short otherAncestorType = otherAncestor.getNodeType();
        if (thisAncestorType == 2) {
            thisNode = ((AttrImpl)thisAncestor).getOwnerElement();
        }
        if (otherAncestorType == 2) {
            otherNode = ((AttrImpl)otherAncestor).getOwnerElement();
        }
        if (thisAncestorType == 2 && otherAncestorType == 2 && thisNode == otherNode) {
            return 16;
        }
        if (thisAncestorType == 2) {
            thisDepth = 0;
            node = thisNode;
            while (node != null) {
                ++thisDepth;
                if (node == otherNode) {
                    return 1;
                }
                thisAncestor = node;
                node = node.getParentNode();
            }
        }
        if (otherAncestorType == 2) {
            otherDepth = 0;
            node = otherNode;
            while (node != null) {
                ++otherDepth;
                if (node == thisNode) {
                    return 2;
                }
                otherAncestor = node;
                node = node.getParentNode();
            }
        }
        if (thisAncestor != otherAncestor) {
            return 0;
        }
        if (thisDepth > otherDepth) {
            i = 0;
            while (i < thisDepth - otherDepth) {
                thisNode = thisNode.getParentNode();
                ++i;
            }
            if (thisNode == otherNode) {
                return 1;
            }
        } else {
            i = 0;
            while (i < otherDepth - thisDepth) {
                otherNode = otherNode.getParentNode();
                ++i;
            }
            if (otherNode == thisNode) {
                return 2;
            }
        }
        Node thisNodeP = thisNode.getParentNode();
        Node otherNodeP = otherNode.getParentNode();
        while (thisNodeP != otherNodeP) {
            thisNode = thisNodeP;
            otherNode = otherNodeP;
            thisNodeP = thisNodeP.getParentNode();
            otherNodeP = otherNodeP.getParentNode();
        }
        Node current = thisNodeP.getFirstChild();
        while (current != null) {
            if (current == otherNode) {
                return 1;
            }
            if (current == thisNode) {
                return 2;
            }
            current = current.getNextSibling();
        }
        return 0;
    }

    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    void getTextContent(StringBuffer buf) throws DOMException {
        String content = this.getNodeValue();
        if (content != null) {
            buf.append(content);
        }
    }

    public void setTextContent(String textContent) throws DOMException {
        this.setNodeValue(textContent);
    }

    public boolean isSameNode(Node other) {
        return this == other;
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        short type = this.getNodeType();
        switch (type) {
            case 1: {
                ElementImpl elem;
                NodeImpl attr;
                String namespace = this.getNamespaceURI();
                String prefix = this.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    if (namespaceURI == null) {
                        return namespace == namespaceURI;
                    }
                    return namespaceURI.equals(namespace);
                }
                if (this.hasAttributes() && (attr = (NodeImpl)((Object)(elem = (ElementImpl)this).getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns"))) != null) {
                    String value = attr.getNodeValue();
                    if (namespaceURI == null) {
                        return namespace == value;
                    }
                    return namespaceURI.equals(value);
                }
                NodeImpl ancestor = (NodeImpl)this.getElementAncestor(this);
                if (ancestor != null) {
                    return ancestor.isDefaultNamespace(namespaceURI);
                }
                return false;
            }
            case 9: {
                return ((NodeImpl)((Object)((Document)((Object)this)).getDocumentElement())).isDefaultNamespace(namespaceURI);
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
            case 2: {
                if (this.ownerNode.getNodeType() == 1) {
                    return this.ownerNode.isDefaultNamespace(namespaceURI);
                }
                return false;
            }
        }
        NodeImpl ancestor = (NodeImpl)this.getElementAncestor(this);
        if (ancestor != null) {
            return ancestor.isDefaultNamespace(namespaceURI);
        }
        return false;
    }

    public String lookupNamespacePrefix(String namespaceURI, boolean useDefault) {
        if (namespaceURI == null) {
            return null;
        }
        short type = this.getNodeType();
        switch (type) {
            case 1: {
                String namespace = this.getNamespaceURI();
                return this.lookupNamespacePrefix(namespaceURI, useDefault, (ElementImpl)this);
            }
            case 9: {
                return ((NodeImpl)((Object)((Document)((Object)this)).getDocumentElement())).lookupNamespacePrefix(namespaceURI, useDefault);
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                if (this.ownerNode.getNodeType() == 1) {
                    return this.ownerNode.lookupNamespacePrefix(namespaceURI, useDefault);
                }
                return null;
            }
        }
        NodeImpl ancestor = (NodeImpl)this.getElementAncestor(this);
        if (ancestor != null) {
            return ancestor.lookupNamespacePrefix(namespaceURI, useDefault);
        }
        return null;
    }

    public String lookupNamespaceURI(String specifiedPrefix) {
        short type = this.getNodeType();
        switch (type) {
            case 1: {
                NodeImpl ancestor;
                String namespace = this.getNamespaceURI();
                String prefix = this.getPrefix();
                if (namespace != null) {
                    if (specifiedPrefix == null && prefix == specifiedPrefix) {
                        return namespace;
                    }
                    if (prefix != null && prefix.equals(specifiedPrefix)) {
                        return namespace;
                    }
                }
                if (this.hasAttributes()) {
                    NamedNodeMap map = this.getAttributes();
                    int length = map.getLength();
                    int i = 0;
                    while (i < length) {
                        Node attr = map.item(i);
                        String attrPrefix = attr.getPrefix();
                        String value = attr.getNodeValue();
                        namespace = attr.getNamespaceURI();
                        if (namespace != null && namespace.equals("http://www.w3.org/2000/xmlns/")) {
                            if (specifiedPrefix == null && attr.getNodeName().equals("xmlns")) {
                                return value;
                            }
                            if (attrPrefix != null && attrPrefix.equals("xmlns") && attr.getLocalName().equals(specifiedPrefix)) {
                                return value;
                            }
                        }
                        ++i;
                    }
                }
                if ((ancestor = (NodeImpl)this.getElementAncestor(this)) != null) {
                    return ancestor.lookupNamespaceURI(specifiedPrefix);
                }
                return null;
            }
            case 9: {
                return ((NodeImpl)((Object)((Document)((Object)this)).getDocumentElement())).lookupNamespaceURI(specifiedPrefix);
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                if (this.ownerNode.getNodeType() == 1) {
                    return this.ownerNode.lookupNamespaceURI(specifiedPrefix);
                }
                return null;
            }
        }
        NodeImpl ancestor = (NodeImpl)this.getElementAncestor(this);
        if (ancestor != null) {
            return ancestor.lookupNamespaceURI(specifiedPrefix);
        }
        return null;
    }

    Node getElementAncestor(Node currentNode) {
        Node parent = currentNode.getParentNode();
        if (parent != null) {
            short type = parent.getNodeType();
            if (type == 1) {
                return parent;
            }
            return this.getElementAncestor(parent);
        }
        return null;
    }

    String lookupNamespacePrefix(String namespaceURI, boolean useDefault, ElementImpl el) {
        NodeImpl ancestor;
        String foundNamespace;
        String namespace = this.getNamespaceURI();
        String prefix = this.getPrefix();
        if (namespace != null && namespace.equals(namespaceURI) && (useDefault || prefix != null) && (foundNamespace = el.lookupNamespaceURI(prefix)) != null && foundNamespace.equals(namespaceURI)) {
            return prefix;
        }
        if (this.hasAttributes()) {
            NamedNodeMap map = this.getAttributes();
            int length = map.getLength();
            int i = 0;
            while (i < length) {
                String localname;
                String foundNamespace2;
                Node attr = map.item(i);
                String attrPrefix = attr.getPrefix();
                String value = attr.getNodeValue();
                namespace = attr.getNamespaceURI();
                if (namespace != null && namespace.equals("http://www.w3.org/2000/xmlns/") && (useDefault && attr.getNodeName().equals("xmlns") || attrPrefix != null && attrPrefix.equals("xmlns") && value.equals(namespaceURI)) && (foundNamespace2 = el.lookupNamespaceURI(localname = attr.getLocalName())) != null && foundNamespace2.equals(namespaceURI)) {
                    return localname;
                }
                ++i;
            }
        }
        if ((ancestor = (NodeImpl)this.getElementAncestor(this)) != null) {
            return ancestor.lookupNamespacePrefix(namespaceURI, useDefault, el);
        }
        return null;
    }

    public boolean isEqualNode(Node arg) {
        if (arg == this) {
            return true;
        }
        if (arg.getNodeType() != this.getNodeType()) {
            return false;
        }
        if (this.getNodeName() == null ? arg.getNodeName() != null : !this.getNodeName().equals(arg.getNodeName())) {
            return false;
        }
        if (this.getLocalName() == null ? arg.getLocalName() != null : !this.getLocalName().equals(arg.getLocalName())) {
            return false;
        }
        if (this.getNamespaceURI() == null ? arg.getNamespaceURI() != null : !this.getNamespaceURI().equals(arg.getNamespaceURI())) {
            return false;
        }
        if (this.getPrefix() == null ? arg.getPrefix() != null : !this.getPrefix().equals(arg.getPrefix())) {
            return false;
        }
        if (this.getNodeValue() == null ? arg.getNodeValue() != null : !this.getNodeValue().equals(arg.getNodeValue())) {
            return false;
        }
        return !(this.getBaseURI() == null ? ((NodeImpl)arg).getBaseURI() != null : !this.getBaseURI().equals(((NodeImpl)arg).getBaseURI()));
    }

    public Node getInterface(String feature) {
        return this.isSupported(feature, null) ? this : null;
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.ownerDocument().setUserData(this, key, data, handler);
    }

    public Object getUserData(String key) {
        return this.ownerDocument().getUserData(this, key);
    }

    public void setReadOnly(boolean readOnly, boolean deep) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isReadOnly(readOnly);
    }

    public boolean getReadOnly() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.isReadOnly();
    }

    public void setUserData(Object data) {
        this.ownerDocument().setUserData(this, data);
    }

    public Object getUserData() {
        return this.ownerDocument().getUserData(this);
    }

    protected void changed() {
        this.ownerDocument().changed();
    }

    protected int changes() {
        return this.ownerDocument().changes();
    }

    protected void synchronizeData() {
        this.needsSyncData(false);
    }

    final boolean isReadOnly() {
        return (this.flags & 1) != 0;
    }

    final void isReadOnly(boolean value) {
        this.flags = value ? (short)(this.flags | 1) : (short)(this.flags & 0xFFFFFFFE);
    }

    final boolean needsSyncData() {
        return (this.flags & 2) != 0;
    }

    final void needsSyncData(boolean value) {
        this.flags = value ? (short)(this.flags | 2) : (short)(this.flags & 0xFFFFFFFD);
    }

    final boolean needsSyncChildren() {
        return (this.flags & 4) != 0;
    }

    public final void needsSyncChildren(boolean value) {
        this.flags = value ? (short)(this.flags | 4) : (short)(this.flags & 0xFFFFFFFB);
    }

    final boolean isOwned() {
        return (this.flags & 8) != 0;
    }

    final void isOwned(boolean value) {
        this.flags = value ? (short)(this.flags | 8) : (short)(this.flags & 0xFFFFFFF7);
    }

    final boolean isFirstChild() {
        return (this.flags & 0x10) != 0;
    }

    final void isFirstChild(boolean value) {
        this.flags = value ? (short)(this.flags | 0x10) : (short)(this.flags & 0xFFFFFFEF);
    }

    final boolean isSpecified() {
        return (this.flags & 0x20) != 0;
    }

    final void isSpecified(boolean value) {
        this.flags = value ? (short)(this.flags | 0x20) : (short)(this.flags & 0xFFFFFFDF);
    }

    final boolean internalIsIgnorableWhitespace() {
        return (this.flags & 0x40) != 0;
    }

    final void isIgnorableWhitespace(boolean value) {
        this.flags = value ? (short)(this.flags | 0x40) : (short)(this.flags & 0xFFFFFFBF);
    }

    final boolean hasStringValue() {
        return (this.flags & 0x80) != 0;
    }

    final void hasStringValue(boolean value) {
        this.flags = value ? (short)(this.flags | 0x80) : (short)(this.flags & 0xFFFFFF7F);
    }

    final boolean isNormalized() {
        return (this.flags & 0x100) == 0;
    }

    final void isNormalized(boolean value) {
        if (!value && this.isNormalized() && this.ownerNode != null) {
            this.ownerNode.isNormalized(false);
        }
        this.flags = value ? (short)(this.flags & 0xFFFFFEFF) : (short)(this.flags | 0x100);
    }

    final boolean isIdAttribute() {
        return (this.flags & 0x200) != 0;
    }

    final void isIdAttribute(boolean value) {
        this.flags = value ? (short)(this.flags | 0x200) : (short)(this.flags & 0xFFFFFDFF);
    }

    public String toString() {
        return "[" + this.getNodeName() + ": " + this.getNodeValue() + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        out.defaultWriteObject();
    }
}

