/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.psvi.XSAnnotation;
import org.apache.xerces.impl.xs.psvi.XSAttributeGroupDefinition;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSWildcard;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;

public class XSAttributeGroupDecl
implements XSAttributeGroupDefinition {
    public String fName = null;
    public String fTargetNamespace = null;
    int fAttrUseNum = 0;
    private static final int INITIAL_SIZE = 5;
    XSAttributeUseImpl[] fAttributeUses = new XSAttributeUseImpl[5];
    public XSWildcardDecl fAttributeWC = null;
    public String fIDAttrName = null;

    public String addAttributeUse(XSAttributeUseImpl attrUse) {
        if (this.fAttrUseNum == this.fAttributeUses.length) {
            this.fAttributeUses = XSAttributeGroupDecl.resize(this.fAttributeUses, this.fAttrUseNum * 2);
        }
        this.fAttributeUses[this.fAttrUseNum++] = attrUse;
        if (attrUse.fUse == 2) {
            return null;
        }
        if (attrUse.fAttrDecl.fType.isIDType()) {
            if (this.fIDAttrName == null) {
                this.fIDAttrName = attrUse.fAttrDecl.fName;
            } else {
                return this.fIDAttrName;
            }
        }
        return null;
    }

    public XSAttributeUseImpl getAttributeUse(String uri, String localpart) {
        int i = 0;
        while (i < this.fAttrUseNum) {
            if (this.fAttributeUses[i].fAttrDecl.fTargetNamespace == uri && this.fAttributeUses[i].fAttrDecl.fName == localpart) {
                return this.fAttributeUses[i];
            }
            ++i;
        }
        return null;
    }

    public void removeProhibitedAttrs() {
        if (this.fAttrUseNum == 0) {
            return;
        }
        int pCount = 0;
        XSAttributeUseImpl[] pUses = new XSAttributeUseImpl[this.fAttrUseNum];
        int i = 0;
        while (i < this.fAttrUseNum) {
            if (this.fAttributeUses[i].fUse == 2) {
                pUses[this.fAttrUseNum - ++pCount] = this.fAttributeUses[i];
            }
            ++i;
        }
        int newCount = 0;
        if (pCount > 0) {
            int i2 = 0;
            while (i2 < this.fAttrUseNum) {
                block8: {
                    if (this.fAttributeUses[i2].fUse != 2) {
                        int j = 1;
                        while (j <= pCount) {
                            if (this.fAttributeUses[i2].fAttrDecl.fName != pUses[this.fAttrUseNum - pCount].fAttrDecl.fName || this.fAttributeUses[i2].fAttrDecl.fTargetNamespace != pUses[this.fAttrUseNum - pCount].fAttrDecl.fTargetNamespace) {
                                ++j;
                                continue;
                            }
                            break block8;
                        }
                        pUses[newCount++] = this.fAttributeUses[i2];
                    }
                }
                ++i2;
            }
            this.fAttributeUses = pUses;
            this.fAttrUseNum = newCount;
        }
    }

    public String validRestrictionOf(XSAttributeGroupDecl baseGroup) {
        String errorCode = null;
        XSAttributeUseImpl attrUse = null;
        XSAttributeDecl attrDecl = null;
        XSAttributeUseImpl baseAttrUse = null;
        XSAttributeDecl baseAttrDecl = null;
        int i = 0;
        while (i < this.fAttrUseNum) {
            attrUse = this.fAttributeUses[i];
            attrDecl = attrUse.fAttrDecl;
            baseAttrUse = baseGroup.getAttributeUse(attrDecl.fTargetNamespace, attrDecl.fName);
            if (baseAttrUse != null) {
                if (baseAttrUse.fUse == 1 && attrUse.fUse != 1) {
                    errorCode = "derivation-ok-restriction.2.1.1";
                    return errorCode;
                }
                if (attrUse.fUse != 2) {
                    short thisConstType;
                    baseAttrDecl = baseAttrUse.fAttrDecl;
                    if (!XSConstraints.checkSimpleDerivationOk(attrDecl.fType, baseAttrDecl.fType, baseAttrDecl.fType.getFinal())) {
                        errorCode = "derivation-ok-restriction.2.1.2";
                        return errorCode;
                    }
                    short baseConsType = baseAttrUse.fConstraintType != 0 ? baseAttrUse.fConstraintType : baseAttrDecl.getConstraintType();
                    short s = thisConstType = attrUse.fConstraintType != 0 ? attrUse.fConstraintType : attrDecl.getConstraintType();
                    if (baseConsType == 2) {
                        ValidatedInfo thisFixedValue;
                        if (thisConstType != 2) {
                            errorCode = "derivation-ok-restriction.2.1.3";
                            return errorCode;
                        }
                        ValidatedInfo baseFixedValue = baseAttrUse.fDefault != null ? baseAttrUse.fDefault : baseAttrDecl.fDefault;
                        ValidatedInfo validatedInfo = thisFixedValue = attrUse.fDefault != null ? attrUse.fDefault : attrDecl.fDefault;
                        if (!baseFixedValue.actualValue.equals(thisFixedValue.actualValue)) {
                            errorCode = "derivation-ok-restriction.2.1.3";
                            return errorCode;
                        }
                    }
                }
            } else if (baseGroup.fAttributeWC == null || !baseGroup.fAttributeWC.allowNamespace(attrDecl.fTargetNamespace)) {
                errorCode = "derivation-ok-restriction.2.2";
                return errorCode;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < baseGroup.fAttrUseNum) {
            baseAttrUse = baseGroup.fAttributeUses[i2];
            if (baseAttrUse.fUse == 1) {
                baseAttrDecl = baseAttrUse.fAttrDecl;
                XSAttributeUseImpl thisAttrUse = this.getAttributeUse(baseAttrDecl.fTargetNamespace, baseAttrDecl.fName);
                if (thisAttrUse == null) {
                    errorCode = "derivation-ok-restriction.3";
                    return errorCode;
                }
            }
            ++i2;
        }
        if (this.fAttributeWC != null) {
            if (baseGroup.fAttributeWC == null) {
                errorCode = "derivation-ok-restriction.4";
                return errorCode;
            }
            if (!this.fAttributeWC.isSubsetOf(baseGroup.fAttributeWC)) {
                errorCode = "derivation-ok-restriction.4";
                return errorCode;
            }
        }
        return null;
    }

    static final XSAttributeUseImpl[] resize(XSAttributeUseImpl[] oldArray, int newSize) {
        XSAttributeUseImpl[] newArray = new XSAttributeUseImpl[newSize];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newSize));
        return newArray;
    }

    public void reset() {
        this.fName = null;
        this.fTargetNamespace = null;
        int i = 0;
        while (i < this.fAttrUseNum) {
            this.fAttributeUses[i] = null;
            ++i;
        }
        this.fAttrUseNum = 0;
        this.fAttributeWC = null;
        this.fIDAttrName = null;
    }

    public short getType() {
        return 5;
    }

    public String getName() {
        return this.fName;
    }

    public String getNamespace() {
        return this.fTargetNamespace;
    }

    public XSObjectList getAttributeUses() {
        return new XSObjectListImpl(this.fAttributeUses, this.fAttrUseNum);
    }

    public XSWildcard getAttributeWildcard() {
        return this.fAttributeWC;
    }

    public XSAnnotation getAnnotation() {
        return null;
    }
}

