/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.StringReader;
import java.util.Stack;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.util.DOMEntityResolverWrapper;
import org.apache.xerces.util.DOMErrorHandlerWrapper;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMBuilder;
import org.w3c.dom.ls.DOMBuilderFilter;
import org.w3c.dom.ls.DOMEntityResolver;
import org.w3c.dom.ls.DOMInputSource;

public class DOMBuilderImpl
extends AbstractDOMParser
implements DOMBuilder {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String XMLSCHEMA = "http://apache.org/xml/features/validation/schema";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String XML_SCHEMA_VALIDATION = "http://www.w3.org/2001/XMLSchema";
    protected static final String DTD_VALIDATION = "http://www.w3.org/TR/REC-xml";
    protected String fSchemaType = "http://www.w3.org/2001/XMLSchema";
    protected static final boolean DEBUG = false;
    protected DOMErrorHandlerWrapper fErrorHandler = null;

    public DOMBuilderImpl(String configuration, String schemaType) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", configuration));
        this.fSchemaType = schemaType;
    }

    public DOMBuilderImpl(XMLParserConfiguration config) {
        super(config);
        String[] domRecognizedFeatures = new String[]{"canonical-form", "cdata-sections", "charset-overrides-xml-encoding", "infoset", "namespace-declarations", "supported-mediatypes-only"};
        this.fConfiguration.addRecognizedFeatures(domRecognizedFeatures);
        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        this.fConfiguration.setFeature("canonical-form", false);
        this.fConfiguration.setFeature("cdata-sections", true);
        this.fConfiguration.setFeature("charset-overrides-xml-encoding", true);
        this.fConfiguration.setFeature("infoset", false);
        this.fConfiguration.setFeature("namespace-declarations", true);
        this.fConfiguration.setFeature("supported-mediatypes-only", false);
        this.fConfiguration.setFeature(NORMALIZE_DATA, false);
    }

    public DOMBuilderImpl(SymbolTable symbolTable) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.IntegratedParserConfiguration"));
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/symbol-table", symbolTable);
    }

    public DOMBuilderImpl(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.StandardParserConfiguration"));
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/symbol-table", symbolTable);
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", grammarPool);
    }

    public void reset() {
        super.reset();
        if (this.fSkippedElemStack != null) {
            this.fSkippedElemStack.removeAllElements();
        }
        this.fRejectedElement.clear();
        this.fFilterReject = false;
    }

    public DOMEntityResolver getEntityResolver() {
        DOMEntityResolver domEntityResolver = null;
        try {
            DOMEntityResolver entityResolver = (DOMEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
            if (entityResolver != null && entityResolver instanceof DOMEntityResolverWrapper) {
                domEntityResolver = ((DOMEntityResolverWrapper)entityResolver).getEntityResolver();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return domEntityResolver;
    }

    public void setEntityResolver(DOMEntityResolver entityResolver) {
        try {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new DOMEntityResolverWrapper(entityResolver));
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public DOMErrorHandler getErrorHandler() {
        if (this.fErrorHandler != null) {
            return this.fErrorHandler.getErrorHandler();
        }
        return null;
    }

    public void setErrorHandler(DOMErrorHandler errorHandler) {
        try {
            this.fErrorHandler = new DOMErrorHandlerWrapper(errorHandler);
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", this.fErrorHandler);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public DOMBuilderFilter getFilter() {
        return this.fDOMFilter;
    }

    public void setFilter(DOMBuilderFilter filter) {
        this.fDOMFilter = filter;
        if (this.fSkippedElemStack == null) {
            this.fSkippedElemStack = new Stack();
        }
    }

    public void setFeature(String name, boolean state) throws DOMException {
        try {
            if (name.equals("comments")) {
                this.fConfiguration.setFeature("http://apache.org/xml/features/include-comments", state);
            } else if (name.equals("datatype-normalization")) {
                this.fConfiguration.setFeature(NORMALIZE_DATA, state);
            } else if (name.equals("entities")) {
                this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", state);
            } else if (name.equals("infoset") || name.equals("supported-mediatypes-only") || name.equals("canonical-form")) {
                if (state) {
                    throw new DOMException(9, "Feature \"" + name + "\" cannot be set to \"" + state + "\"");
                }
            } else if (name.equals("namespaces")) {
                this.fConfiguration.setFeature(NAMESPACES, state);
            } else if (name.equals("cdata-sections") || name.equals("namespace-declarations")) {
                if (!state) {
                    throw new DOMException(9, "Feature \"" + name + "\" cannot be set to \"" + state + "\"");
                }
            } else if (name.equals("validate")) {
                this.fConfiguration.setFeature(VALIDATION_FEATURE, state);
                if (this.fSchemaType == null || this.fSchemaType.equals(XML_SCHEMA_VALIDATION)) {
                    this.fConfiguration.setFeature(XMLSCHEMA, state);
                }
            } else if (name.equals("validate-if-schema")) {
                this.fConfiguration.setFeature(DYNAMIC_VALIDATION, state);
            } else if (name.equals("whitespace-in-element-content")) {
                this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", state);
            } else {
                this.fConfiguration.setFeature(name, state);
            }
        }
        catch (XMLConfigurationException e) {
            throw new DOMException(8, "Feature \"" + name + "\" not recognized");
        }
    }

    public boolean canSetFeature(String name, boolean state) {
        if (name.equals("infoset") || name.equals("supported-mediatypes-only") || name.equals("canonical-form")) {
            return !state;
        }
        if (name.equals("cdata-sections") || name.equals("namespace-declarations")) {
            return state;
        }
        if (name.equals("charset-overrides-xml-encoding") || name.equals("comments") || name.equals("datatype-normalization") || name.equals("entities") || name.equals("namespaces") || name.equals("validate") || name.equals("validate-if-schema") || name.equals("whitespace-in-element-content")) {
            return true;
        }
        try {
            this.fConfiguration.getFeature(name);
            return true;
        }
        catch (XMLConfigurationException e) {
            return false;
        }
    }

    public boolean getFeature(String name) throws DOMException {
        if (name.equals("comments")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/include-comments");
        }
        if (name.equals("datatype-normalization")) {
            return this.fConfiguration.getFeature(NORMALIZE_DATA);
        }
        if (name.equals("entities")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes");
        }
        if (name.equals("namespaces")) {
            return this.fConfiguration.getFeature(NAMESPACES);
        }
        if (name.equals("validate")) {
            return this.fConfiguration.getFeature(VALIDATION_FEATURE);
        }
        if (name.equals("validate-if-schema")) {
            return this.fConfiguration.getFeature(DYNAMIC_VALIDATION);
        }
        if (name.equals("whitespace-in-element-content")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace");
        }
        if (name.equals("namespace-declarations") || name.equals("cdata-sections") || name.equals("canonical-form") || name.equals("supported-mediatypes-only") || name.equals("infoset") || name.equals("charset-overrides-xml-encoding")) {
            return this.fConfiguration.getFeature(name);
        }
        throw new DOMException(8, "Feature \"" + name + "\" not recognized");
    }

    public Document parseURI(String uri) {
        block2: {
            XMLInputSource source = new XMLInputSource(null, uri, null);
            try {
                this.parse(source);
            }
            catch (Exception e) {
                if (this.fErrorHandler == null) break block2;
                DOMErrorImpl error = new DOMErrorImpl();
                error.fException = e;
                error.fMessage = e.getMessage();
                error.fSeverity = 1;
                this.fErrorHandler.getErrorHandler().handleError(error);
            }
        }
        return this.getDocument();
    }

    public Document parse(DOMInputSource is) {
        block2: {
            XMLInputSource xmlInputSource = this.dom2xmlInputSource(is);
            try {
                this.parse(xmlInputSource);
            }
            catch (Exception e) {
                if (this.fErrorHandler == null) break block2;
                DOMErrorImpl error = new DOMErrorImpl();
                error.fException = e;
                error.fMessage = e.getMessage();
                error.fSeverity = 1;
                this.fErrorHandler.getErrorHandler().handleError(error);
            }
        }
        return this.getDocument();
    }

    public void parseWithContext(DOMInputSource is, Node cnode, short action) throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    XMLInputSource dom2xmlInputSource(DOMInputSource is) {
        XMLInputSource xis = null;
        xis = is.getStringData() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), new StringReader(is.getStringData()), "UTF-16") : (is.getCharacterStream() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getCharacterStream(), "UTF-16") : (is.getByteStream() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getByteStream(), is.getEncoding()) : new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI())));
        return xis;
    }

    public void endDocument(Augmentations augs) throws XNIException {
        super.endDocument(augs);
        if (this.fDocumentImpl != null) {
            this.fDocumentImpl.copyConfigurationProperties(this.fConfiguration);
        }
    }

    public void setProperty(String propertyId, Object value) throws DOMException {
        try {
            this.fConfiguration.setProperty(propertyId, value);
        }
        catch (XMLConfigurationException e) {
            String message = e.getMessage();
            if (e.getType() == 0) {
                throw new DOMException(8, message);
            }
            throw new DOMException(9, message);
        }
    }
}

