/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Hashtable;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMWriter;
import org.w3c.dom.ls.DOMWriterFilter;

public class DOMWriterImpl
implements DOMWriter {
    private String fEncoding;
    private XMLSerializer serializer = new XMLSerializer();

    public DOMWriterImpl(boolean namespaces) {
        this.serializer.fNamespaces = namespaces;
        this.serializer.fNSBinder = new NamespaceSupport();
        this.serializer.fLocalNSBinder = new NamespaceSupport();
        this.serializer.fSymbolTable = new SymbolTable();
        this.serializer.fFeatures = new Hashtable();
        this.serializer.fFeatures.put("normalize-characters", new Boolean(false));
        this.serializer.fFeatures.put("split-cdata-sections", new Boolean(true));
        this.serializer.fFeatures.put("validate", new Boolean(false));
        this.serializer.fFeatures.put("entities", new Boolean(false));
        this.serializer.fFeatures.put("whitespace-in-element-content", new Boolean(true));
        this.serializer.fFeatures.put("discard-default-content", new Boolean(true));
        this.serializer.fFeatures.put("canonical-form", new Boolean(false));
        this.serializer.fFeatures.put("format-pretty-print", new Boolean(false));
    }

    public void setFeature(String name, boolean state) throws DOMException {
        if (name != null && this.serializer.fFeatures.containsKey(name)) {
            if (!this.canSetFeature(name, state)) {
                throw new DOMException(9, "Feature " + name + " cannot be set as " + state);
            }
        } else {
            throw new DOMException(8, "Feature " + name + " not found");
        }
        this.serializer.fFeatures.put(name, new Boolean(state));
    }

    public boolean canSetFeature(String name, boolean state) {
        if (name.equals("normalize-characters") && state) {
            return false;
        }
        if (name.equals("validate") && state) {
            return false;
        }
        if (name.equals("whitespace-in-element-content") && !state) {
            return false;
        }
        if (name.equals("canonical-form") && state) {
            return false;
        }
        return !name.equals("format-pretty-print") || !state;
    }

    public boolean getFeature(String name) throws DOMException {
        Boolean state = (Boolean)this.serializer.fFeatures.get(name);
        if (state == null) {
            throw new DOMException(8, "Feature " + name + " not found");
        }
        return state;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String encoding) {
        this.serializer._format.setEncoding(encoding);
        this.fEncoding = this.serializer._format.getEncoding();
    }

    public DOMErrorHandler getErrorHandler() {
        return this.serializer.fDOMErrorHandler;
    }

    public void setErrorHandler(DOMErrorHandler errorHandler) {
        this.serializer.fDOMErrorHandler = errorHandler;
    }

    public boolean writeNode(OutputStream destination, Node wnode) {
        block6: {
            this.checkAllFeatures();
            try {
                this.reset();
                this.serializer.setOutputByteStream(destination);
                if (wnode == null) {
                    return false;
                }
                if (wnode.getNodeType() == 9) {
                    this.serializer.serialize((Document)wnode);
                    break block6;
                }
                if (wnode.getNodeType() == 11) {
                    this.serializer.serialize((DocumentFragment)wnode);
                    break block6;
                }
                if (wnode.getNodeType() == 1) {
                    this.serializer.serialize((Element)wnode);
                    break block6;
                }
                return false;
            }
            catch (Exception e) {
                if (this.serializer.fDOMErrorHandler == null) break block6;
                DOMErrorImpl error = new DOMErrorImpl();
                error.fException = e;
                error.fMessage = e.getMessage();
                error.fSeverity = 1;
                this.serializer.fDOMErrorHandler.handleError(error);
            }
        }
        return true;
    }

    public String writeToString(Node wnode) throws DOMException {
        StringWriter destination;
        block6: {
            this.checkAllFeatures();
            destination = new StringWriter();
            try {
                this.reset();
                this.serializer.setOutputCharStream(destination);
                if (wnode == null) {
                    return null;
                }
                if (wnode.getNodeType() == 9) {
                    this.serializer.serialize((Document)wnode);
                    break block6;
                }
                if (wnode.getNodeType() == 11) {
                    this.serializer.serialize((DocumentFragment)wnode);
                    break block6;
                }
                if (wnode.getNodeType() == 1) {
                    this.serializer.serialize((Element)wnode);
                    break block6;
                }
                return null;
            }
            catch (IOException ioe) {
                throw new DOMException(2, "The resulting string is too long to fit in a DOMString: " + ioe.getMessage());
            }
        }
        return destination.toString();
    }

    public void setNewLine(String newLine) {
        this.serializer._format.setLineSeparator(newLine);
    }

    public String getNewLine() {
        return this.serializer._format.getLineSeparator();
    }

    public DOMWriterFilter getFilter() {
        return null;
    }

    public void setFilter(DOMWriterFilter filter) {
        this.serializer.fDOMFilter = filter;
    }

    private boolean reset() {
        this.serializer.reset();
        this.serializer.fNSBinder.reset();
        this.serializer.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        this.serializer.fNamespaceCounter = 1;
        return true;
    }

    private void checkAllFeatures() {
        if (this.getFeature("whitespace-in-element-content")) {
            this.serializer._format.setPreserveSpace(true);
        } else {
            this.serializer._format.setPreserveSpace(false);
        }
    }
}

