/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.helpers;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.bind.helpers.Messages;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractUnmarshallerImpl
implements Unmarshaller {
    private ValidationEventHandler eventHandler = new DefaultValidationEventHandler();
    private boolean validating = false;
    private XMLReader reader = null;

    protected XMLReader getXMLReader() throws JAXBException {
        if (this.reader == null) {
            try {
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setNamespaceAware(true);
                parserFactory.setValidating(false);
                this.reader = parserFactory.newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException e) {
                throw new JAXBException(e);
            }
            catch (SAXException e) {
                throw new JAXBException(e);
            }
        }
        return this.reader;
    }

    public Object unmarshal(Source source) throws JAXBException {
        if (source == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "source"));
        }
        if (source instanceof SAXSource) {
            return this.unmarshal((SAXSource)source);
        }
        if (source instanceof StreamSource) {
            return this.unmarshal(AbstractUnmarshallerImpl.streamSourceToInputSource((StreamSource)source));
        }
        if (source instanceof DOMSource) {
            return this.unmarshal(((DOMSource)source).getNode());
        }
        throw new IllegalArgumentException();
    }

    private final Object unmarshal(SAXSource source) throws JAXBException {
        XMLReader reader = source.getXMLReader();
        if (reader == null) {
            reader = this.getXMLReader();
        }
        return this.unmarshal(reader, source.getInputSource());
    }

    protected abstract Object unmarshal(XMLReader var1, InputSource var2) throws JAXBException;

    public final Object unmarshal(InputSource source) throws JAXBException {
        if (source == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "source"));
        }
        return this.unmarshal(this.getXMLReader(), source);
    }

    private Object unmarshal(String url) throws JAXBException {
        return this.unmarshal(new InputSource(url));
    }

    public final Object unmarshal(URL url) throws JAXBException {
        if (url == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "url"));
        }
        return this.unmarshal(url.toExternalForm());
    }

    public final Object unmarshal(File f) throws JAXBException {
        if (f == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "file"));
        }
        try {
            String path = f.getAbsolutePath();
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/") && f.isDirectory()) {
                path = path + "/";
            }
            return this.unmarshal(new URL("file", "", path));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public final Object unmarshal(InputStream is) throws JAXBException {
        if (is == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "is"));
        }
        InputSource isrc = new InputSource(is);
        return this.unmarshal(isrc);
    }

    private static InputSource streamSourceToInputSource(StreamSource ss) {
        InputSource is = new InputSource();
        is.setSystemId(ss.getSystemId());
        is.setByteStream(ss.getInputStream());
        is.setCharacterStream(ss.getReader());
        return is;
    }

    public boolean isValidating() throws JAXBException {
        return this.validating;
    }

    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        this.eventHandler = handler == null ? new DefaultValidationEventHandler() : handler;
    }

    public void setValidating(boolean validating) throws JAXBException {
        this.validating = validating;
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.eventHandler;
    }

    protected UnmarshalException createUnmarshalException(SAXException e) {
        Exception nested = e.getException();
        if (nested instanceof UnmarshalException) {
            return (UnmarshalException)nested;
        }
        if (nested instanceof RuntimeException) {
            throw (RuntimeException)nested;
        }
        if (nested != null) {
            return new UnmarshalException(nested);
        }
        return new UnmarshalException(e);
    }

    public void setProperty(String name, Object value) throws PropertyException {
        if (name == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "name"));
        }
        throw new PropertyException(name, value);
    }

    public Object getProperty(String name) throws PropertyException {
        if (name == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "name"));
        }
        throw new PropertyException(name);
    }

    public abstract UnmarshallerHandler getUnmarshallerHandler();

    public abstract Object unmarshal(Node var1) throws JAXBException;
}

