/*
 * PROBE_JAVA_NAME.java
 *
 * PROBE_COPYRIGHT
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.io.*;

/**
 *
 * @author
 */
public class PROBE_JAVA_NAME extends AbstractDatabaseProbe {
    
    /** Creates a new instance of PROBE_JAVA_NAME */
    public PROBE_JAVA_NAME() {
        
        setName("PROBE_NAME");
	setFamily("Oracle");
        setCopyright("PROBE_COPYRIGHT");
        setVersion("PROBE_VERSION");
        setProbeId(PROBE_ID);
        
        addDepends("oracle/connection");
        String luserDir = System.getProperty("user.dir");
        addOption("oracle.file",luserDir+"/conf/CONFIG_NAME");
        
        setReport("PROBE_REPORT");
        
        setHelp("PROBE_HELP");
    }
    
    public void probe() throws ProbeException {
        
        String line;
        String qryStr = new String();

        try {
            
            if (! kbHas("oracle/connection"))
                return;

            con = (Connection) kbGet("oracle/connection");


            File sqlFile = new File(getOption("oracle.file"));

            BufferedReader br = new BufferedReader(new FileReader(sqlFile));

            while((line = br.readLine()) != null) {
                qryStr = qryStr.concat(line+"\n");
            }

            Statement stmt = con.createStatement();
            stmt.executeUpdate("BEGIN dbms_output.enable; END;");

            stmt.executeUpdate(qryStr);

            CallableStatement cstmt = con.prepareCall("{call dbms_output.get_line(?,?)}");

            setReportable(true);

            cstmt.registerOutParameter(1, Types.VARCHAR);
            cstmt.registerOutParameter(2, Types.INTEGER);

            cstmt.execute();
            while (cstmt.getInt(2) == 0) {
                addReport(cstmt.getString(1));
                cstmt.execute();
            }

        } catch (SQLException e) {
            throw(new ProbeException(e.getMessage()));
        } catch (IOException e) {
            throw(new ProbeException(e.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
