/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * MssqlLoginStats.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;

/**
 *
 * @author  visigoth
 */
public class MssqlLoginStats extends AbstractDatabaseProbe {
    
    /** Creates a new instance of MssqlLoginStats */
    public MssqlLoginStats() {
        
        setName("MSSQL Login Stats");
        setFamily("MS SQL");
        setVersion("$Id: MssqlLoginStats.java,v 1.7 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(18);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mssql/connection");
        
        setReport("Current Login Statistics:\n"+
                  "Name\tValue\n"+
                  "----------------------------\n");

        setHelp("This probe attemtps to determine current login statistics "+
                "such as currently logged in users and logins/outs /sec\n");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("mssql/connection"))
                return;
            
            con = (Connection) kbGet("mssql/connection");
            
            Statement stmt = con.createStatement();
            res = stmt.executeQuery("SELECT * FROM sysperfinfo WHERE object_name LIKE '%General Statistics%'");
            
            setReportable(true);
            
            while (res.next()) {
                String name = res.getString("counter_name").trim();
                int val = res.getInt("cntr_value");
                addReport(name+"\t"+val);
            }

        } catch (SQLException se) {
            throw(new ProbeException("Lack of Permission? " + se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
