/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * MssqlWeakAccounts.java
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.util.*;
import java.io.*;
import java.sql.*;

/**
 *
 * @author  visigoth
 */
public class MssqlWeakAccounts extends AbstractAuthProbe {
    
    /** Creates a new instance of MssqlWeakAccounts */
    public MssqlWeakAccounts() {
        
        setName("Mssql Weak Accounts");
        setFamily("MS SQL");
        setBrute(true);
        setVersion("$Id: MssqlWeakAccounts.java,v 1.9 2003/10/02 02:20:43 visigoth_6 Exp $");
        setProbeId(19);
        setTimeout(0);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mssql/connection");
        addProvides("mssql/accounts","java.util.Properties of weak username/passwords");

        // Any weak accounts are critical
        setSeverity(3);

        addOption("dictionary",System.getProperty("user.dir")+"/conf/dict.txt");
        
        setReport("Found Weak Accounts:\n"+
                  "USER\tPASS\n"+
                  "=================================\n");
        
        setHelp("This probe attemtps to enumerate weak passwords. ");
    }
    
    public boolean shouldRun() throws ProbeException {
        if (!kbHas("mssql/connection"))
            return(false);
        
        try {
            con = (Connection)kbGet("mssql/connection");
            stmt = con.prepareStatement("SELECT name FROM sysxlogins WHERE pwdcompare( ?, password) = 1");
            
        } catch (SQLException e) {
            throw(new ProbeException(e.getMessage()));
        }
        
        return(true);
    }
    
    public int test(String pass) throws ProbeException {
        int myCount = 0;
        try {
            stmt.setString(1,pass);
            ResultSet res = stmt.executeQuery();
            
            while (res.next()) {
                addReport(res.getString("name")+" : "+pass);
                myCount++;
            }
            
        } catch (SQLException se) {
            throw(new ProbeException("SQL error: "+se.getMessage()));
        }
        return(myCount);
        //kbPut("mssql/accounts", accounts);
    }
    Connection con = null;
    Statement nullStmt = null;
    PreparedStatement stmt = null;
}
