/*
 *
 * (c) visigoth <visigoth@securitycentric.com>
 *
 * MysqlVariables.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.util.*;

/**
 *
 * @author
 */
public class MysqlConfig extends AbstractDatabaseProbe {
    
    /** Creates a new instance of MysqlVariables */
    public MysqlConfig() {
        
        setName("MySQL Configuration");
        setFamily("MySQL");
        setVersion("1.0");
        setProbeId(47);
        setCopyright("(c) visigoth <visigoth@securitycentric.com>");
        setSeverity(0);
        
        addProvides("mysql/Configuration","String of config file contents");
        addDepends("mysql/connection");
        addDepends("mysql/Variables");
        
        addOption("my.cnf location","/etc/my.cnf");
        
        setReport("The MySQL (my.cnf) configuration:\n");
        setHelp("This probe enumerates all the configuration options which "+
        "are available in known mysql configuration files such as "+
        "/etc/my.cnf and DATADIR/my.cnf.  These options are then later"+
        "used by additional analysis probes");
    }
    
    /* We'll load the tables full of the config files in their order of
     * precidence so when we iterate them later, we'll pick up the overrieds
     */
    public void probe() throws ProbeException {
        
        if (! kbHas("mysql/connection"))
            return;
        
        con = (Connection) kbGet("mysql/connection");
        try {
            
            stmt = con.createStatement();
            stmt.execute("CREATE TEMPORARY TABLE MCTX_myconf (line varchar(128))");
            
            stmt.execute("LOAD DATA INFILE \'"+
            getOption("my.cnf location")+
            "\' INTO TABLE MCTX_myconf");
            
            
            
        } catch (SQLException se) {
            throw(new ProbeException(se.getMessage()));
        }
        
        try {
            Properties prop = (Properties)kbGet("mysql/Variables");
            
            if (prop != null) {
                String datadir = prop.getProperty("datadir");
                
                stmt.execute("LOAD DATA INFILE \'"+
                             datadir+"my.cnf"+
                             "\' INTO TABLE MCTX_myconf");
            }
            
        } catch (SQLException e) {
            addReport("DATADIR/my.cnf not found");
        }
        
        try {
            
            res = stmt.executeQuery("SELECT * FROM MCTX_myconf");
            
            addReport("==============================");
            
            while (res.next()) {
                addReport(res.getString(1));
                configStr = configStr.concat(res.getString(1));
            }
            
            setReportable(true);
            
        } catch (SQLException e) {
            throw(new ProbeException(e.getMessage()));
        }
        
        kbPut("mysql/Configuration",configStr);
    }
    
    Connection con;
    Statement stmt;
    ResultSet res;
    String configStr = new String();
}
