/*
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

/**
 *
 * @author  visigoth
 */
public class MysqlDoubleFree extends AbstractVersionProbe {
    
    /** Creates a new instance of MysqlWorldWriteFiles */
    public MysqlDoubleFree() {
        
        setName("Mysql Double Free");
        setFamily("MySQL");
        setVersion("$Id: MysqlDoubleFree.java,v 1.2 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(44);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mysql/Version");
        
        setHelp("This probe checks for Mysql Version < 3.23.55 to enumerate"+
		" CVE: CAN-2003-0073 (Double Free Vulnerability)");

        setReport("Double-free vulnerability in mysqld for MySQL before "+
		  "3.23.55 allows attackers with MySQL access to cause a "+
		  "denial of service or possibly execute arbitrary code  "+
		  "via mysql_change_user. CVE: CAN-2003-0073");
        setSeverity(3);

        setKbKey("mysql/Version");
        setMatchRelease(true);
        setTestVersion("3.23.55");
    }
}
