/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * OracleDbas.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;

/**
 *
 * @author  visigoth
 */
public class OracleDbas extends AbstractDatabaseProbe {
    
    /** Creates a new instance of OracleUsers */
    public OracleDbas() {
        
        setName("Oracle DBAs");
        setFamily("Oracle");
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        setVersion("$Id: OracleDbas.java,v 1.5 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(6);
        
        addDepends("oracle/connection");
        
        setReport("Found Oracle DBAs: \n");
        
        setHelp("This probe attemtps to enumerate all users with the DBA role. "+
                "It will only be capable of doing so if the JDBC Connection "+
                "stored in oracle/connection has sufficient privelages\n");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("oracle/connection"))
                return;
            
            con = (Connection)kbGet("oracle/connection");
            
            PreparedStatement ps = con.prepareStatement("SELECT grantee FROM sys.dba_role_privs where granted_role='DBA'");
            res = ps.executeQuery();
            
            setReportable(true);
            
            addResultSet(res);
                
        } catch (SQLException se) {
            throw(new ProbeException(se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
