/*
 *
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 * OracleSessions.java
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.util.*;

/**
 *
 * @author  
 */
public class OracleSessions extends AbstractDatabaseProbe {
    
    /** Creates a new instance of OracleSessions */
    public OracleSessions() {
        
        setName("Oracle Sessions");
        setFamily("Oracle");
        setVersion("$Id: OracleSessions.java,v 1.2 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(35);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        setSeverity(0);
        
        addDepends("oracle/connection");
        
        setReport("Currently Active Oracle Sessions:");
        
        setHelp("This probe enumerates the currently connected non-BACKGROUND sessions in the Oracle server.");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("oracle/connection"))
                return;

            con = (Connection) kbGet("oracle/connection");
            
            Statement stmt = con.createStatement();
            res = stmt.executeQuery("SELECT username, machine AS from_host, osuser AS os_user, logon_time FROM gv$session WHERE TYPE != 'BACKGROUND' ORDER BY logon_time DESC");
            
            setReportable(true);
            addResultSet(res);

        } catch (SQLException se) {
            throw(new ProbeException(se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
