/*
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license.
 * Please see the LICENSE file for details.
 *
 * OracleTNSSecurity.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.util.*;
import java.io.*;
import java.net.*;

/**
 *
 * @author  visigoth
 */
public class OracleTNSSecurity extends AbstractDatabaseProbe {
    
    /** Creates a new instance of OracleTNSSecurity */
    public OracleTNSSecurity() {
        setName("Oracle TNS Security");
        setFamily("Oracle");
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        setVersion("$Id: OracleTNSSecurity.java,v 1.4 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(13);

        setHelp("This probe tests to confirm TNS requires password");
        
        addDepends("oracle/status");
    }
    
    public void probe() throws ProbeException {

        if (! kbHas("oracle/status"))
            return;

        status = (String)kbGet("oracle/status");

        sec = status.substring(status.indexOf(secKey));

        if (! sec.startsWith("SECURITY=ON")) {
            setReport("Oracle TNS Does Not Require Password!");
            setReportable(true);
            setSeverity(3);
        }
    }

    String status;
    String sec;
    String secKey = "SECURITY=";
}
