/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.StringWriter;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.translate.CharSequenceTranslator;

public final class LookupTranslator
extends CharSequenceTranslator {
    public final HashMap lookupMap;
    public final BitSet prefixSet;
    public final int shortest;
    public final int longest;

    public LookupTranslator(Map map) {
        if (map != null) {
            LookupTranslator lookupTranslator = this;
            lookupTranslator.lookupMap = new HashMap();
            lookupTranslator.prefixSet = new BitSet();
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            for (Map.Entry entry : map.entrySet()) {
                LookupTranslator lookupTranslator2 = this;
                lookupTranslator2.lookupMap.put(((CharSequence)entry.getKey()).toString(), ((CharSequence)entry.getValue()).toString());
                lookupTranslator2.prefixSet.set(((CharSequence)entry.getKey()).charAt(0));
                int n3 = ((CharSequence)entry.getKey()).length();
                if (n3 < n) {
                    n = n3;
                }
                if (n3 <= n2) continue;
                n2 = n3;
            }
            LookupTranslator lookupTranslator3 = this;
            lookupTranslator3.shortest = n;
            lookupTranslator3.longest = n2;
            return;
        }
        throw new InvalidParameterException("lookupMap cannot be null");
    }

    @Override
    public final int translate(CharSequence charSequence, int n, StringWriter stringWriter) {
        if (this.prefixSet.get(charSequence.charAt(n))) {
            int n2 = this.longest;
            if (n + n2 > charSequence.length()) {
                n2 = charSequence.length() - n;
            }
            while (n2 >= this.shortest) {
                int n3 = n;
                CharSequence charSequence2 = charSequence.subSequence(n3, n3 + n2);
                String string = (String)this.lookupMap.get(charSequence2.toString());
                if (string != null) {
                    CharSequence charSequence3 = charSequence2;
                    ((Writer)stringWriter).write(string);
                    return Character.codePointCount(charSequence3, 0, charSequence3.length());
                }
                --n2;
            }
        }
        return 0;
    }
}

