# -*- coding: utf_8 -*-
"""Perform behaviour analysis."""
import logging
from pathlib import Path

from django.conf import settings

from mobsf.MobSF.utils import (
    append_scan_status,
)

logger = logging.getLogger(__name__)


def analyze(checksum, sast, data):
    """Perform behaviour analysis."""
    try:
        root = Path(settings.BASE_DIR) / 'MalwareAnalyzer' / 'views'
        rules = root / 'android' / 'rules' / 'behaviour_rules.yaml'
        msg = 'Android Behaviour Analysis Started'
        logger.info(msg)
        append_scan_status(checksum, msg)
        behaviour_finds = sast.run_rules(data, rules.as_posix())
        msg = 'Android Behaviour Analysis Completed'
        logger.info(msg)
        append_scan_status(checksum, msg)
        return behaviour_finds
    except Exception as exp:
        msg = 'Failed to perform behaviour analysis'
        logger.exception(msg)
        append_scan_status(checksum, msg, repr(exp))
    return {}
