/*
 * Decompiled with CFR 0.152.
 */
package net.cqure;

import net.cqure.AddressOctet;
import net.cqure.IAddressPool;
import net.cqure.exception.InvalidAddressException;

public class AddressRange
implements IAddressPool {
    private String m_strIP;
    private AddressOctet[] m_aOctets = new AddressOctet[4];
    private boolean m_bFirst = true;

    public AddressRange(String strIP) throws InvalidAddressException {
        this.m_strIP = strIP;
        this.parseAddress();
    }

    private void parseAddress() throws InvalidAddressException {
        String[] strOctets = this.m_strIP.split("\\.");
        if (4 != strOctets.length) {
            throw new InvalidAddressException("Invalid address range: " + this.m_strIP);
        }
        int i = 0;
        while (i < 4) {
            this.m_aOctets[i] = new AddressOctet(strOctets[i]);
            ++i;
        }
    }

    public String getNextAddress() {
        String strAddress = "";
        int[] nOctets = new int[4];
        int nResets = 0;
        if (!this.m_bFirst) {
            int i = 3;
            while (i >= 0) {
                nOctets[i] = this.m_aOctets[i].getNextOctet();
                if (-1 == nOctets[i]) {
                    this.m_aOctets[i].reset();
                    nOctets[i] = this.m_aOctets[i].getOctet();
                    ++nResets;
                    --i;
                    continue;
                }
                break;
            }
        } else {
            this.m_bFirst = false;
        }
        strAddress = String.valueOf(this.m_aOctets[0].getOctet()) + "." + this.m_aOctets[1].getOctet() + "." + this.m_aOctets[2].getOctet() + "." + this.m_aOctets[3].getOctet();
        if (4 == nResets) {
            return null;
        }
        return strAddress;
    }
}

