# NOTE: Derived from blib/lib/Net/SOCKS.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Net::SOCKS;

#line 298 "blib/lib/Net/SOCKS.pm (autosplit into blib/lib/auto/Net/SOCKS/_validate.al)"
# Validate that destination host/port exists

sub _validate {
  my $self = shift;

  # check the method parameters
  unless (defined ${*self}{socks_addr} && length ${*self}{socks_addr}) {
    return ${*self}{status_num} = SOCKS_MISSING_SOCKS_SERVER_NET_DATA;
  }
  unless (defined ${*self}{socks_port} && ${*self}{socks_port} > 0) {
    return ${*self}{status_num} = SOCKS_MISSING_SOCKS_SERVER_NET_DATA;
  }
  unless (defined ${*self}{peer_addr} && length ${*self}{peer_addr}) {
    return ${*self}{status_num} = SOCKS_MISSING_PEER_NET_DATA;
  }
  unless (defined ${*self}{peer_port} && ${*self}{peer_port} > 0) {
    return ${*self}{status_num} = SOCKS_MISSING_PEER_NET_DATA;
  }
  unless (defined ${*self}{protocol_version} &&
          (${*self}{protocol_version}==4 || ${*self}{protocol_version}==5) ) {
    return ${*self}{status_num} = SOCKS_UNSUPPORTED_PROTOCOL_VERSION;
  }

  if (${*self}{protocol_version}==5 && defined ${*self}{user_id} 
     && length(${*self}{user_id})>0 && (! defined ${*self}{user_password}
     || length(${*self}{user_password}) == 0 ) ) {
    return ${*self}{status_num} = SOCKS_INCOMPLETE_AUTH;
  }

  if ( ! defined ${*self}{user_id} ) {  ${*self}{user_id}='' }

  return ${*self}{status_num} = SOCKS_OKAY;
}

# end of Net::SOCKS::_validate
1;
